
# source(paste0(dir_func,"f_wk.R"))
# Functions that convert date to week and vice versa

# function that returns week
f_wk <- function(date, date_orig="2019-12-29") {
  return(as.integer(floor((as.Date(date)-as.Date(date_orig))/7))+1) # date_orig is the Sunday of the first week
}

# function that returns the n-th day of week
f_wkdate <- function(week, wkd=6, date_orig="2019-12-29") {
  return(as.Date(date_orig)+7*(week-1)+wkd)
}

# function that returns number of days for each week
f_ndaywk <- function(sdt_in,vweek="week",vdate="date",date_orig="2019-12-29") {
  
  if (! vweek %in% names(get(sdt_in,envir=parent.frame()))) {
    get(sdt_in,envir=parent.frame())[,(vweek):=f_wk(get(vdate),date_orig)]
  }
  dt_date <- unique(get(sdt_in,envir=parent.frame())[,.SD,.SDcols=c(vweek,vdate)])[,.(ndaywk=.N),by=c(vweek)]
  
  for (i in c(1:nrow(dt_date))) {
    get(sdt_in,envir=parent.frame())[get(vweek)==dt_date[i,get(vweek)], ndaywk:=dt_date[i,ndaywk]]
  }
}

# End of R script
