
# source(paste0(dir_func,"f_ratio.R"))

source(paste0(dir_func,"f_wk.R"))

f_ifelse <- function(vlogic, re_true, re_false) {
  if (vlogic) {
    return(re_true)
  } else {
    return(re_false)
  }
}

# Function that returns dt for base period
f_base <- function(dt_in,var_sum,var_by,freq="day") {
  var_base <- paste0(var_sum,"b")
  var_lapply <- f_ifelse(freq=="day",c(var_by,"wkd"),c(var_by))
  
  if ("date" %in% names(dt_in)) {
    dt_out <- dt_in[f_wk(date) %in% f_wk(c("2020-01-19","2020-02-01")), 
                    lapply(.SD, sum, na.rm=T), by=c(var_lapply),.SDcols=c(var_sum)]
  } else if ("week" %in% names(dt_in)) {
    dt_out <- dt_in[week %in% f_wk(c("2020-01-19","2020-02-01")), 
                    lapply(.SD, sum, na.rm=T), by=c(var_lapply),.SDcols=c(var_sum)]
  }
  
  setnames(dt_out, c(var_sum),c(var_base))
  dt_out[,(var_base):=(get(var_base))/2]
  return(dt_out)
}

# Function that returns dt by variable
f_ratio <- function(dt_in,var_sum,var_by,freq="day") {
  var_base <- paste0(var_sum,"b")
  var_lapply <- f_ifelse(freq=="day",c(var_by,"date","week","wkd"),c(var_by,"week"))
  var_merge <- f_ifelse(freq=="day",c(var_by,"wkd"),c(var_by))
  
  dt_base <- f_base(dt_in,c(var_sum),c(var_by),freq=freq)
  dt_out <- dt_in[,lapply(.SD, sum, na.rm=T), by=c(var_lapply),.SDcols=c(var_sum)]
  dt_out <- merge(dt_out, dt_base, by=c(var_merge), all.x=T)
  dt_out[, (paste0("r_",var_sum)):=get(var_sum)/get(var_base)]
  return(dt_out)
}

# End of R script
