
# source(paste0(dir_proj,"ws_0_f_qsubset.R"))

# dt_in <- copy(dt_surva)
# levels(dt_out$fQ)

f_qsubset <- function(dt_in, vq) {
  
  dt_out <- copy(dt_in)
  # Need to how NA are dealt with in conditions
  
  if (vq %in% c("fQ5")) {
    icode <- 'fQ4 %in% c("Yes")'
    eval(parse(text=paste0('dt_out <- dt_out[',icode,',]')))
    cat(paste0("Subset for ", vq, ":\n", icode))
  }
  if (vq %in% c("fQ8")) {
    icode <- 'fQ7 %in% c("My work hours were reduced by my employer",
    "I was furloughed or temporarily assigned 0 paid hours but am still technically employed",
    "I decided not to work to protect myself/my family from exposure to coronavirus",
    "I am unable to work because I am caring for a family member")'
    eval(parse(text=paste0('dt_out <- dt_out[',icode,',]')))
    cat(paste0("Subset for ", vq, ":\n", icode))
  }
  if (vq %in% c("fQ9")) {
    icode <- 'fQ8 %in% c("Yes")'
    eval(parse(text=paste0('dt_out <- dt_out[',icode,',]')))
    cat(paste0("Subset for ", vq, ":\n", icode))
  }
  if (vq %in% c("fQ10","fQ12","fQ25")) {
    icode <- 'fQ7 %in% c("My work hours were reduced by my employer",
    "I have been laid off",
    "I was furloughed or temporarily assigned 0 paid hours but am still technically employed",
    "I decided not to work to protect myself/my family from exposure to coronavirus",
    "I am unable to work because I am caring for a family member") | fQ4 %in% c("No")'
    eval(parse(text=paste0('dt_out <- dt_out[',icode,',]')))
    cat(paste0("Subset for ", vq, ":\n", icode))
  }
  if (vq %in% c("fQ11","fQ17","Q21") | grepl("fQ15",vq)) {
    icode <- 'fQ7 %in% c("I have been laid off") | fQ4 %in% c("No")'
    eval(parse(text=paste0('dt_out <- dt_out[',icode,',]')))
    cat(paste0("Subset for ", vq, ":\n", icode))
  }
  # fQ12: fQ10
  if (grepl("fQ13_",vq)) {
    icode <- 'fQ12 %in% c("No")'
    eval(parse(text=paste0('dt_out <- dt_out[',icode,',]')))
    cat(paste0("Subset for ", vq, ":\n", icode))
  }
  # fQ15: fQ11
  if (grepl("fQ16",vq)) {
    icode <- '(fQ4 %in% c("Yes") | fQ7 %in% c("I chose to work fewer hours",
    "I chose to work more hours",
    "My work hours were reduced by my employer",
    "My work hours were increased by my employer",
    "I was furloughed or temporarily assigned 0 paid hours but am still technically employed")) 
    & (! fQ7 %in% c("I have been laid off"))
    & (!(fQ7 %in% c("I have been laid off") | fQ4 %in% c("No")))
    '
    # Not shown fQ15; no NA for (fQ7 %in% c("I have been laid off") | fQ4 %in% c("No"))
    dt_view <- dt_surv[is.na(fQ7 %in% c("I have been laid off") | fQ4 %in% c("No"))]
    eval(parse(text=paste0('dt_out <- dt_out[',icode,',]')))
    cat(paste0("Subset for ", vq, ":\n", icode))
  }
  # fQ17 ~ fQ15 ~ fQ11
  if (vq %in% c("fQ18","fQ19")) {
    icode <- 'fQ17 %in% c("Very Likely","Likely","Somewhat likely")'
    eval(parse(text=paste0('dt_out <- dt_out[',icode,',]')))
    cat(paste0("Subset for ", vq, ":\n", icode))
  }
  if (vq %in% c("fQ20")) {
    icode <- 'fQ19 %in% c("No, I do not plan to go back","I am undecided")'
    eval(parse(text=paste0('dt_out <- dt_out[',icode,',]')))
    cat(paste0("Subset for ", vq, ":\n", icode))
  }
  # fQ21: fQ11
  if (vq %in% c("Q22")) {
    # Need double check
    icode <- '(fQ4 %in% c("No") | !fQ7 %in% c("I have been laid off")) & !(fQ7 %in% c("I have been laid off") | fQ4 %in% c("No"))'
    eval(parse(text=paste0('dt_out <- dt_out[',icode,',]')))
    cat(paste0("Subset for ", vq, ":\n", icode))
  }
  # fQ25: fQ10
  if (grepl("fQ26",vq)) {
    icode <- 'fQ25 %in% c("No")'
    eval(parse(text=paste0('dt_out <- dt_out[',icode,',]')))
    cat(paste0("Subset for ", vq, ":\n", icode))
  }
  if (vq %in% c("fQ27")) {
    icode <- 'fQ25 %in% c("Yes")'
    eval(parse(text=paste0('dt_out <- dt_out[',icode,',]')))
    cat(paste0("Subset for ", vq, ":\n", icode))
  }
  if (vq %in% c("fQ28")) {
    icode <- 'fQ27 %in% c("No")'
    eval(parse(text=paste0('dt_out <- dt_out[',icode,',]')))
    cat(paste0("Subset for ", vq, ":\n", icode))
  }
  if (grepl("fQ30",vq)) {
    icode <- 'fQ29_1 %in% c(1)'
    eval(parse(text=paste0('dt_out <- dt_out[',icode,',]')))
    cat(paste0("Subset for ", vq, ":\n", icode))
  }
  
  return(dt_out)
}

# End of R script