# cd /accounts/projects/jrothst/homebase/data/bpea_replication_archive/code_data/
# sbatch --cpus-per-task=8 --mem=16g --export=ALL,script=ppp_unzip.R --partition=high zb_r.sh

sinfo <- commandArgs(trailingOnly = F)
args <- commandArgs(trailingOnly = T)

sys_user <- ifelse(Sys.getenv("USERNAME")!="", Sys.getenv("USERNAME"), Sys.getenv("USER"))
sys_cluster <- Sys.getenv("SLURM_CLUSTER_NAME")
sys_batch <- ifelse(interactive(), 0, 1)

if (sys_user=="homebase") { # For replication: Replace "homebase" with current username
  dir_func <- "/accounts/projects/jrothst/homebase/data/bpea_replication_archive/code_function/"
  # For replication: Replace with the path of the "code_function/" folder
}

source(paste0(dir_func, "0_directory.R"))
print(paste("Started at", Sys.time()))

library(data.table)

print(sessionInfo())
setwd(paste0(dir_proj))

#===============================================================================

izip <- paste0(dir_raw,"ppp/All Data by State.zip")
dt_zip <- data.table(unzip(izip,list=T))
dt_zip <- dt_zip[grepl("/foia_up_to_150k_.*?.csv|/foia_150k_plus.csv",Name)]

unzip(izip,files = dt_zip$Name,exdir = paste0(dir_raw,"ppp/"), junkpaths = T, setTimes = T)

print(paste("Ended at", Sys.time()))
# End of R script
