# cd /accounts/projects/jrothst/homebase/data/bpea_replication_archive/code_data/
# sbatch --cpus-per-task=1 --mem=4g --export=ALL,script=data_1_cw_owner.R zb_r.sh

sinfo <- commandArgs(trailingOnly = F)
args <- commandArgs(trailingOnly = T)

sys_user <- ifelse(Sys.getenv("USERNAME")!="", Sys.getenv("USERNAME"), Sys.getenv("SLURM_JOB_USER"))
sys_cluster <- Sys.getenv("SLURM_CLUSTER_NAME")
sys_batch <- ifelse(interactive(), 0, 1)

if (sys_user=="homebase") { # For replication: Replace "homebase" with current username
  dir_func <- "/accounts/projects/jrothst/homebase/data/bpea_replication_archive/code_function/"
  # For replication: Replace with the path of the "code_function/" folder
}

source(paste0(dir_func, "0_directory.R"))
print(paste("Started at", Sys.time()))

library(data.table)
library(haven)

print(sessionInfo())

setwd(paste0(dir_proj))

#===============================================================================

dt_cw <- fread(paste0(dir_raw,"cw/cw_owner.csv"),
               colClasses=list("character"="company_id", "character"="location_id", "character"="owner_id"))

# Check if each firm/est has one 1 owner

print("Firm")
dt_firm <- unique(dt_cw[, c("company_id","owner_id")])
dt_firm <- dt_firm[, .(nowner=.N), by=c("company_id")]
print(summary(dt_firm$nowner))

print("Establishment")
dt_est <- unique(dt_cw[, c("location_id","owner_id")])
dt_est <- dt_est[, .(nowner=.N), by=c("location_id")]
summary(dt_est$nowner)

# Export

saveRDS(dt_cw, paste0(dir_clean, "cw_owner.rds"))
write_dta(dt_cw, paste0(dir_clean, "cw_owner.dta"))

print(paste("Ended at", Sys.time()))
# End of R script
