# cd /accounts/projects/jrothst/homebase/data/bpea_replication_archive/code_data/
# sbatch --cpus-per-task=1 --mem=8g --export=ALL,script=cw_date_ui.R --partition=high zb_r.sh

sinfo <- commandArgs(trailingOnly = F)
args <- commandArgs(trailingOnly = T)

print(args)

sys_user <- ifelse(Sys.getenv("USERNAME")!="", Sys.getenv("USERNAME"), Sys.getenv("USER"))
sys_cluster <- Sys.getenv("SLURM_CLUSTER_NAME")
sys_batch <- ifelse(interactive(), 0, 1)

if (sys_user=="homebase") { # For replication: Replace "homebase" with current username
  dir_func <- "/accounts/projects/jrothst/homebase/data/bpea_replication_archive/code_function/"
  # For replication: Replace with the path of the "code_function/" folder
}

source(paste0(dir_func, "0_directory.R"))
print(paste("Started at", Sys.time()))

library(data.table)
library(haven)

print(sessionInfo())

setwd(paste0(dir_proj))

#===============================================================================

dt_ui <- data.table(haven::read_dta(paste0(dir_clean,"date/ui_covid_state.dta")))
dt_st <- readRDS(paste0(dir_clean,"cw/cw_geo_nber_state.rds"))[,State:=toupper(st2_str)]

dt_out <- merge(dt_ui[,c("State","date_PUA","date_FPUC")],
                dt_st[,c("stfips","st","st2","State")], by=c("State"), all.x=T)
dt_out[,State:=NULL]
setnames(dt_out, names(dt_out),tolower(names(dt_out)))
setcolorder(dt_out, c("st","st2","stfips","date_pua","date_fpuc"))
setnames(dt_out,c("date_pua","date_fpuc"),c("dpua","dfpuc"))

saveRDS(dt_out, paste0(dir_clean,"date/cw_date_ui.rds"))
haven::write_dta(dt_out, paste0(dir_clean,"date/cw_date_ui.dta"))

print(paste("Ended at", Sys.time()))
# End of R script
