# cd /accounts/projects/jrothst/homebase/data/bpea_replication_archive/code_data/
# sbatch --cpus-per-task=1 --mem=8g --export=ALL,script=cw_date_school.R --partition=high zb_r.sh

sinfo <- commandArgs(trailingOnly = F)
args <- commandArgs(trailingOnly = T)

print(args)

sys_user <- ifelse(Sys.getenv("USERNAME")!="", Sys.getenv("USERNAME"), Sys.getenv("USER"))
sys_cluster <- Sys.getenv("SLURM_CLUSTER_NAME")
sys_batch <- ifelse(interactive(), 0, 1)

if (sys_user=="homebase") { # For replication: Replace "homebase" with current username
  dir_func <- "/accounts/projects/jrothst/homebase/data/bpea_replication_archive/code_function/"
  # For replication: Replace with the path of the "code_function/" folder
}

source(paste0(dir_func, "0_directory.R"))
print(paste("Started at", Sys.time()))

library(data.table)

print(sessionInfo())

setwd(paste0(dir_proj))

#===============================================================================

dt_raw <- data.table(readxl::read_excel(paste0(dir_raw, "date/coronavirus-school-closures-data.xlsx"), sheet="States", skip = 1,
                                        col_types = c("text","text","text","text","date","date","text","text")))
setnames(dt_raw, c("State Abbreviation","State Closure Start Date","Date closed for the academic year"),c("st_str","dschool","dschool2"))
dt_raw[, dschool:=as.Date(dschool)]
dt_raw[, dschool2:=as.Date(dschool2)]
dt_st <- readRDS(paste0(dir_clean,"cw/cw_geo_nber_state.rds"))

dt_out <- merge(dt_raw[,c("st_str","dschool","dschool2")],
                dt_st[,c("stfips","st","st2","st_str")], by=c("st_str"), all.x=T)
dt_out[,st_str:=NULL]
setnames(dt_out, names(dt_out),tolower(names(dt_out)))
setcolorder(dt_out, c("st","st2","stfips","dschool","dschool2"))

# Manuall adjust some dates
print(dt_out[st=="WI"])
dt_out[st=="WI",dschool:=as.Date("2020-03-19")]
print(dt_out[st=="WI"])

saveRDS(dt_out[!is.na(st)], paste0(dir_clean,"date/cw_date_school.rds"))
haven::write_dta(dt_out[!is.na(st)], paste0(dir_clean,"date/cw_date_school.dta"))

print(paste("Ended at", Sys.time()))
# End of R script
