#!/bin/bash
#SBATCH --time=7-00:00:00
#SBATCH --output=log/log_R_out.out
#SBATCH --error=log/log_R_err.err

# sbatch --cpus-per-task=1 --mem=4g --export=ALL,script=.R zb_r.sh

# create a new scratch directory for this job
# scratch_dir="/project/BertrandKamenica/scratch/$SLURM_JOB_USER/$SLURM_JOB_ID"
# mkdir -p $scratch_dir

# use scratch dir to store tmp files
# export TMPDIR=$scratch_dir

# Load the module with the desired version of R
module load R/3.6.1

# If ${log} is empty, use default log file
if [ -z "${log}" ]
then
    log="${script::-2}.Rout"
fi

# run Rscript
Rscript  ${script} ${param} > ${log} 2>&1

# remove scratch directory when done
# rm -rf $scratch_dir