# cd /accounts/projects/jrothst/homebase/data/bpea_replication_archive/code/
# sbatch --cpus-per-task=6 --mem=96g --export=ALL,script=bpea_1_firm_survival.R,param="T" --partition=low zb_r.sh
# cd /accounts/projects/jrothst/homebase/data/1_do_bpea/
# sbatch --cpus-per-task=6 --mem=96g --export=ALL,script=bpea_1_firm_survival.R,param="F" --partition=low zb_r.sh

sinfo <- commandArgs(trailingOnly = F)
args <- commandArgs(trailingOnly = T)

print(args)
bpea_rep <- ifelse(!exists("bpea_rep"), ifelse(length(args)==0,T,eval(parse(text=args[1]))), bpea_rep)

sys_user <- ifelse(Sys.getenv("USERNAME")!="", Sys.getenv("USERNAME"), Sys.getenv("USER"))
sys_cluster <- Sys.getenv("SLURM_CLUSTER_NAME")
sys_batch <- ifelse(interactive(), 0, 1)

if (sys_user=="homebase" & bpea_rep==T) { # For replication: Replace "homebase" with current username
  dir_func <- "/accounts/projects/jrothst/homebase/data/bpea_replication_archive/code_function/"
  # For replication: Replace with the path of the "code_function/" folder.
} else if (sys_user=="homebase" & bpea_rep==F) {
  dir_func <- "/accounts/projects/jrothst/homebase/data/0_function/"
}

source(paste0(dir_func, "0_directory.R"))
source(paste0(dir_proj, ifelse(bpea_rep==T,"code/bpea_0_directory.R","1_do_bpea/bpea_0_directory.R")))

print(paste("Started at", Sys.time()))

library(data.table)

print(sessionInfo())
setwd(paste0(dir_proj))

#===============================================================================

source(paste0(dir_func, "f_readhb.R"))
source(paste0(dir_func, "f_wk.R"))
source(paste0(dir_func, "f_ratio.R"))

#===============================================================================

lvfirm <- c("firmid","ind","st","msa")

if (sys_user=="homebase" & sys_batch==1) {
  # Data before 2020
  dt_raw0 <- f_readhb("all",geo_rep = T)[date<=as.Date("2019-12-31")]
  dt_raw0[, week:=f_wk(date)]
  dt_raw0[, weekd:=f_wkdate(week)]
  # Data in 2020
  dt_raw <- f_readhb("2020_update", geo_rep = T)
  # rbind and clean
  dt_raw <- rbind(dt_raw0, dt_raw, fill=T)
  dt_raw[, ndaywk:=NULL]
  f_ndaywk("dt_raw","week","date")
  rm(dt_raw0)
  gc()
} else {
  dt_raw <- f_readhb("2020_update") 
}

f_firm <- function(iyear) {
  dt_firm <- readRDS(paste0(dir_clean,"homebase_sel_firm_ind_geo",paste0("_",iyear),".rds"))
}

dt_info <- data.table(year=c(2018,2019,2020),
                      date1=c(as.Date("2018-01-21"),as.Date("2019-01-20"),as.Date("2020-01-19")),
                      date2=c(as.Date("2018-02-03"),as.Date("2019-02-02"),as.Date("2020-02-01")))

#===============================================================================
# Subset data

# Find last week (since base)
max_dur <- max(dt_raw[ndaywk==7,week]) - f_wk("2020-01-19")

iyear <- 2020

dt_out <- data.table()

for (iyear in c(2018:2020)) {

dt_firm <- f_firm(iyear)
dt_sel <- dt_raw[stfips<=56 & ndaywk==7, lapply(.SD, sum, na.rm=T), by=c("week","weekd",lvfirm), .SDcols=c("hours")]
dt_sel <- merge(dt_sel,dt_firm[,.SD,.SDcols=c(lvfirm,"firm_base_2wk","st_sel_2wk")],by=c(lvfirm),all.x=T)[firm_base_2wk==1 & st_sel_2wk==1] # subset firms
print(names(dt_sel))

dti_out <- dt_sel[week>=f_wk(dt_info[year==iyear,date1]) & week<=f_wk(dt_info[year==iyear,date1])+max_dur]
dti_out[, week_max:=max(week), by=c(lvfirm)]
# Get missing weeks
dti_out <- dcast(dti_out, firmid + ind + st + msa + week_max ~ week, value.var = c("hours"))
# setnafill(dti_out, fill=0)
dti_out[is.na(dti_out)] <- 0
dti_out <- melt(dti_out, id.vars=c(lvfirm,"week_max"), variable.name = "week", variable.factor = F, value.name = "hours")
dti_out[, week:=as.integer(week)]
dti_out[, weekd:=f_wkdate(week)]
setorderv(dti_out, c(lvfirm,"week"))

dti_out[, nf:=1]
dti_out[, nfsurvival:=ifelse(week_max>=week,1,0)]
dti_out[, nfactive:=ifelse(hours>0,1,0)]

dti_out <- dti_out[,lapply(.SD,sum,na.rm=T),by=c("week","weekd"),.SDcols=patterns("^nf|hours")]

dti_out[, sfsurvival:=nfsurvival/nf]
dti_out[, sfactive:=nfactive/nf]

dt_out <- rbind(dt_out, dti_out[, year:=iyear])

}

saveRDS(dt_out,paste0(dir_exp,"firm_survival.rds"))

print(paste("Ended at", Sys.time()))
# End of R script
