# cd /accounts/projects/jrothst/homebase/data/bpea_replication_archive/code/
# sbatch --cpus-per-task=6 --mem=16g --export=ALL,script=bpea_1_event_study_reg.R,param="T" --partition=high zb_r.sh
# cd /accounts/projects/jrothst/homebase/data/1_do_bpea/
# sbatch --cpus-per-task=6 --mem=16g --export=ALL,script=bpea_1_event_study_reg.R,param="F" --partition=high zb_r.sh

sinfo <- commandArgs(trailingOnly = F)
args <- commandArgs(trailingOnly = T)

print(args)
bpea_rep <- ifelse(!exists("bpea_rep"), ifelse(length(args)==0,T,eval(parse(text=args[1]))), bpea_rep)

sys_user <- ifelse(Sys.getenv("USERNAME")!="", Sys.getenv("USERNAME"), Sys.getenv("USER"))
sys_cluster <- Sys.getenv("SLURM_CLUSTER_NAME")
sys_batch <- ifelse(interactive(), 0, 1)

if (sys_user=="homebase" & bpea_rep==T) { # For replication: Replace "homebase" with current username
  dir_func <- "/accounts/projects/jrothst/homebase/data/bpea_replication_archive/code_function/"
  # For replication: Replace with the path of the "code_function/" folder.
} else if (sys_user=="homebase" & bpea_rep==F) {
  dir_func <- "/accounts/projects/jrothst/homebase/data/0_function/"
}

source(paste0(dir_func, "0_directory.R"))
source(paste0(dir_proj, ifelse(bpea_rep==T,"code/bpea_0_directory.R","1_do_bpea/bpea_0_directory.R")))

print(paste("Started at", Sys.time()))

library(data.table)

print(sessionInfo())
setwd(paste0(dir_proj))

#===============================================================================

source(paste0(dir_func,"f_wk.R"))
source(paste0(dir_func,"f_ratio.R"))

#===============================================================================
# Regressions

load(paste0(dir_es,"es_data.rdata"))
source(paste0(dir_dobpea,"bpea_0_f_reg.R"))

sel_week <- min(c(max(dt_hours[ndaywk==7,week]),
                  max(dt_visit[ndaywk==7,week])))
print(paste("Last Week:", sel_week, f_wkdate(sel_week)))

#-------------------------------------------------------------------------------
# All industries

dt_info <- data.table(dt=c("dt_hours","dt_visit","dt_case","dt_death","dt_gg"),
                      lhs=c("ln_r_hours","ln_r_visit","ln_casep","ln_deathp","hits"),
                      tlhs=c("hours","visit","case","death","hits"))

sdt="dt_hours"
iordrt="stay"

for (sdt in c("dt_hours","dt_visit")) {
  
  dt_in <- copy(get(sdt))[week<=sel_week]
  
  for (iordrt in c("stay","reop","school")) {
    
    lm_out <- f_regst(dt_in,reg_lhs=dt_info[dt==sdt,lhs],reg_ord=iordrt,reg_type="res",reg_stdate=F,
                      save_dt=paste0(dir_es,"dt_reg/esreg_data_res_",iordrt,"_",dt_info[dt==sdt,tlhs]))
    saveRDS(lm_out, paste0(dir_es,"esreg_res_",iordrt,"_",dt_info[dt==sdt,tlhs],".rds"))
    
    lm_out <- f_regst(dt_in,reg_lhs=dt_info[dt==sdt,lhs],reg_ord=iordrt,reg_type="res",reg_stdate=T,
                      save_dt=paste0(dir_es,"dt_reg/esreg_data_res_",iordrt,"_",dt_info[dt==sdt,tlhs],"_stdate"))
    saveRDS(lm_out, paste0(dir_es,"esreg_res_",iordrt,"_",dt_info[dt==sdt,tlhs],"_stdate.rds"))
  }
  
  iordrt <- "stay_end"
  lm_out <- f_regst(dt_in,reg_lhs=dt_info[dt==sdt,lhs],reg_ord=iordrt,reg_type="res",reg_stdate=T,reg_drange=c("2020-04-06","2020-07-11"),
                    save_dt=paste0(dir_es,"dt_reg/esreg_data_res_",iordrt,"_",dt_info[dt==sdt,tlhs],"_stdate"))
  saveRDS(lm_out, paste0(dir_es,"esreg_res_",iordrt,"_",dt_info[dt==sdt,tlhs],"_stdate.rds"))
  
}

for (sdt in c("dt_hours","dt_visit")) {
  
  dt_in <- copy(get(sdt))[week<=sel_week]
  
  for (iordrt in c("pua","fpuc","school")) {
    
    lm_out <- f_regst(dt_in,reg_lhs=dt_info[dt==sdt,lhs],reg_ord=iordrt,reg_type="es",
                      save_dt=paste0(dir_es,"dt_reg/esreg_data_es_",iordrt,"_",dt_info[dt==sdt,tlhs]))
    saveRDS(lm_out, paste0(dir_es,"esreg_es_",iordrt,"_",dt_info[dt==sdt,tlhs],".rds"))
  }
  
}

print(paste("Ended at", Sys.time()))
# End of R script
