# cd /accounts/projects/jrothst/homebase/data/bpea_replication_archive/code/
# sbatch --cpus-per-task=6 --mem=32g --export=ALL,script=bpea_1_event_study_data.R,param="T" --partition=high zb_r.sh
# cd /accounts/projects/jrothst/homebase/data/1_do_bpea/
# sbatch --cpus-per-task=6 --mem=32g --export=ALL,script=bpea_1_event_study_data.R,param="F" --partition=high zb_r.sh

sinfo <- commandArgs(trailingOnly = F)
args <- commandArgs(trailingOnly = T)

print(args)
bpea_rep <- ifelse(!exists("bpea_rep"), ifelse(length(args)==0,T,eval(parse(text=args[1]))), bpea_rep)

sys_user <- ifelse(Sys.getenv("USERNAME")!="", Sys.getenv("USERNAME"), Sys.getenv("USER"))
sys_cluster <- Sys.getenv("SLURM_CLUSTER_NAME")
sys_batch <- ifelse(interactive(), 0, 1)

if (sys_user=="homebase" & bpea_rep==T) { # For replication: Replace "homebase" with current username
  dir_func <- "/accounts/projects/jrothst/homebase/data/bpea_replication_archive/code_function/"
  # For replication: Replace with the path of the "code_function/" folder.
} else if (sys_user=="homebase" & bpea_rep==F) {
  dir_func <- "/accounts/projects/jrothst/homebase/data/0_function/"
}

source(paste0(dir_func, "0_directory.R"))
source(paste0(dir_proj, ifelse(bpea_rep==T,"code/bpea_0_directory.R","1_do_bpea/bpea_0_directory.R")))

print(paste("Started at", Sys.time()))

library(data.table)

print(sessionInfo())
setwd(paste0(dir_proj))

#===============================================================================

source(paste0(dir_func,"f_wk.R"))
source(paste0(dir_func,"f_ratio.R"))

#===============================================================================
# Regressions

run_agg <- T
run_ind <- T

# source(paste0(dir_dobpea,"bpea_0_s_data.R"))

run_agg <- ifelse(!exists("run_agg"),T,run_agg)
run_ind <- ifelse(!exists("run_ind"),F,run_ind)

#---------------------------------------
# Hours

dt_hb <- readRDS(paste0(dir_clean, "homebase_firm_ind_geo_date_2020.rds"))[firm_base_2wk==1 & st_sel_2wk==1,]
dt_hb[,week:=f_wk(date)]

# Aggregate
if (run_agg==T) {
  dt_hours <- f_ratio(dt_hb,var_sum="hours",var_by="st",freq="day")
  f_ndaywk("dt_hours",vweek="week",vdate="date")
  dt_hours[, ln_r_hours:=log(r_hours)]
}

#---------------------------------------
# Visit

dt_sg <- readRDS(paste0(dir_clean,"safegraph/safegraph_agg_ind_geo.rds"))
dt_norm <- data.table(readRDS(paste0(dir_clean, "safegraph/safegraph_visit_normalization_stats.rds")))
setnames(dt_norm, c("total_devices_seen"),c("tdev"))
dt_sg <- merge(dt_sg, dt_norm[,c("date","tdev")],by=c("date"),all.x=T)
dt_sg[, visito:=visit]
dt_sg[, visit:=visit/tdev]
dt_sg[, wkd:=as.POSIXlt(date)$wday] # Fix weekday

# Aggregate
if (run_agg==T) {
  dt_visit <- dt_sg[,lapply(.SD,sum,na.rm=T),by=c("st","date","week","wkd"),.SDcols=c("visit")]
  dt_visit <- f_ratio(dt_in=dt_visit,var_sum="visit",var_by="st",freq="day")
  f_ndaywk("dt_visit",vweek="week",vdate="date")
  dt_visit[, ln_r_visit:=log(r_visit)]
}

#---------------------------------------

save(dt_hours,dt_visit, file=paste0(dir_es,"es_data.rdata"))

print(paste("Ended at", Sys.time()))
# End of R script
