
# source(paste0(dir_proj,"1_do_bpea/f_reades.R))

#===============================================================================
# lm -> dt for event time

f_reades <- function(reg_type,reg_lhs,reg_ord,reg_stdate=F,
                     dir_es=paste0(dir_proj, "Output/bpea/event_study/"),lm_out=c()) {
  
  if (length(lm_out)==0) {
    lm_out <- readRDS(paste0(dir_es,"esreg_",reg_type,"_",reg_ord,"_",reg_lhs,ifelse(reg_stdate,"_stdate",""),".rds"))
  }
  
  lcoef <- lm_out$coefficients
  dt_out <- data.table(var=names(lcoef),coef=lcoef,ord=reg_ord)
  
  lm_ci <- confint(lm_out,level=0.95)
  dt_ci <- as.data.table(lm_ci,keep.rownames = T)
  setnames(dt_ci, names(dt_ci), c("var","ci_lb","ci_ub"))
  
  dt_out <- merge(dt_out, dt_ci, by=c("var"), all=T)
  
  dt_out[grepl("ie_.*?_nd_",var), nd_order:=sub("ie_.*?_nd_","",var)]
  dt_out[, nd_order:=as.integer(sub("n","-",nd_order))]
  
  nlord <- list("stay"="Shut-Down",
                "reop"="Reopen",
                "pua"="PUA",
                "fpuc"="FPUC",
                "school"="School Closure",
                "stay_end"="End of Shut-Down")
  lord <- factor(c(1:length(nlord)))
  levels(lord) <- unlist(unname(nlord))
  
  for (i in c(1:length(nlord))) {
    dt_out[grepl(paste0("ie_",names(nlord)[i],"_nd_"),var), order:=lord[i]]
  }
  dt_out <- dt_out[!is.na(order) & !is.na(coef),]
  
  # Assign 0 to baseline day
  dt_add <- data.table()
  for (iord in unique(dt_out[,order])) {
    day_min <- min(dt_out[order==iord, nd_order])
    day_max <- max(dt_out[order==iord, nd_order])
    dt_add <- rbind(dt_add, data.table(order=lord[lord==iord], nd_order=c(day_min:day_max)))
  }
  dt_out[, is_orig:=1]
  dt_out <- merge(dt_out, dt_add, by=c("order","nd_order"), all=T)
  if (nrow(dt_out[is.na(is_orig)])!=0) {
    print("Added Day")
    print(unique(dt_out[is.na(is_orig),c("order","nd_order")]))
    dt_out[is.na(is_orig), coef:=0]
    dt_out[is.na(is_orig), ci_lb:=0]
    dt_out[is.na(is_orig), ci_ub:=0]
  }
  
  dt_out[, lhs:=reg_lhs]
  
  return(dt_out)
}

#===============================================================================
# lm -> dt for calendar time

f_readesdfe <- function(reg_type,reg_lhs,reg_lord=c("stay","reop","school"),reg_stdate=F,
                        dir_es=paste0(dir_proj, "Output/bpea/event_study/"),
                        lm_out=c(),dt_out=c()) {
  
  if (length(lm_out)==0 & length(dt_out)==0) {
  dt_out <- data.table()
  for (iord in reg_lord) {
    if (! file.exists(paste0(dir_es,"esreg_",reg_type,"_",iord,"_",reg_lhs,ifelse(reg_stdate,"_stdate",""),".rds"))) {
      next
    }
    lm_out <- readRDS(paste0(dir_es,"esreg_",reg_type,"_",iord,"_",reg_lhs,ifelse(reg_stdate,"_stdate",""),".rds"))
    lcoef <- lm_out$coefficients
    dti_out <- data.table(ord=iord,var=names(lcoef),coef=lcoef)
    dt_out <- rbind(dt_out,dti_out)
  }
  } else if (length(lm_out)!=0) {
    dt_out <- data.table()
    lcoef <- lm_out$coefficients
    dti_out <- data.table(ord=reg_lord,var=names(lcoef),coef=lcoef)
    dt_out <- rbind(dt_out,dti_out)
  }
  
  # Extract linear trend for state
  if (reg_stdate==T) {
    dt_stdate <- dt_out[grepl("stdate",var),]
    dt_stdate <- dt_stdate[, lapply(.SD,mean,na.rm=T),by=c("ord"),.SDcols=c("coef")]
    setnames(dt_stdate, c("coef"), c("coef_stdate"))
  }
  
  dt_out <- dt_out[grepl("datef",var),]
  dt_out[, date:=as.Date(stringr::str_extract(var,"\\d{4}-\\d{2}-\\d{2}"))]
  
  # Adjust coefficient for model with linear trend
  if (reg_stdate==T) {
    dt_out <- merge(dt_out, dt_stdate, by=c("ord"),all.x=T)
    dt_out[, day20:=as.integer(date-as.Date("2020-01-01"))+1]
    dt_out[, coef_orig:=coef]
    dt_out[, coef:=coef + day20*coef_stdate]
  }
  
  nlord <- list("stay"="Shut-Down",
                "reop"="Reopen",
                "pua"="PUA",
                "fpuc"="FPUC",
                "school"="School Closure",
                "stay_end"="End of Shut-Down")
  lord <- factor(c(1:length(nlord)))
  levels(lord) <- unlist(unname(nlord))
  
  for (i in c(1:length(nlord))) {
    dt_out[grepl(paste0("^",names(nlord)[i],"$"),ord), order:=lord[i]]
  }
  dt_out <- dt_out[!is.na(order) & !is.na(coef),]
  
  # Adjust overlapped days
  lordadj <- c("reop","stay_end")
  lordadj <- lordadj[lordadj %in% unique(dt_out[,ord])]
  
  for (iordadj in lordadj) {
    print(paste0("Adjustment for ",iordadj))
    dt_overlap <- dt_out[ord %in% c("stay",iordadj),.(nord=.N),by=c("date")]
    adj_date <- median(dt_overlap[nord==2,date])
    adj_coef <- dt_out[date==adj_date & ord==iordadj, coef] - dt_out[date==adj_date & ord=="stay", coef]
    dt_out[ord==iordadj, coef:=coef-adj_coef]
    print(paste0("Date for adjustment: ", adj_date))
  }
  
  dt_out[, reg:=reg_type]
  dt_out[, lhs:=reg_lhs]
  
  return(dt_out)
  
}

# End of R script