# Output Scripts for BPEA Paper "Measuring the Labor Market at the Onset of the COVID-19 Crisis"

Scripts in this folder create figures and tables for the BPEA paper. The sequence of the scripts indicates potential dependency.

## Output (do files)

| Script | Description |
|:----------|:----------|
| `01_decomposition.do` | Identifies how hours worked for our baseline firms change each week relative to the baseline period.<br>We also decompose hours losses into shutdowns (where firms laid off all workers), layoffs at still open firms, and hours reductions by retained workers. <br><br> Uses:		`homebase_raw_2020_update.dta` <br> Creates: `decomposition_hoursreduction_byweek_withtextlabel.png` ; `decomposition.dta` | 
| `02_rehires_oct25.do` | Identifies, among the Homebase firms which reopened, after having shut down:<br>    (1) the share of hours relative to their baseline they have restored, and <br>    (2) the proportion of those restored work hours worked by previous employees versus new hires. <br><br> Uses: `homebase_raw_2020_update.dta` <br> Creates: `rehires_stackedbar.png`; `rehires_stackedbar.dta` |
| `03a_worker_history.do` | Use 2018-2019 Homebase file to identify whether and if so how much workers worked at firm before 2020. <br>	Save file with these variables in a file that we'll use in `03b_workerlevel_prob_laidoff_rehires_oct25.do`. <br><br> Uses: `homebase_raw_pre_2020.dta` <br> Creates: `homebase_worker_history.dta` |
| `03b_workerlevel_prob_laidoff_rehires_oct25.do` | Identifies the workers who were laid off and rehired, and estimates how worker characterictics predict being laid off or rehired. <br><br> Uses: `homebase_worker_history.dta`; `homebase_raw_2020_update.dta` <br> Creates: `margins_policies_coefs.csv`; `alllaidoffworkers_prob_results.xlsx` |
| `04_firmlevel_prob_shutdown_reopen_oct25.do` | Identifies likelihood of a firm shutting down and/or reopening by firm characteristics, namely size and growth rate. <br><br> Uses: `homebase_raw_2020_update.dta; homebase_raw_pre_2020.dta` <br> Creates: `firmlevel_prob_combined.png`; `firmlevel_ests_evershutdown.ster`; `firmlevel_ests_reopened.ster` |
| `05_readrawcps.do` | Reads in raw CPS monthly files <br><br> Uses: `jan20pub.dat.gz`, `feb20pub.dat.gz`, `mar20pub.dat.gz`, `apr20pub.dat.gz`, `may20pub.dat.gz`, `jun20pub.dat.gz` (all in data\_raw/cps/ folder) <br> Creates: `cpsb2001.dta.gz`, `cpsb2002.dta.gz`, `cpsb2003.dta.gz`, `cpsb2004.dta.gz`, `cpsb2005.dta.gz`, `cpsb2006.dta.gz` |
| `05sub_cpsbjan15.do` | Helper program for `05_readrawcps.do`, used to read in (infile) the original data. |
| `05sub_cpsbjan15.dct` | Data dictionary called by `05sub_cpsbjan15.do`. |
| `06_combinecps.do` | Creates a single data set from all six monthly CPS files.  <br><br> Uses: `cpsb2001.dta.gz`, `cpsb2002.dta.gz`, `cpsb2003.dta.gz`, `cpsb2004.dta.gz`, `cpsb2005.dta.gz`, `cpsb2006.dta.gz` <br> Creates: `06_combinecps.dta` |
| `07_cpslookahead.do` | Creates a person-by-month panel from the CPS data. <br><br> Uses: `06_combinecps.dta` <br> Creates: `07_cpslookahead.dta` |
| `08_cpsregs.do` | Estimates regressions for layoff and rehiring in CPS data. <br><br> Uses: `07_cpslookahead.dta`, `ppp_stc_sel.dta` (from data\_clean/ppp/) <br> Creates: `08_cpsregs.csv`, `08_cpsregs_policies.csv` |
| `09_cesseries.do` | Summarizes industry employment changes in CES data. <br><br> Uses: `ce.series.txt`, `ce.data.0.AllCESSeries.txt` <br> Creates: `09_cesseries.gph`, `09_cesseries_2.gph`, `09_cesseries_2_pres.gph` |

## Output (R scripts)
| Script | Description |
|:----------|:----------|
| `bpea_1_event_study_data.R` | Prepares data files for event studies. |
| `bpea_0_f_reg.R` | Functions that run event study regressions. |
| `bpea_0_f_reades.R` | Functions that read event study results. |
| `bpea_1_event_study_reg.R` | Runs event study regressions and saves results. |
| `bpea_1_firm_survival.R` | Calculates firm survival rates. |
| `bpea_1_worker_hours.R` | Calculates results related to worker's hours. |
| `bpeao_P1.Rmd` | Basic trends. Figure 1. |
| `bpeao_P2_surv_demogr.Rmd` | Results related to demographics of survey respondents. Table B2. |
| `bpeao_P2_surv_rep.Rmd` | Results related to representativeness of survey respondents. Table B1, Figure B1.|
| `bpeao_P3_event_study_sel.Rmd` | Results related to event studies. Figure 5, C6, C7, C8. |
| `bpeao_P4_ui_ppp.Rmd` | Results related to UI and PPP. Figure 6, C9, C11. |
| `bpeao_PA_firm_rep.Rmd` | Results related to firm representativeness. Figure A1, A2, A3. |
| `bpeao_PA_firm_survival.Rmd` | Results related to firm survival. Figure C5. |
| `bpeao_PA_worker_hours.Rmd` | Results related to workers' hours. Figure C3, C4. |

