cap log close
log using ../logs/09_cesseries.log, text replace


clear

/*
infix series_id 1-13 supersector_code 21-22 industry_code 25-32 ///
      data_type_code 37-38 seasonal 41 series_title
	  
	  
	  footnote_codes begin_year begin_period end_year end_period
*/

local output  "../results"
local rawdata  "../sourcedata"
local figout "../results/figures"

insheet using `rawdata'/ce.series.txt, names tab

keep if data_type_code==1 // all employees (1000s)
 keep if seasonal=="U"
 gen industry=subinstr(subinstr(series_title, "All employees, thousands, ", "", .), ", not seasonally adjusted", "", .)
gen indlabel="Total nonfarm" if industry=="total nonfarm"
replace indlabel="Total private" if industry=="total private"
replace indlabel="Goods producing" if industry=="goods-producing"
replace indlabel="Service providing" if industry=="service-providing"
replace indlabel="Services (private)" if industry=="private service-providing"
replace indlabel="Mining/logging" if industry=="mining and logging"
replace indlabel="Construction" if industry=="construction"
replace indlabel="Manuf." if industry=="manufacturing"
replace indlabel="Manuf.: Durable" if industry=="durable goods"
replace indlabel="Manuf.: Non-durable" if industry=="nondurable goods"
replace indlabel="Trade/transp/util" if industry=="trade, transportation, and utilities"
replace indlabel="Wholesale trade" if industry=="wholesale trade"
replace indlabel="Retail trade" if industry=="retail trade"
replace indlabel="Transport/warehouse" if industry=="transportation and warehousing"
replace indlabel="Utilities" if industry=="Utilities"
replace indlabel="Information" if industry=="information"
replace indlabel="Finance" if industry=="financial activities"
replace indlabel="Prof/bus svcs" if industry=="professional and business services"
replace indlabel="Educ/health" if industry=="education and health services"
replace indlabel="Leisure/hosp." if industry=="leisure and hospitality"
replace indlabel="Other services" if industry=="other services"
replace indlabel="Government" if industry=="government"

gen gphorder=1 if industry=="total nonfarm"
replace gphorder=2 if industry=="total private"
replace  gphorder=3 if industry=="goods-producing"
replace  gphorder=. if industry=="service-providing"
replace  gphorder=4 if industry=="private service-providing"
replace  gphorder=6 if industry=="mining and logging"
replace  gphorder=7 if industry=="construction"
replace  gphorder=. if industry=="manufacturing"
replace  gphorder=8 if industry=="durable goods"
replace  gphorder=9 if industry=="nondurable goods"
replace  gphorder=. if industry=="trade, transportation, and utilities"
replace  gphorder=10 if industry=="wholesale trade"
replace  gphorder=11 if industry=="retail trade"
replace  gphorder=12 if industry=="transportation and warehousing"
replace  gphorder=13 if industry=="Utilities"
replace  gphorder=14 if industry=="information"
replace  gphorder=15 if industry=="financial activities"
replace  gphorder=16 if industry=="professional and business services"
replace  gphorder=17 if industry=="education and health services"
replace  gphorder=18 if industry=="leisure and hospitality"
replace  gphorder=19 if industry=="other services"
replace  gphorder=5 if industry=="government"

label define indlab 1 "Total nonfarm"
label define indlab 2 "Total private", add
label define indlab 3 "Goods producing", add
//label define indlab  "Service providing", add
label define indlab 4 "Services (private)", add
label define indlab 6 "Mining/logging", add
label define indlab 7 "Construction", add
//label define indlab   "Manuf." if industry=="manufacturing"
label define indlab 8 "Manuf.: Durable", add
label define indlab 9 "Manuf.: Non-durable", add
//label define indlab 2 "Trade/transp/util" if industry=="trade, transportation, and utilities"
label define indlab 10 "Wholesale trade", add
label define indlab 11 "Retail trade", add
label define indlab 12 "Transport/warehouse", add
label define indlab 13 "Utilities", add
label define indlab 14 "Information", add
label define indlab 15 "Finance", add
label define indlab 16 "Prof/bus svcs", add
label define indlab 17 "Education/health", add
label define indlab 18 "Leisure/hospitality", add
label define indlab 19 "Other services", add
label define indlab 5 "Government", add
label values gphorder indlab

gen keeper=1 if industry_code/1000000==supersector_code
replace keeper=1 if inlist(series_id, "CEU4142000001", "CEU4422000001")
replace keeper=0 if indlabel=="Manuf."
keep if keeper==1

tempfile serieslist justseries
save `serieslist'
keep series_id indlabel gphorder

save `justseries'
insheet using `rawdata'/ce.data.0.AllCESSeries.txt, names tab clear
merge m:1 series_id using `justseries', assert(1 3) nogen keep(3)
 
drop if period=="M13"
gen month=real(substr(period,2,2))
gen yearmo=ym(year, month)
format yearmo %tm

tempfile fullperiod
save `fullperiod'

// Make the 2020 series
keep if year==2020
sort series_id yearmo
by series_id: gen index=100*value/value[1] 
drop if gphorder==.


line index yearmo, scheme(plotplain) by(gphorder, ///
       note("Notes: Payroll employment by industry or aggregate. Categories are not mutually exclusive." /// 
	        "Not seasonally adjusted.", size(small))) xtitle("") ///
			ytitle("Employment (Jan. 2020=100)", size(small)) ///
	 subtitle(, nobox bcolor(none) justification(left) size(medium)) ///
     xlabel(#6 720 "Jan" 721 "Feb" 722 "Mar" 723 "Apr" 724 "May" 725 "June", labsize(medium)) ///
     ylabel(, labsize(medium)) ///
	saving(`figout'/09_cesseries.gph, replace)
//graph export `output'/cesseries.png, replace


//Now make peak-to-trough for GR and present
use `fullperiod', clear
keep if year>=2006 & year<=2011
keep if gphorder==1
su value, meanonly
local minemp=r(min)
local maxemp=r(max)
su yearmo if value==`minemp'
local nadir=r(mean)
su yearmo if value==`maxemp'
local peak=r(mean)
use if inlist(yearmo, `nadir', `peak', 721, 723) using `fullperiod', clear
sort series_id yearmo
by series_id: gen deltaGR=100*(value[2]-value[1])/value[1]
by series_id: gen deltaCV=100*(value[4]-value[3])/value[3]
keep series_id gphorder delta*
by series_id: keep if _n==1
// add a gap between the aggregates and the individual sectors
replace gphorder=gphorder+1 if gphorder>4
gen ncopy=1+(gphorder==4)
expand ncopy
sort gphorder
by gphorder: replace gphorder=gphorder+1 if _n==2
replace deltaGR=0 if gphorder==5
replace deltaCV=0 if gphorder==5

label define indlab 1 "Total nonfarm", replace
label define indlab 2 "Total private", add
label define indlab 3 "Goods producing", add
label define indlab 4 "Services (private)", add
label define indlab 5 "---", add
label define indlab 6 "Government", add
label define indlab 7 "Mining/logging", add
label define indlab 8 "Construction", add
label define indlab 9 "Manuf.: Durable", add
label define indlab 10 "Manuf.: Non-durable", add
label define indlab 11 "Wholesale trade", add
label define indlab 12 "Retail trade", add
label define indlab 13 "Transport/warehouse", add
label define indlab 14 "Utilities", add
label define indlab 15 "Information", add
label define indlab 16 "Finance", add
label define indlab 17 "Prof/bus svcs", add
label define indlab 18 "Education/health", add
label define indlab 19 "Leisure/hospitality", add
label define indlab 20 "Other svcs", add
label values gphorder indlab

graph bar (asis) deltaGR deltaCV, over(gphorder, label(angle(55))) ///
      scheme(plotplain) xalternate ///
      ytitle("Decline in employment (%)") ///
      legend(label(1 "Nov 2007-Jan 2010") label(2 "Feb-Apr 2020") pos(7) ring(0) region(lstyle(foreground))) ///
      saving(`figout'/09_cesseries_2.gph, replace)
//graph export `output'/cesseries_2.png, replace

gen ndeltaGR=-1*deltaGR
gen ndeltaCV=-1*deltaCV
graph hbar (asis) ndeltaGR ndeltaCV, over(gphorder) ///
      scheme(plotplain) bar(1, bstyle(p2bar)) bar(2, bstyle(p4bar)) ///
      ytitle("Decline in employment (%)") scale(1.3) ///
      legend(label(1 "Nov 2007-Jan 2010") label(2 "Feb-Apr 2020") pos(2) ring(0) region(lstyle(foreground))) ///
      saving(`figout'/09_cesseries_2_pres.gph, replace)
      
log close
