
** Run logit models for job loss and job starting, and make tables and figures

cap log close
log using ../logs/08_cpsregs.log, text replace

local scratch "../scratch"
local output  "../results"
local rawdata  "../sourcedata"
local pppraw "../data_clean/ppp"
local figout "../results/figures"
local estimout "../results/estimates"
local tableout "../results/table"

estimates drop _all

use if inlist(yearmo, 722, 723, 724) & pemlr<. & Fpemlr<. using `scratch'/07_cpslookahead.dta, clear

rename gestfips stfips
//merge m:1 stfips using `rawdata'/cw_stc_ppp.dta, keepusing(uic) assert(3) nogen
//merge m:1 stfips using ~/data/clean/ppp/ppp_stc_sel, keepusing(loanc) assert(3) nogen
merge m:1 stfips using `pppraw'/ppp_stc_sel, keepusing(uic loanc) assert(3) nogen
recode stfips (9 23 25 33 44 50=1) (34 36 42=2) (18 17 26 39 55=3) (19 20 27 29 31 38 46=4) ///
              (10 11 12 13 24 37 45 51 54=5) (1 21 28 47=6) (5 22 40 48=7) ///
              (4 8 16 35 30 49 32 56=8) (2 6 15 41 53=9), gen(division)
rename stfips gestfips

sort personnum yearmo
isid personnum yearmo


*Make samples
 gen samp_marapr=(yearmo==ym(2020,3)) 
 gen samp_aprmay=(yearmo==ym(2020,4))
 gen samp_mayjun=(yearmo==ym(2020,5))
 gen stopwork=(Fpemlr!=1) if pemlr==1
 gen startwork=(Fpemlr==1) if pemlr!=1

* Gen state binaries 
levelsof(gestfips), local(state)
foreach var of local state {
gen state_`var'=0
replace state_`var'=1 if gestfips==`var'
}

* label
label var state_1 "Alabama"
label var state_2 "Alaska"
label var state_4 "Arizona"
label var state_5 "Arkansas"
label var state_6 "California"
label var state_8 "Colorado"
label var state_9 "Connecticut"
label var state_10 "Delaware"
label var state_11 "District of Columbia"
label var state_12 "Florida"
label var state_13 "Georgia"
label var state_15 "Hawaii"
label var state_16 "Idaho"
label var state_17 "Illinois"
label var state_18 "Indiana"
label var state_19 "Iowa"
label var state_20 "Kansas"
label var state_21 "Kentucky"
label var state_22 "Louisiana"
label var state_23 "Maine"
label var state_24 "Maryland"
label var state_25 "Massachusetts"
label var state_26 "Michigan"
label var state_27 "Minnesota"
label var state_28 "Mississippi"
label var state_29 "Missouri"
label var state_30 "Montana"
label var state_31 "Nebraska"
label var state_32 "Nevada"
label var state_33 "New Hampshire"
label var state_34 "New Jersey"
label var state_35 "New Mexico"
label var state_36 "New York"
label var state_37 "North Carolina"
label var state_38 "North Dakota"
label var state_39 "Ohio"
label var state_40 "Oklahoma"
label var state_41 "Oregon"
label var state_42 "Pennsylvania"
label var state_44 "Rhode Island"
label var state_45 "South Carolina"
label var state_46 "South Dakota"
label var state_47 "Tennessee"
label var state_48 "Texas"
label var state_49 "Utah"
label var state_50 "Vermont"
label var state_51 "Virginia"
label var state_53 "Washington"
label var state_54 "West Virginia"
label var state_55 "Wisconsin"
label var state_56 "Wyoming"

  //assert indB_army==0
  //drop indB_army 
replace indBnum=0 if indBnum==.

gen child_male=anychild if female==0
gen child10_male=anychild10 if female==0
gen child_female=anychild if female==1
gen child10_female=anychild10 if female==1
foreach v of varlist child_male child10_male child_female child10_female {
 gen any`v'=`v'
 replace any`v'=0 if `v'==.
}  
local allvars "age_*  ed_*  race_* hispanic married female child_male child10_male child_female child10_female manager indB_* "
local logitvars "ib2.agecatHB ib2.edcat4 ib0.racecat4 i.hispanic i.married i.female i.anychild_male i.anychild10_male i.anychild_female i.anychild10_female i.manager ib13.indBnum i.gestfips"

d yearmo age_*  ed_*  race_* hispanic anychild anychild10 married female manager indB_* , fullnames
su yearmo  age_*  ed_*  race_* hispanic anychild anychild10 married female manager indB_* state_* [aw=pwcmpwgt]


*Summary statistics
 *Working in March and April
  sum `allvars' if samp_marapr==1 & pemlr==1 & Fpemlr==1 [aw=pwcmpwgt]
 *Working in March but not April
  sum `allvars' if samp_marapr==1 & pemlr==1 & Fpemlr!=1 [aw=pwcmpwgt]
 *Not working in April but working in May, or not working in May but working in June
  sum `allvars' if (samp_aprmay==1 | samp_mayjun==1) & pemlr!=1 & Fpemlr==1 [aw=pwcmpwgt]
*Now logits  
 //Rename a couple of variables to not include
 //rename ed_hs exclude_ed_hs
 // rename indB_proftech exclude_proftech
 // rename age_35 exclude_age_35


* We run a logit regression with not working in April as a dependent variable and a set of independent variables as explanatory
eststo stop_coeff:  logit stopwork `logitvars' if samp_marapr==1 [pw=pwcmpwgt]
eststo stop_me: margins , dydx(_all) noestimcheck post atmeans ///
                          at(agecatHB=2 edcat4=2 racecat4=0 hispanic=0  ///
                             married=0 female=0 anychild_male=0 anychild10_male=0 ///
			     anychild_female=0 anychild10_female=0 manager=0 indBnum=13 gestfips=6 ) 
estimates save `estimout'/08_cpsregs_stop_me, replace                      
 coefplot 	(stop_me,						///
				msymbol(circle_hollow)			///
				color("196 130 14")			///
				ciopts(color("196 130 14"))		///
				keep(*.agecat5b)			///
				baselevels)				///
       	    (stop_me,						///
				color("196 130 14")			///
				ciopts(color("196 130 14"))		///
				keep(*.agecatHB)			///
				)				///
		(stop_me, 							///
				msymbol(circle_hollow)			///
				color("0 50 98")			///
				ciopts(color("0 50 98"))		///
				keep(*.edcat4) baselevels)			///
		(stop_me, 							///
				color("0 50 98")			///
				ciopts(color("0 50 98"))		///
				keep(*.edcat4))			///
		(stop_me,							///
				msymbol(circle_hollow)			///
				color("253 181 21")			///
				ciopts(color("253 181 21"))		///
				keep(*.racecat4 hispanic)				///
				baselevels)				///
		(stop_me,							///
				color("253 181 21")			///
				ciopts(color("253 181 21"))		///
				keep(*.racecat4 1.hispanic)				///
				rename(1.hispanic="Hispanic") ///
				)				///
		(stop_me,							///
				color("59 126 161")			///
				ciopts(color("59 126 161"))		///
				keep(1.married 1.female 1.anychild_male ///
				     1.anychild10_male 1.anychild_female 1.anychild10_female) ///
				rename(1.anychild_male="Presence of a child | male" ///
				       1.anychild10_male="Presence of a child<=10 | male" ///
				       1.anychild_female="Presence of a child | female" ///
				       1.anychild10_female="Presence of a child<=10 | female" ///
				       1.married="Married" 1.female="Female" ///
				       )) 				///
		(stop_me,							///
				color("196 130 14")			///
				ciopts(color("196 130 14"))		///
				keep(1.manager)				///
				rename(1.manager="Manager") ///
				)				///
		, 							///
		headings(	1.agecatHB=				///
					"{bf:Age group}" 		///
				1.edcat4=				///
					"{bf:Education}"			///
				0.racecat4=			///
					"{bf:Race/ethnicity}"			///
			        "Married"="{bf:Family structure}" ///
				"Manager"="{bf:Occupation}" ///
				, 					///
				wrap(24) labs(medsmall))		///		
		fcolor(*.8)  	        				///
		format(%9.1f)  nooffset                         	///
		legend(off) grid(none)		        		///
		transform(*=@*100)		       			///
		xtitle("Marginal effect (p.p.)", size(medsmall))		///
		xsc(titlegap(*5))					///
		ylab(,labs(small))		        		///
		xlab(-10 (10) 20, 		///
			grid gstyle(minor) labs(small))			///
		xline(0, lp(dash) lc(red) lw(vthin))			///
		scheme(s1color)                         		///
		plotregion(margin(2))					///
		subti(" ", size(tiny))					///
	addplot(scatter @at @b if @b!=0, 		        	///
			ms(i) mlabel(@b) mlabpos(12)			///
			mlabcolor(black) mlabsize(vsmall)) ///
        saving(`figout'/08_cpsregs_layoff.gph, replace)			

eststo start_coeff:  logit startwork `logitvars' samp_mayjun if samp_aprmay==1 | samp_mayjun==1 [pw=pwcmpwgt]
eststo start_me: margins , dydx(_all) noestimcheck post atmeans ///
                          at(agecatHB=2 edcat4=2 racecat4=0 hispanic=0 ///
                             married=0 female=0 anychild_male=0 anychild10_male=0 ///
			     anychild_female=0 anychild10_female=0 manager=0 indBnum=13 gestfips=6 samp_mayjun=0) 
estimates save `estimout'/08_cpsregs_start_me, replace                      
 coefplot 	(start_me,						///
				msymbol(circle_hollow)			///
				color("196 130 14")			///
				ciopts(color("196 130 14"))		///
				keep(*.agecat5b)			///
				baselevels)				///
       	     (start_me,						///
				color("196 130 14")			///
				ciopts(color("196 130 14"))		///
				keep(*.agecatHB)			///
				)				///
		(start_me, 							///
				msymbol(circle_hollow)			///
				color("0 50 98")			///
				ciopts(color("0 50 98"))		///
				keep(*.edcat4) baselevels)			///
		(start_me, 							///
				color("0 50 98")			///
				ciopts(color("0 50 98"))		///
				keep(*.edcat4))			///
		(start_me,							///
				msymbol(circle_hollow)			///
				color("253 181 21")			///
				ciopts(color("253 181 21"))		///
				keep(*.racecat4 hispanic)				///
				baselevels)				///
		(start_me,							///
				color("253 181 21")			///
				ciopts(color("253 181 21"))		///
				keep(*.racecat4 1.hispanic)				///
				rename(1.hispanic="Hispanic") ///
				)				///
		(start_me,							///
				color("59 126 161")			///
				ciopts(color("59 126 161"))		///
				keep(1.married 1.female 1.anychild_male ///
				     1.anychild10_male 1.anychild_female 1.anychild10_female) ///
				rename(1.anychild_male="Presence of a child | male" ///
				       1.anychild10_male="Presence of a child<=10 | male" ///
				       1.anychild_female="Presence of a child | female" ///
				       1.anychild10_female="Presence of a child<=10 | female" ///
				       1.married="Married" 1.female="Female" ///
				       )) 				///
		(start_me,							///
				color("196 130 14")			///
				ciopts(color("196 130 14"))		///
				keep(1.manager)				///
				rename(1.manager="Manager") ///
				)				///
		, 							///
		headings(	1.agecatHB=				///
					"{bf:Age group}" 		///
				1.edcat4=				///
					"{bf:Education}"			///
				0.racecat4=			///
					"{bf:Race/ethnicity}"			///
			        "Married"="{bf:Family structure}" ///
				"Manager"="{bf:Occupation}" ///
				, 					///
				wrap(24) labs(medsmall))		///		
		fcolor(*.8)  	        				///
		format(%9.1f)  nooffset                         	///
		legend(off) grid(none)		        		///
		transform(*=@*100)		       			///
		xtitle("Marginal effect (p.p.)", size(medsmall))		///
		xsc(titlegap(*5))					///
		ylab(,labs(small))		        		///
		xlab(-10 (10) 20, 		///
			grid gstyle(minor) labs(small))			///
		xline(0, lp(dash) lc(red) lw(vthin))			///
		scheme(s1color)                         		///
		plotregion(margin(2))					///
		subti(" ", size(tiny))					///
	addplot(scatter @at @b if @b!=0, 		        	///
			ms(i) mlabel(@b) mlabpos(12)			///
			mlabcolor(black) mlabsize(vsmall)) ///
        saving(`figout'/08_cpsregs_rehire.gph, replace)			

esttab stop_coeff stop_me start_coeff start_me ///
         using `tableout'/08_cpsregs.txt, ///
      label  replace cells("b(fmt(a5))" se(fmt(a5)) "mean" "sd") ///
      mtitles( "b stop" "ME stop" "b start" "ME start") ///
      nogaps nocons title(" Individual characteristics and probability of transitions in Apr/May") varwidth(20) 
esttab stop_coeff stop_me start_coeff start_me ///
        using `tableout'/08_cpsregs.csv, ///
      label  replace cells("b(fmt(a5))" se(fmt(a5)) "mean" "sd") ///
      mtitles("b stop" "ME stop" "b start" "ME start" ) ///
      nogaps nocons title(" Individual characteristics and probability of transitions in Apr/May") varwidth(20) 

local logitvars2 "ib2.agecatHB ib2.edcat4 ib0.racecat4 i.hispanic i.married i.female i.anychild_male i.anychild10_male i.anychild_female i.anychild10_female i.manager ib13.indBnum i.loanc i.uic"

//UI / PPP
* We run a logit regression with not working in April as a dependent variable and a set of independent variables as explanatory
eststo stop2_coeff:  logit stopwork `logitvars2' if samp_marapr==1 [pw=pwcmpwgt]
eststo stop2_me: margins , dydx(i.loanc i.uic) noestimcheck post atmeans ///
                          at(agecatHB=2 edcat4=2 racecat4=0 hispanic=0  ///
                             married=0 female=0 anychild_male=0 anychild10_male=0 ///
			     anychild_female=0 anychild10_female=0 manager=0 indBnum=13 ) 
estimates save `estimout'/08_cpsregs_stop2_me, replace
eststo start2_coeff:  logit startwork `logitvars2' samp_mayjun if samp_aprmay==1 | samp_mayjun==1 [pw=pwcmpwgt]
eststo start2_me: margins , dydx(i.loanc i.uic) noestimcheck post atmeans ///
                          at(agecatHB=2 edcat4=2 racecat4=0 hispanic=0  ///
                             married=0 female=0 anychild_male=0 anychild10_male=0 ///
			     anychild_female=0 anychild10_female=0 manager=0 indBnum=13 samp_mayjun=0) 
estimates save `estimout'/08_cpsregs_start2_me, replace

eststo stop3_coeff:  logit stopwork `logitvars2' i.division if samp_marapr==1 [pw=pwcmpwgt]
eststo stop3_me: margins , dydx(i.loanc i.uic) noestimcheck post atmeans ///
                          at(agecatHB=2 edcat4=2 racecat4=0 hispanic=0  ///
                             married=0 female=0 anychild_male=0 anychild10_male=0 ///
			     anychild_female=0 anychild10_female=0 manager=0 indBnum=13 ) 
estimates save `estimout'/08_cpsregs_stop3_me, replace

eststo start3_coeff:  logit startwork `logitvars2' samp_mayjun i.division if samp_aprmay==1 | samp_mayjun==1 [pw=pwcmpwgt]
eststo start3_me: margins , dydx(i.loanc i.uic) noestimcheck post atmeans ///
                          at(agecatHB=2 edcat4=2 racecat4=0 hispanic=0  ///
                             married=0 female=0 anychild_male=0 anychild10_male=0 ///
			     anychild_female=0 anychild10_female=0 manager=0 indBnum=13 samp_mayjun=0) 
estimates save `estimout'/08_cpsregs_start3_me, replace

esttab stop2_coeff stop2_me stop3_coeff stop3_me start2_coeff start2_me start3_coeff start3_me ///
        using `tableout'/08_cpsregs_policies.csv, ///
      label  replace cells("b(fmt(a5))" se(fmt(a5)) "mean" "sd") ///
      mtitles("b stop2" "ME stop2" "b stop3" "ME stop3" "b start2" "ME start2" "b start3" "ME start3" ) ///
      nogaps nocons title(" Individual characteristics and probability of transitions in Apr/May") varwidth(20) 

coefplot ///	
       	     (stop2_me,						///
				color("196 130 14")			///
				ciopts(color("196 130 14"))		///
				keep(*.loanc)			///
				baselevels)				///
		(stop2_me, 							///
				color("196 130 14")			///
				ciopts(color("196 130 14"))		///
				keep(*.uic) baselevels)			///
		(stop3_me,							///
				color("59 126 161")			///
				ciopts(color("59 126 161"))		///
				keep(*.loanc)				///
				baselevels)				///
		(stop3_me, 							///
				color("59 126 161")			///
				ciopts(color("59 126 161"))		///
				keep(*.uic) baselevels)			///
		, 							///
		headings(1.loanc="{bf: PPP}" ///
		         1.uic="{bf: UI RR}" ///
				, 					///
				wrap(24) labs(medsmall))		///		
		fcolor(*.8)  	        				///
		format(%9.1f)                           	///
		legend(off) ///
		grid(none)		        		///
		transform(*=@*100)		       			///
		xtitle("Marginal effect (p.p.)", size(medsmall))	///	
		xsc(titlegap(*5))					///
		ylab(,labs(small))		        		///
		xlab(-10 (5) 10, 		///
			grid gstyle(minor) labs(small))			///
		xline(0, lp(dash) lc(red) lw(vthin))			///
		scheme(s1color)                         		///
		plotregion(margin(2))					///
		subti(" ", size(tiny))					///
	addplot(scatter @at @b if @b!=0, 		        	///
			ms(i) mlabel(@b) mlabpos(12)			///
			mlabcolor(black) mlabsize(vsmall)) ///
        title("Layoff") name(layoff, replace) 
coefplot ///	
       	     (start2_me,						///
				color("196 130 14")			///
				ciopts(color("196 130 14"))		///
				keep(*.loanc)			///
				baselevels)				///
		(start2_me, 							///
				color("196 130 14")			///
				ciopts(color("196 130 14"))		///
				keep(*.uic) baselevels)			///
		(start3_me,							///
				color("59 126 161")			///
				ciopts(color("59 126 161"))		///
				keep(*.loanc)				///
				baselevels)				///
		(start3_me, 							///
				color("59 126 161")			///
				ciopts(color("59 126 161"))		///
				keep(*.uic) baselevels)			///
		, 							///
		headings(1.loanc="{bf: PPP}" ///
		         1.uic="{bf: UI RR}" ///
				, 					///
				wrap(24) labs(medsmall))		///		
		fcolor(*.8)  	        				///
		format(%9.1f)                           	///
		legend(label(4 "Base") ///
		       label(8 "Div. cntrls.") order(4 8) ring(0) pos(3) cols(1)) ///
		grid(none)		        		///
		transform(*=@*100)		       			///
		xtitle("Marginal effect (p.p.)", size(medsmall))	///	
		xsc(titlegap(*5))					///
		ylab(,labs(small))		        		///
		xlab(-10 (5) 10, 		///
			grid gstyle(minor) labs(small))			///
		xline(0, lp(dash) lc(red) lw(vthin))			///
		scheme(s1color)                         		///
		plotregion(margin(2))					///
		subti(" ", size(tiny))					///
	addplot(scatter @at @b if @b!=0, 		        	///
			ms(i) mlabel(@b) mlabpos(12)			///
			mlabcolor(black) mlabsize(vsmall)) ///
        title("Rehire") name(rehire, replace) 
 graph combine layoff rehire, scheme(plotplain) saving(`figout'/08_cpsregs_policies.gph, replace)
 
log close
