** Combine monthly cps for the covid project 

capture log close
log using ../logs/06_combinecps.log, text replace

local cpsorig "../scratch"
local scratch "../scratch"
local temp "`pdir'/rawdata/temp"


local filelist " cpsb2001 cpsb2002 cpsb2003 cpsb2004 cpsb2005 cpsb2006"

set more off
program drop _all
set type double, perm

 * Dezip
foreach file of local filelist {
!zcat `cpsorig'/`file'.dta.gz > `scratch'/`file'.dta;
}

 * Append
clear
foreach file of local filelist {
  append using `scratch'/`file'
}


 * Create time variables
gen month=hrmonth
gen year=hryear4
order year month
sort year month

 *  Save and Remove
save `scratch'/06_combinecps.dta, replace
 *! gzip -f `scratch'/06_combinecps.dta

foreach file of local filelist {
  !rm -f `scratch'/`file'.dta
}

log close

