

**  Read raw CPS files, downloaded from BLS

	
********************************************************************************
capture log close
log using ../logs/05_readrawcps.log, text replace
set more off
clear *
program drop _all
set memory 1000m
set type double, perm
version 14

********************************************************************************
* I. Configure Directories
********************************************************************************
global rawcps  = "../sourcedata/cps"
global scratch  = "../scratch"
global progdir = "."

********************************************************************************
* IV. Define Program to Read in Raw Data (04/2014 - )
********************************************************************************
// Defines readraw2 which is readraw for .gz instead of .Z raw files
program readraw2 
	global pgm = "`1'"
	global rawdata = "tmp_`2'"
	global basedata = "`3'"
	!zcat ${rawcps}/`2'.gz > ${scratch}/tmp_`2' // only change vs. readraw
	clear *
	do ${progdir}/`1'.do
	if `4'~=. {
		assert _N==`4'
	}
	!rm -f ${scratch}/tmp_`2'
	!rm -f ${scratch}/${basedata}.dta.gz
	!gzip ${scratch}/${basedata}.dta
	macro drop basedata
end


readraw2 05sub_cpsbjan15 jan20pub.dat cpsb2001 138697
readraw2 05sub_cpsbjan15 feb20pub.dat cpsb2002 139248
readraw2 05sub_cpsbjan15 mar20pub.dat cpsb2003 131578
readraw2 05sub_cpsbjan15 apr20pub.dat cpsb2004 129382
readraw2 05sub_cpsbjan15 may20pub.dat cpsb2005 126557
readraw2 05sub_cpsbjan15 jun20pub.dat cpsb2006 123364



cap log close
