/*****************************************************************************
*Use 2018-2019 Homebase file to identify whether and if so how much workers
worked at firm before 2020. Save file with these variables in a file
that we'll use in 05b_workerlevel_prob_laidoff_rehires.

*******************************************************************************/


cap log close rehires_log
local date: display %tdCCYY-NN-DD =daily("`c(current_date)'", "DMY")
log using "/accounts/projects/jrothst/homebase/data/bpea_replication_archive/logs/03a_worker_history_`date'.log", ///
	replace name(workerhistory_log)


set more off
set varabbrev off

loc dir 	"/accounts/projects/jrothst/homebase/data/bpea_replication_archive/"
loc code	"`dir'/code/"
loc results	"`dir'/results/"
loc sourcedata	"`dir'/data_raw/"
loc workingdata	"`dir'/data_clean/"

*******************************************************************************/

use "/accounts/projects/jrothst/homebase/data/clean/homebase_raw_pre2020.dta", clear

 ren sthud	state
 ren stfipshud	stfips
 ren msachud	msac
 ren ind	industry
 ren company_id	firm
 ren user_id	person
 egen establishment = group(firm location_id)
 
 drop if state==.
 drop if msac==.
 
 gsort firm establishment person event_date
*unique firm
*unique establishment
*unique person

*isid firm establishment person day

 keep firm location_id industry msac state stfips establishment person event_date hours_worked
 
 
*Keep obs with reasonable hours, those in the US, those with real stfps
 keep if inrange(hours_worked,0,20)
 drop if inlist(stfips,98,99)

 gen anywork=(hours_worked>0)
 
 sum event_date, detail
 loc firstday=`r(min)'
 loc lastday=`r(max)'
 gen week=.
 replace week=1 if inrange(event_date,`firstday',`firstday'+6)
 forvalues w=2/110 {
  replace week=`w' ///
		if inrange(event_date,	`firstday'+((`w'-2)*7 + 7),	///
					`firstday'+((`w'-1)*7 + 6))
 }
 
 gsort firm location_id establishment person week event_date 
 
 gcollapse	(min)	first_day=event_date				///
		(max)	last_day=event_date				///
		(sum)	total_hours=hours_worked			///
			days_worked=anywork				///
		(mean)	avg_weekly_hours=hours_worked			///
		, by(firm industry msac state person week)
 
 gcollapse	(min)	first_day					///
		(max)	last_day					///
		(count)	weeks_worked=week				///
		(sum)	total_hours					///
			days_worked					///			
		, by(firm industry msac state person)
		
 isid firm industry msac state person
 
 gen tenure=(last_day-first_day)+1
 
 
 foreach var in first_day last_day weeks_worked total_hours days_worked {
  ren `var' `var'_1819
 }
 
 compress
save `results'/data/homebase_worker_history, replace
		
		
		
********************************************************************************

log close workerhistory_log
********************************************************************************