# Replication Package for BPEA Paper "Measuring the Labor Market at the Onset of the COVID-19 Crisis"

This is the replication package for BPEA paper "Measuring the Labor Market at the Onset of the COVID-19 Crisis" by Alexander W. Bartik, Marianne Bertrand, Feng Lin, Jesse Rothstein, Matthew Unrath.

The package includes all scripts and non-proprietary data used to generate the results in the paper.

## Directory Structure
| Directory | Description |
|:----------|:----------|
| `code_function/` | Some general functions called by other scripts. |
| `code_data/` | Scripts that read in and clean raw data. |
| `code/` | Scripts that generate tables and figures in the BPEA paper. |
| `logs/` | Log files. Log files that may reveal information about small cells in proprietary data are excluded. |
| `data_raw/` | Raw data files. Proprietary data are not included (e.g. Homebase and SafeGraph data). |
| `data_clean/` | Processed data files. Proprietary data are not included (e.g. Homebase and SafeGraph data). |
| `results/` | Figures and tables in the BPEA paper. |
| `scratch/` | Scratch space. |