* AUTHOR:SUMEDHA GUPTA
****************************************************************************************************************************************************************

clear all

* Root folder globals
global root		"G:\.shortcut-targets-by-id\1DeeHcG7EI1A4gdwrBHn0IJ6BFVfzediU\BPEA2020\Data\ReplicationPackage"

* Script folder globals
global scripts	"$root\scripts"
global output	"$root\results"
 
* Other required folders in case they are needed (Put here all other globals and comment them)
global data_file_path "$root\DataDevelopment"
global miscdir 		  "$data_file_path\miscdata"     			// misc. data 
global ready		  "$data_file_path\cleandata"	 
global rawdata		  "$data_file_path\rawdata"	 
********************************************************************************

*Open the state-day Google Mobility data
use "$ready\reopenings\GoogleMobility_state.dta", clear
foreach var in EmergDec  SchoolClose StayAtHome  FirstCase FirstDeath ReOpen /*ReOpenMajor ReOpenPhase2*/ FirstAnnounce{
	gen Post`var'  = date >= Date`var' 
	label var Post`var' "Post x `var'" 
}

		local TitleEmergDec  "Emergency Declarations" 
		local TitleGathRestrictAny  "Gathering Restrictions"
		local TitleNEBusinessClose  "NE Business Closure"
		local TitleSchoolClose  "School Closure"
		local TitleStayAtHome  "Stay-at-Home"
		local TitleRestOtherRestrict  "Restaurant/business Closure"
		local TitleFirstCase  "First Confirmed Case"	
		local TitleFirstDeath "First Death"
		local TitleReOpen "Initial Re-opening"
		local TitleReOpenMajor "Major Re-opening"
		local TitleReOpenPhase2 "Phase 2 Re-opening"
		local TitleFirstAnnounce "Announcement of Initial Reopening"
		local LabelRR   "Mobility to Retail/Recreation" 
		local LabelGP   "Mobility to Grocery/Pharmacy"
		local LabelPB   "Mobility to Parks/Beaches"
		local LabelTRANSIT   "Mobility to Transit Stations"
		local LabelWORK  "Mobility to Workplace"
		local LabelRES  "Stay in Residential Areas"
			

*Make the event study variables.
foreach var in FirstCase EmergDec SchoolClose StayAtHome FirstDeath ReOpen /*ReOpenMajor ReOpenPhase2*/ FirstAnnounce{
	gen days_since_`var' = date - Date`var'	
	replace days_since_`var' = -31 if days_since_`var'<=-31
	replace days_since_`var' = 31 if days_since_`var'>=31 & days_since_`var'~=.
	replace days_since_`var' = -1 if days_since_`var'==.
	quietly tab days_since_`var', gen(ds_`var'_)	
}	
gen timeG = -31+ _n in 1/100


rename (retail_and_recreation_percent_ch grocery_and_pharmacy_percent_cha parks_percent_change_from_baseli transit_stations_percent_change_ workplaces_percent_change_from_b residential_percent_change_from_) (RR GP PB TRANSIT WORK RES)

* OPTIONAL - removing states that re-opened after our observation window (CONFIRM)
//drop if DateReOpen~=. & DateReOpen>td(02May2020)


*Fit the event study regressions
foreach Y in RR GP PB TRANSIT WORK RES{
foreach T in  ReOpen /*ReOpenMajor ReOpenPhase2*/ FirstAnnounce{
    gen b_`Y'`T' = .
	gen upper_`Y'`T' = .
	gen lower_`Y'`T' = .
	
summ `Y' if date==d(15apr2020)
	local mean : di %3.2f r(mean) 
	local stdev: di %3.2f r(sd)
	di `mean'
	di `stdev'
	
	reghdfe `Y' ds_`T'_1-ds_`T'_30 ds_`T'_32-ds_`T'_63 prcp tavg, ///
	absorb(state_d date, save) cluster(state_d)
	estadd scalar base=`mean'
	estadd scalar effectsize5=(_b[ds_`T'_37]/abs(`mean'))*100
	estadd scalar effectsize10=(_b[ds_`T'_42]/abs(`mean'))*100
	estadd scalar effectsize20=(_b[ds_`T'_52]/abs(`mean'))*100
	estadd scalar effectsize25=(_b[ds_`T'_57]/abs(`mean'))*100
	
	
	estimates store c`Y'`T'
	
	local row = 0
    
    forvalues t = 2(1)30 {
        local ++row
        qui replace b_`Y'`T' = _b[ds_`T'_`t'] in `row'
        qui replace upper_`Y'`T' = _b[ds_`T'_`t'] + 1.96*_se[ds_`T'_`t'] in `row'
        qui replace lower_`Y'`T' = _b[ds_`T'_`t']-  1.96*_se[ds_`T'_`t'] in `row'
    }
    local ++row
    qui replace b_`Y'`T'= 0 in `row'
    forvalues t = 32/62 {
        local ++row
        qui replace b_`Y'`T'  = _b[ds_`T'_`t'] in `row'
        qui replace upper_`Y'`T' = _b[ds_`T'_`t'] + 1.96*_se[ds_`T'_`t'] in `row'
        qui replace lower_`Y'`T' = _b[ds_`T'_`t'] - 1.96*_se[ds_`T'_`t'] in `row'
    }
	
*ES plots	
	summ `Y' if date==d(15apr2020)
	local mean : di %3.2f r(mean) 
	local stdev: di %3.2f r(sd)
	di `mean'
	di `stdev'

   # delimit ;
    twoway
        (rarea upper_`Y'`T' lower_`Y'`T' timeG if inrange(timeG, -30,30), color(gs12%35))
        (connected b_`Y'`T' timeG if inrange(timeG, -30,-2),
            mcolor(cranberry) lwidth(thick) lcolor(cranberry) msize(medium))
		(connected b_`Y'`T' timeG if inrange(timeG, 0,30),
            mcolor(cranberry) lwidth(thick) lcolor(cranberry) msize(medium))
        (function y = 0, range(-30 30) lcolor(gs10)),
        xline(-.5 , lwidth(2.2) lcolor(gs10) )
        xsize(4) ysize(2)
        xtitle("") /*ytitle("`Label`Y''", size(medium))*/
		graphregion(color(white)) 
		xsc(range(-30 30))
        xlabel(-30(4)30, labsize(medium) nogrid)
		ylabel(/*-15(5)5*/, labsize(medium) nogrid) 	
        legend(off)
        graphregion(margin(r+5))
        title("`Title`T'':" "`Label`Y''", pos(11) size(4.5) color(black))
		note("Baseline DV mean=`mean', std. dev.=`stdev'", size(3))
        name(`Y'`T', replace)
     ;
    # delimit cr
 	
 
 rename __hdfe2__ datefe`Y'`T'
 
}
}
*Specifying common coefficient label names for each event-time dummy coefficient across all estimations to be used in esttab command
forval i = 1(1)31 {
    local j=32-`i'
    local rename_opt `rename_opt' ds_ReOpen_`i' `j'daysprior ds_ReOpenMajor_`i' `j'daysprior ds_ReOpenPhase2_`i' `j'daysprior ds_FirstAnnounce_`i' `j'daysprior
    local coeflabels_opt `coeflabels_opt' `j'daysprior "`j' days prior to event"
}
forval p = 32/62 {
    local k=`p'-32
    local rename_opt `rename_opt' ds_ReOpen_`p' `k'afterevent ds_ReOpenMajor_`p' `k'afterevent ds_ReOpenPhase2_`p' `k'afterevent ds_FirstAnnounce_`p' `k'afterevent
    if `p' == 32 local coeflabels_opt `coeflabels_opt' `k'afterevent "Day of event"
    else if `p' == 33 local coeflabels_opt `coeflabels_opt' `k'afterevent "1 day after event"
    else local coeflabels_opt `coeflabels_opt' `k'afterevent "`k' days after event"
}

di "`rename_opt'"
di `" `coeflabels_opt' "'

esttab  cRRFirstAnnounce cGPFirstAnnounce cPBFirstAnnounce cTRANSITFirstAnnounce cWORKFirstAnnounce cRESFirstAnnounce cRRReOpen cGPReOpen cPBReOpen cTRANSITReOpen cWORKReOpen cRESReOpen /*cRRReOpenMajor cGPReOpenMajor cPBReOpenMajor cTRANSITReOpenMajor cWORKReOpenMajor cRESReOpenMajor cRRReOpenPhase2 cGPReOpenPhase2 cPBReOpenPhase2 cTRANSITReOpenPhase2 cWORKReOpenPhase2 cRESReOpenPhase2*/ ///
using "$output\Table2_panelII_googlemobivility.csv", ///
drop(31daysprior _cons ds_ReOpen_63 /*ds_ReOpenMajor_43 ds_ReOpenPhase2_43*/ ds_FirstAnnounce_63) b(a3) se(3) nogaps  nolabel star(* 0.10 ** 0.05 *** 0.01) ///
label title(Fig12a.) mtitles("Retail/Recreation Initial" "Grocery/Pharmacy Initial" "Parks/Beaches Initial" "Transit Stations Initial" "Workplace Initial" "Residential Areas Initial" "Retail/Recreation Major" "Grocery/Pharmacy Major" "Parks/Beaches Major" "Transit Stations Major" "Workplace Major" "Residential Areas Major")  ///
rename(`rename_opt') coeflabels(`coeflabels_opt') stats(N base effectsize5 effectsize10 effectsize20 effectsize25, labels(`"Observations"' `"Baseline DV mean"' `"Effect size after 5 days"' `"Effect size after 10 days"' `"Effect size after 20 days"' `"Effect size after 25 days"')) replace 

	
esttab  cRRFirstAnnounce cGPFirstAnnounce cPBFirstAnnounce cTRANSITFirstAnnounce cWORKFirstAnnounce cRESFirstAnnounce cRRReOpen cGPReOpen cPBReOpen cTRANSITReOpen cWORKReOpen cRESReOpen /*cRRReOpenMajor cGPReOpenMajor cPBReOpenMajor cTRANSITReOpenMajor cWORKReOpenMajor cRESReOpenMajor cRRReOpenPhase2 cGPReOpenPhase2 cPBReOpenPhase2 cTRANSITReOpenPhase2 cWORKReOpenPhase2 cRESReOpenPhase2*/ ///
using "$output\Table2_panelII_googlemobivility.tex", ///
drop(31daysprior _cons ds_ReOpen_63 /*ds_ReOpenMajor_43 ds_ReOpenPhase2_43*/ ds_FirstAnnounce_63) b(a3) se(3) nogaps  nolabel star(* 0.10 ** 0.05 *** 0.01) ///
label title(Fig12a.) mtitles("Retail/Recreation Initial" "Grocery/Pharmacy Initial" "Parks/Beaches Initial" "Transit Stations Initial" "Workplace Initial" "Residential Areas Initial" "Retail/Recreation Major" "Grocery/Pharmacy Major" "Parks/Beaches Major" "Transit Stations Major" "Workplace Major" "Residential Areas Major")  ///
rename(`rename_opt') coeflabels(`coeflabels_opt') stats(N base effectsize5 effectsize10 effectsize20 effectsize25, labels(`"Observations"' `"Baseline DV mean"' `"Effect size after 5 days"' `"Effect size after 10 days"' `"Effect size after 20 days"' `"Effect size after 25 days"')) replace 


# delimit ;
graph combine RRFirstAnnounce GPFirstAnnounce PBFirstAnnounce TRANSITFirstAnnounce WORKFirstAnnounce RESFirstAnnounce, cols(2) xsize(7) ysize(9) iscale(.7) imargin(small)
    graphregion(color(white))
    name(limits1, replace)
	title("Effects of Announcement of Initial Re-opening on Change in Mobility trends", size(medium) color(black)) subtitle("(State Level Analysis)", size(small))
    b1title("Days relative to re-opening", size(small))
	note("{it:Source: Google Mobility} (09 April 2020 - 14 June 2020)", size(vsmall))
;
# delimit cr
	graph export "$output\Table2_panelII_googlemobivility_firstannounce.png",  replace  width(10000)	

# delimit ;
graph combine RRReOpen GPReOpen PBReOpen TRANSITReOpen WORKReOpen RESReOpen, cols(2) xsize(7) ysize(9) iscale(.7) imargin(small)
    graphregion(color(white))
    name(limits1, replace)
	title("Effects of Initial Re-opening on Change in Mobility trends", size(medium) color(black)) subtitle("(State Level Analysis)", size(small))
    b1title("Days relative to re-opening", size(small))
	note("{it:Source: Google Mobility} (09 April 2020 - 14 June 2020)", size(vsmall))
;
# delimit cr
	graph export "$output\Fig2_panelII_googlemobivility_reopen.png",  replace  width(10000)	
	
	
