* AUTHOR:SUMEDHA GUPTA
****************************************************************************************************************************************************************

clear all

* Root folder globals
global root		"G:\.shortcut-targets-by-id\1DeeHcG7EI1A4gdwrBHn0IJ6BFVfzediU\BPEA2020\Data\ReplicationPackage"

* Script folder globals
global scripts	"$root\scripts"
global output	"$root\results"
 
* Other required folders in case they are needed (Put here all other globals and comment them)
global data_file_path "$root\DataDevelopment"
global miscdir 		  "$data_file_path\miscdata"     			// misc. data 
global ready		  "$data_file_path\cleandata"	 
global rawdata		  "$data_file_path\rawdata"	 
********************************************************************************

********************************************************************************
set scheme plotplain
use "$ready\policy\CoreState_policies_2020-06-13.dta"  , clear
sort state
	merge state using "$ready\policy\Pol_phase2.dta" 
keep if _merge==3
drop _merge

		
gen censored=DateReOpen >=td(15jun2020) if !mi(DateStayAtHome)
gen s=min(td(15feb2020),DateReOpen)

gen censoredM=DateReOpenPhase2>=td(15jun2020) if !mi(DateStayAtHome)
gen sM=min(td(15jun2020),DateReOpenPhase2)
gen smin=min(DateEmergDec, DateSchoolClose, DateRestaurantOtherRestrict, DateNEBusinessClose, DateGathRestrictAny, DateStayAtHome, DateFirstCase, DateFirstDeath, DateReOpen, DateReOpenPhase2)
gen smax=max(DateEmergDec, DateSchoolClose, DateRestaurantOtherRestrict, DateNEBusinessClose, DateGathRestrictAny, DateStayAtHome, DateFirstCase, DateFirstDeath, DateReOpen, DateReOpenPhase2)


gen ld_dur=s-DateStayAtHome
gen ld_durM=sM-DateStayAtHome

gsort -state
gen row=_n

labmask row, values(Statename) lblname(row_labels)
label values row row_labels

	
levelsof row if censored==0| DateStayAtHome==., local(y1)
levelsof row if censored==1, local(y2)
levelsof row if censoredM==0, local(y3)
levelsof row if censoredM==1, local(y4)

*** Figure 1

	twoway scatter row DateEmergDec  , pstyle(p1) color(purple*.8) yaxis(1) msize(tiny) || ///
			scatter row DateSchoolClose  , pstyle(p1) color(blue*.8) yaxis(1) msize(tiny) || ///
			scatter row DateRestaurantOtherRestrict  , pstyle(p1) color(lime*.8) yaxis(1) msize(tiny) || ///
			scatter row DateNEBusinessClose, pstyle(p1) color(magenta*.8) yaxis(1) msize(tiny) || ///
			scatter row DateGathRestrictAny , pstyle(p1) color(green*.8) yaxis(1) msize(tiny) || ///
			scatter row DateFirstCase, pstyle(p1) color(gray*.8) yaxis(1) msize(tiny) || ///
			scatter row DateFirstDeath, pstyle(p1) color(brown*.8) yaxis(1) msize(tiny) || ///
		    scatter row DateStayAtHome  , pstyle(p1) color(cranberry*.8) yaxis(1) msize(tiny) || ///
		    scatter row DateReOpen , pstyle(p1) color(orange*.8) yaxis(1) msize(tiny) || ///
		    scatter row DateReOpenPhase2 , pstyle(p1) color(navy*.8) msymbol(circle_hollow) yaxis(1) msize(tiny) || ///
		    pcspike row smin row smax   ,   pstyle(p1) lwidth(vthin) msize(tiny)  color(gs11) yaxis(1) || ///
		    pcarrow row DateReOpen row sM   if DateReOpenPhase2==., pstyle(p1) lwidth(vthin)  msize(tiny) color(orange) yaxis(1) || ///
		    , xlabel(,format(%tddd-Mon) labsize(vsmall))  yscale(r(1 50) axis(1))   ///
			ytitle("", axis(1)) ylabel(`y1', nogrid valuelabel angle(0) labsize(tiny) axis(1)) ysc(titlegap(5)) /// 
			graphregion(margin(small)) ///
			graphregion(color(white)) ///
			xsize(12) ysize(7) ///
			legend(row(10) /*subtitle("Legend", size(1.5))*/ pos(3) size(1.35) region(lstyle(none)) region(lwidth(none) ) ///
			order(1 "Emergency Declaration" 2 "School Closure" 	3 "Restaurant Closure" 4 "Non-essential Business Closure" 5 "Gathering Restrictions" ///
			6 "First Confirmed Case" 7 "First Death" 8 "Stay-at-Home Orders" 9 "Phase 1 Re-opening" 10 "Phase 2 Re-opening"))

graph export "$output\Figure1_Policy_dates_BPEA.png", as(png) name("Graph") replace width(10000)	
rename state stateabr
rename statename state
 sort state
merge state using "$miscdir/state_pop.dta"		 
drop _merge

save "$ready\policy\BPEA_POLICY_FIGURES_DATA.dta", replace


*** Figure 2 b

use "$ready\policy\BPEA_POLICY_FIGURES_DATA.dta", clear
drop state
 
gen dur = mdy(6,15,2020) -   mdy(4,19,2020)
		tab dur 
		expand dur 
		sort state 
		by state: gen date = _n +   mdy(4,19,2020)
		format date %d 
		tab date 
		ren pop population 
		
		gen DateReOpenRetail = DateReOpen if Retail ==1 
		gen DateReOpenTapered = DateReOpen if ReOpenSum <=2 
		gen DateReOpenCom = DateReOpen if ReOpenSum >2 & ReOpenSum!=.

		
		foreach var in StayAtHome ReOpen ReOpenRetail ReOpenTapered ReOpenCom RestaurantOtherRestrict NEBusinessClose ///
		{
		gen Post`var'  = date >= Date`var' 
		label var Post`var' "Post x `var'" 
		gen POP`var'  = Post`var' * population 
		label var POP`var' "Post x `var' x population" 		
		sum POP`var'		
		}	
			
		keep date population POP*
		drop if population==. 
			
		collapse (sum) population POPStayAtHome POPReOpen POPReOpenRetail POPReOpenTapered POPReOpenCom, by(date)
	
		foreach var in  StayAtHome ReOpen ReOpenRetail ReOpenTapered ReOpenCom ///
			{
		gen `var' = POP`var'/population*100
		sum `var'	
		}
			  		
	dis  mdy(4,21,2020) 
	dis mdy(6,15,2020) 
	format date  %tdnn/dd/YY
		
	sum ReOpen ReOpenRetail ReOpenTapered ReOpenCom
	
	format date  %tdnn/dd/YY
	
	

# delimit ;
twoway
	(line ReOpen ReOpenRetail ReOpenTapered ReOpenCom date if date >=mdy(4,20,2020)  & date <=mdy(6,15,2020)  ,  lwidth(0.65..) lcolor("cranberry" "gs11"  "cranberry*.40"  "maroon" )  msymbol(none)),
	graphregion(color(white))
	ytitle("% U.S. Population", size(3))  xtitle("Time", size(3))
	ylabel(0(20)100, labsize(2.5) )
	xlabel(22025(5)22081, labsize(2))
	legend(  rows(2) order(1 "Any Business Reopening" 2 "Reopening in Retail" 3 "Reopening two or fewer sectors" 4 "Reopening three or more sectors" ) pos(6) size(2.3))
	title("",pos(11)  size(3) color(black))
	name(state, replace)
;
# delimit cr	

graph combine state , cols(1) imargin(small) xsize(5) ysize(4) graphregion(color(white))
graph export "$output\Figure2b_Reopenings_pop_sectors.png", as(png) name("state") replace width(10000)