* This do file makes STATE-LEVEL SafeGraph data Figure 3
* AUTHOR:SUMEDHA GUPTA
****************************************************************************************************************************************************************
clear all

* Root folder globals
global root		"G:\.shortcut-targets-by-id\1DeeHcG7EI1A4gdwrBHn0IJ6BFVfzediU\BPEA2020\Data\ReplicationPackage"

* Script folder globals
global scripts	"$root\scripts"
global output	"$root\results"
 
* Other required folders in case they are needed (Put here all other globals and comment them)
global data_file_path "$root\DataDevelopment"
global miscdir 		  "$data_file_path\miscdata"     			// misc. data 
global ready		  "$data_file_path\cleandata"	 
global rawdata		  "$data_file_path\rawdata"	 
********************************************************************************
use "$data_file_path\smokeplots\Fig3_FracLeavingHome_HoursAtHome_safegraph.dta", clear

foreach j in 2 3 4 5 6 7 9 10 11 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 {
   local pre1 `pre1' line share`j' date, c(L) lc(gs12) lw(thin)||
   local postSAH1 `postSAH1' line spostSAH`j' date, c(L) lc(red*.5) lw(thin)||
   local postReOpen1 `postReOpen1' line spostReOpen`j' date, c(L) lc(green*.4) lw(thin)||
   local pre2 `pre2' line wthometime`j' date, c(L) lc(gs12) lw(thin)||
   local postSAH2 `postSAH2' line wtpostSAH`j' date, c(L) lc(red*.5) lw(thin)||
   local postReOpen2 `postReOpen2' line wtpostReOpen`j' date, c(L) lc(green*.4) lw(thin)||
   local pre3 `pre3' line work`j' date, c(L) lc(gs12) lw(thin)||
   local postSAH3 `postSAH3' line workpostSAH`j' date, c(L) lc(red*.5) lw(thin)||
   local postReOpen3 `postReOpen3' line workpostReOpen`j' date, c(L) lc(green*.4) lw(thin)||
}

# delimit ; 
twoway `pre1' 
    || `postSAH1' 
	|| `postReOpen1' 
    || line natshare date, lw(medium) lc(black)  
    ||, xsize(2.5) ysize(2)
        xtitle("") ytitle("Fraction left the house", size(medium)  color(black))
		yscale(titlegap(*12))
		graphregion(color(white))
        xlabel(21960(20)22080, labsize(small) nogrid)
		ylabel(/*-60(20)40*/, labsize(small) nogrid) 	
        legend(off)
        graphregion(margin(r+5))
		note("{it:Source: SafeGraph Aggregated Mobility Metrics}", size(medsmall)) 
        name(SG1, replace) 
     ;
    # delimit cr
 	graph export "$plotdir\Fig4_SG1.png",  replace  width(3000)	

# delimit ; 
twoway `pre2' 
    || `postSAH2' 
	|| `postReOpen2' 
    || line natwthometime date, lw(medium) lc(black)  
    ||, xsize(2.5) ysize(2)
        xtitle("") ytitle("Median hours at home", size(medium)  color(black))
		yscale(titlegap(*12))
		graphregion(color(white))
        xlabel(21960(20)22080, labsize(small) nogrid)
		ylabel(/*-60(20)40*/, labsize(small) nogrid) 	
        legend(off)
        graphregion(margin(r+5))
		note("{it:Source: SafeGraph Aggregated Mobility Metrics}", size(medsmall)) 
        name(SG2, replace) 
     ;
 # delimit cr
 	graph export "$plotdir\Fig4_SG2.png",  replace  width(3000)	
	
	# delimit ; 
twoway `pre3' 
    || `postSAH3' 
	|| `postReOpen3' 
    || line natwork date, lw(medium) lc(black)  
    ||, xsize(2.5) ysize(2)
        xtitle("") ytitle("Fraction at work", size(medium)  color(black))
		yscale(titlegap(*12))
		graphregion(color(white))
        xlabel(21960(20)22080, labsize(small) nogrid)
		ylabel(/*-60(20)40*/, labsize(small) nogrid) 	
        legend(off)
        graphregion(margin(r+5))
		note("{it:Source: SafeGraph Aggregated Mobility Metrics}", size(medsmall)) 
        name(SG1, replace) 
     ;
    # delimit cr
 	graph export "$plotdir\Fig4_SG3.png",  replace  width(3000)	

