* This do file prepares Apple Mobility Figure 3
* AUTHOR:SUMEDHA GUPTA
****************************************************************************************************************************************************************
clear all

* Root folder globals
global root		"G:\.shortcut-targets-by-id\1DeeHcG7EI1A4gdwrBHn0IJ6BFVfzediU\BPEA2020\Data\ReplicationPackage"

* Script folder globals
global scripts	"$root\scripts"
global output	"$root\results"
 
* Other required folders in case they are needed (Put here all other globals and comment them)
global data_file_path "$root\DataDevelopment"
global miscdir 		  "$data_file_path\miscdata"     			// misc. data 
global ready		  "$data_file_path\cleandata"	 
global rawdata		  "$data_file_path\rawdata"	 
********************************************************************************

*Open the state-day Apple Mobility data
use "$data_file_path\smokeplots\Fig3_Request_for_driving_directions.dta", clear


local pre1
local post1

foreach j in 2 3 4 5 6 7 9 10 11 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 {
   local pre1 `pre1' line driving_mobility`j' date, c(L) lc(gs12) lw(thin)||
   local postSAH1 `postSAH1' line postSAH`j' date, c(L) lc(red*.5) lw(thin)||
   local postReOpen1 `postReOpen1' line postReOpen`j' date, c(L) lc(green*.4) lw(thin)||
   }

# delimit ; 
twoway `pre1' 
    || `postSAH1' 
	|| `postReOpen1'
    || line natdriving_mobility date, lw(medium) lc(black)  
    ||, xsize(2.5) ysize(2)
        xtitle("") ytitle("Request for driving direction", size(4) color(black))
		yscale(titlegap(*12))
		graphregion(color(white))
        xlabel(21960(30)22080, labsize(3.5) nogrid)
		ylabel(/*-60(20)40*/, labsize(3.5) nogrid) 	
        legend(off)
        graphregion(margin(r+5))
        caption("{it:Source: Apple Mobility}", size(3.5)) 
		/*title("Change in request for driving direction", pos(11) size(4) color(black))*/
        name(Apple, replace) 
     ;
    # delimit cr
 	graph export "$plotdir\Fig4_Apple.png",  replace  width(3000)	


