* AUTHOR:SUMEDHA GUPTA
****************************************************************************************************************************************************************
clear all

* Root folder globals
global root		"G:\.shortcut-targets-by-id\1DeeHcG7EI1A4gdwrBHn0IJ6BFVfzediU\BPEA2020\Data\ReplicationPackage"

* Script folder globals
global scripts	"$root\scripts"
global output	"$root\results"
 
* Other required folders in case they are needed (Put here all other globals and comment them)
global data_file_path "$root\DataDevelopment"
global miscdir 		  "$data_file_path\miscdata"     			// misc. data 
global ready		  "$data_file_path\cleandata"	 
global rawdata		  "$data_file_path\rawdata"	 
********************************************************************************

use "$ready\reopenings\SafeGraph_state.dta", clear
foreach var in EmergDec  SchoolClose StayAtHome  FirstCase FirstDeath ReOpen /*ReOpenMajor ReOpenPhase2*/ FirstAnnounce{
	
	gen Post`var'  = date >= Date`var' 
	label var Post`var' "Post x `var'" 
}

		local TitleEmergDec  "Emergency Declarations" 
		local TitleGathRestrictAny  "Gathering Restrictions"
		local TitleNEBusinessClose  "NE Business Closure"
		local TitleSchoolClose  "School Closure"
		local TitleStayAtHome  "Stay-at-Home"
		local TitleRestOtherRestrict  "Restaurant/business Closure"
		local TitleFirstConfirmedCase  "First Confirmed Case"
		local TitleFirstDeath "First Death"
		local TitleReOpen "Initial Re-opening"
		local TitleReOpenMajor "Major Re-opening"
		local TitleReOpenPhase2 "Phase 2 Re-opening"
		local TitleFirstAnnounce "Announcement of Initial Reopening"
		local Labelne_share2   "Fraction left the house" 
		local Labelne_share4   "Fraction at work" 
		local Labelwthometime   "Median hours at home"
		

foreach var in FirstCase EmergDec SchoolClose StayAtHome FirstDeath ReOpen /*ReOpenMajor ReOpenPhase2*/ FirstAnnounce{
	gen days_since_`var' = date - Date`var'	
	replace days_since_`var' = -31 if days_since_`var'<=-31
	replace days_since_`var' = 31 if days_since_`var'>=31 & days_since_`var'~=.
	replace days_since_`var' = -1 if days_since_`var'==.
	quietly tab days_since_`var', gen(ds_`var'_)
	
	
}	
gen timeG = -31+ _n in 1/100


*Fit the event study regressions
foreach Y in ne_share2 ne_share4 wthometime{
foreach T in  ReOpen  FirstAnnounce{
    gen b_`Y'`T' = .
	gen upper_`Y'`T' = .
	gen lower_`Y'`T' = .
	
	summ `Y' if date==d(15apr2020)
	local mean : di %3.2f r(mean) 
	local stdev: di %3.2f r(sd)
	di `mean'
	di `stdev'
	
	reghdfe `Y' ds_`T'_1-ds_`T'_30 ds_`T'_32-ds_`T'_63 prcp tavg, ///
	absorb(state_d date, save) cluster(state_d)
	estadd scalar base=`mean'
	estadd scalar effectsize5=(_b[ds_`T'_37]/abs(`mean'))*100
	estadd scalar effectsize10=(_b[ds_`T'_42]/abs(`mean'))*100
	estadd scalar effectsize20=(_b[ds_`T'_52]/abs(`mean'))*100
	estadd scalar effectsize25=(_b[ds_`T'_57]/abs(`mean'))*100
	
	estimates store c`Y'`T'
	
	local row = 0
    
    	
*storing coefficient estimates for ES plots    
   forvalues t = 2(1)30 {
        local ++row
        qui replace b_`Y'`T' = _b[ds_`T'_`t'] in `row'
        qui replace upper_`Y'`T' = _b[ds_`T'_`t'] + 1.96*_se[ds_`T'_`t'] in `row'
        qui replace lower_`Y'`T' = _b[ds_`T'_`t']-  1.96*_se[ds_`T'_`t'] in `row'
    }
    local ++row
    qui replace b_`Y'`T'= 0 in `row'
    forvalues t = 32/62 {
        local ++row
        qui replace b_`Y'`T'  = _b[ds_`T'_`t'] in `row'
        qui replace upper_`Y'`T' = _b[ds_`T'_`t'] + 1.96*_se[ds_`T'_`t'] in `row'
        qui replace lower_`Y'`T' = _b[ds_`T'_`t'] - 1.96*_se[ds_`T'_`t'] in `row'
    }
	
*ES plots	
	summ `Y' if date==d(15apr2020)
	local mean : di %3.2f r(mean) 
	local stdev: di %3.2f r(sd)
	di `mean'
	di `stdev'

   # delimit ;
    twoway
        (rarea upper_`Y'`T' lower_`Y'`T' timeG if inrange(timeG, -30,30), color(gs12%35))
        (connected b_`Y'`T' timeG if inrange(timeG, -30,-2),
            mcolor(cranberry) lwidth(thick) lcolor(cranberry) msize(medium))
		(connected b_`Y'`T' timeG if inrange(timeG, 0,30),
            mcolor(cranberry) lwidth(thick) lcolor(cranberry) msize(medium))
        (function y = 0, range(-30 30) lcolor(gs10)),
        xline(-.5 , lwidth(2.2) lcolor(gs10) )
        xsize(4) ysize(2)
        xtitle("") /*ytitle("`Label`Y''", size(medium))*/
		graphregion(color(white)) 
		xsc(range(-30 30))
        xlabel(-30(4)30, labsize(large) nogrid)
		ylabel(/*-15(5)5*/, labsize(large) nogrid) 	
        legend(off)
        graphregion(margin(r+5))
       /* title("`Title`T'':" "`Label`Y''", pos(11) size(4.5) color(black))*/
		note("Baseline DV mean=`mean', std. dev.=`stdev'" "{it:Source: SafeGraph Aggregated Mobility Metrics} (09 April 2020 - 19 June 2020)", size(4.5))
        name(`Y'`T', replace)
     ;
    # delimit cr
 		
 
 rename __hdfe2__ datefe`Y'`T'
 
}
}


*Specifying common coefficient label names for each event-time dummy coefficient across all estimations to be used in esttab command
forval i = 1(1)31 {
    local j=32-`i'
    local rename_opt `rename_opt' ds_ReOpen_`i' `j'daysprior ds_ReOpenMajor_`i' `j'daysprior ds_ReOpenPhase2_`i' `j'daysprior ds_FirstAnnounce_`i' `j'daysprior
    local coeflabels_opt `coeflabels_opt' `j'daysprior "`j' days prior to event"
}
forval p = 32/62 {
    local k=`p'-32
    local rename_opt `rename_opt' ds_ReOpen_`p' `k'afterevent ds_ReOpenMajor_`p' `k'afterevent ds_ReOpenPhase2_`p' `k'afterevent ds_FirstAnnounce_`p' `k'afterevent
    if `p' == 32 local coeflabels_opt `coeflabels_opt' `k'afterevent "Day of event"
    else if `p' == 33 local coeflabels_opt `coeflabels_opt' `k'afterevent "1 day after event"
    else local coeflabels_opt `coeflabels_opt' `k'afterevent "`k' days after event"
}

di "`rename_opt'"
di `" `coeflabels_opt' "'


  esttab cne_share2ReOpen cne_share4ReOpen cwthometimeReOpen cne_share2FirstAnnounce cne_share4FirstAnnounce cwthometimeFirstAnnounce  using "$output\Table2_panelII_medTimeAtHome_fracWork_fracHome.csv", ///
drop(31daysprior _cons ds_ReOpen_63  ds_FirstAnnounce_63) b(a3) se(3)  nogaps  nolabel star(* 0.10 ** 0.05 *** 0.01) ///
label title("For SafeGraph Reopening: Fraction leaving home and Avg. Median Hours at Home State Re-openings") mtitles("Fraction Leaving Home" "Median Time at Home")  ///
rename(`rename_opt') coeflabels(`coeflabels_opt') stats(N base effectsize5 effectsize10 effectsize20 effectsize25, labels(`"Observations"' `"Baseline DV mean"' `"Effect size after 5 days"' `"Effect size after 10 days"' `"Effect size after 20 days"' `"Effect size after 25 days"')) replace 

esttab cne_share2ReOpen cne_share4ReOpen cwthometimeReOpen cne_share2FirstAnnounce cne_share4FirstAnnounce cwthometimeFirstAnnounce using "$output\Table2_panelII_medTimeAtHome_fracWork_fracHome.tex", ///
drop(31daysprior _cons ds_ReOpen_63  ds_FirstAnnounce_63) b(a3) se(3)  nogaps  nolabel star(* 0.10 ** 0.05 *** 0.01) ///
label title("For SafeGraph Reopening: Fraction leaving home and Avg. Median Hours at Home State Re-openings") mtitles("Fraction Leaving Home" "Median Time at Home")  ///
rename(`rename_opt') coeflabels(`coeflabels_opt') stats(N base effectsize5 effectsize10 effectsize20 effectsize25, labels(`"Observations"' `"Baseline DV mean"' `"Effect size after 5 days"' `"Effect size after 10 days"' `"Effect size after 20 days"' `"Effect size after 25 days"')) replace 

  
# delimit ;
graph combine ne_share2FirstAnnounce ne_share4FirstAnnounce wthometimeFirstAnnounce ne_share2ReOpen ne_share4ReOpen wthometimeReOpen , cols(3) xsize(11) ysize(9) iscale(.5) imargin(small)
    graphregion(color(white))
    name(limits1, replace)
	title("Effects of Re-opening on Change on Fraction Leaving Home and Median Hours at Home", size(2.25)) subtitle("(State Level Analysis)", size(1.75))
    b1title("Days relative to re-opening", size(2.25))
	note("{it:Source: SafeGraph Aggregated Mobility Metrics} (09 April 2020 - 19 June 2020)", size(1.75))
;
# delimit cr
	graph export "$output\Fig2_panelII_medTimeAtHome_fracWork_fracHome.png",  replace  width(4000)	
 
