* AUTHOR:SUMEDHA GUPTA
****************************************************************************************************************************************************************

clear all

* Root folder globals
global root		"G:\.shortcut-targets-by-id\1DeeHcG7EI1A4gdwrBHn0IJ6BFVfzediU\BPEA2020\Data\ReplicationPackage"

* Script folder globals
global scripts	"$root\scripts"
global output	"$root\results"
 
* Other required folders in case they are needed (Put here all other globals and comment them)
global data_file_path "$root\DataDevelopment"
global miscdir 		  "$data_file_path\miscdata"     			// misc. data 
global ready		  "$data_file_path\cleandata"	 
global rawdata		  "$data_file_path\rawdata"	 
********************************************************************************

*Open the state-day Apple Mobility data
use "$ready\reopenings\AppleMobility_state.dta", clear

* dropping data before 09apr2020
drop if date<td(09apr2020)

*Create dummies for post period for each policy variable. 
foreach var in EmergDec  SchoolClose StayAtHome  FirstCase FirstDeath ReOpen /*ReOpenMajor ReOpenPhase2*/ FirstAnnounce{
	gen Post`var'  = date >= Date`var' 
	label var Post`var' "Post x `var'" 
}

*Make titles to be used in ES graphs /table
		local TitleEmergDec  "Emergency Declarations" 
		local TitleGathRestrictAny  "Gathering Restrictions"
		local TitleNEBusinessClose  "NE Business Closure"
		local TitleSchoolClose  "School Closure"
		local TitleStayAtHome  "Stay-at-Home"
		local TitleRestOtherRestrict  "Restaurant/business Closure"
		local TitleFirstCase  "First Confirmed Case"	
		local TitleFirstDeath "First Death"
		local TitleReOpen "Initial Re-opening"
		local TitleReOpenMajor "Major Re-opening"
		local TitleReOpenPhase2 "Phase 2 Re-opening"
		local TitleFirstAnnounce "Announcement of Initial Reopening"
		local LabelRR_pctch   "Retail/Recreation" 
		local LabelGP_pctch   "Grocery/Pharmacy"
		local LabelPB_pctch   "Parks/Beaches"
		local LabelTRANSIT_pctch   "Transit Stations"
		local LabelWORKPLACE_pctch  "Workplace"
		local LabelRESIDENTIAL_pctch  "Residential Areas"
		
*Make the event study variables.
foreach var in FirstCase EmergDec SchoolClose StayAtHome FirstDeath ReOpen /*ReOpenMajor ReOpenPhase2*/ FirstAnnounce{
	gen days_since_`var' = date - Date`var'	
	summ days_since_`var' if /*date>td(08apr2020) & date<td(03may2020)*/ date==td(15apr2020), detail
	gen median`var'=r(p50)
	gen above`var'=(days_since_`var'>=median`var') if date==td(15apr2020)
	bysort state: egen above_meddays`var'=max(above`var')
	replace days_since_`var' = -31 if days_since_`var'<=-31
	replace days_since_`var' = 31 if days_since_`var'>=31 & days_since_`var'~=.
	replace days_since_`var' = -1 if days_since_`var'==.
	quietly tab days_since_`var', gen(ds_`var'_)
	
	
}	
gen timeG = -31+ _n in 1/100



*Fit the event study regressions
foreach T in  ReOpen /*ReOpenMajor ReOpenPhase2*/ FirstAnnounce{
*initiate variables to store regression coefs
    gen b_`T' = .
	gen upper_`T' = .
	gen lower_`T' = .
	
*baseline dep var value to add to regression coef table
	summ driving_mobility if date==d(15apr2020)
	local mean : di %3.2f r(mean) 
	local stdev: di %3.2f r(sd)
	di `mean'
	di `stdev'

*ES regression
	reghdfe driving_mobility  ds_`T'_1-ds_`T'_30 ds_`T'_32-ds_`T'_63 prcp tavg, ///
	absorb(state_d date, save) cluster(state_d)
	estadd scalar base=`mean'
	estadd scalar effectsize5=(_b[ds_`T'_37]/abs(`mean'))*100
	estadd scalar effectsize10=(_b[ds_`T'_42]/abs(`mean'))*100
	estadd scalar effectsize20=(_b[ds_`T'_52]/abs(`mean'))*100
	estadd scalar effectsize25=(_b[ds_`T'_57]/abs(`mean'))*100
	
*storing estimates
	estimates store c`T'
	
	local row = 0
 
*storing coefficient estimates for ES plots
  forvalues t = 2(1)30 {
        local ++row
        qui replace b_`T' = _b[ds_`T'_`t'] in `row'
        qui replace upper_`T' = _b[ds_`T'_`t'] + 1.96*_se[ds_`T'_`t'] in `row'
        qui replace lower_`T' = _b[ds_`T'_`t']-  1.96*_se[ds_`T'_`t'] in `row'
    }
    local ++row
    qui replace b_`T'= 0 in `row'
    forvalues t = 32/62 {
        local ++row
        qui replace b_`T'  = _b[ds_`T'_`t'] in `row'
        qui replace upper_`T' = _b[ds_`T'_`t'] + 1.96*_se[ds_`T'_`t'] in `row'
        qui replace lower_`T' = _b[ds_`T'_`t'] - 1.96*_se[ds_`T'_`t'] in `row'
    }

*ES plots
   # delimit ;
    twoway
        (rarea upper_`T' lower_`T' timeG if inrange(timeG, -30,30), color(gs12%35))
        (connected b_`T' timeG if inrange(timeG, -30,-2),
            mcolor(cranberry) lwidth(medium) lcolor(cranberry) msize(medium))
		(connected b_`T' timeG if inrange(timeG, 0,30),
            mcolor(cranberry) lwidth(medium) lcolor(cranberry) msize(medium))
        (function y = 0, range(-30 30) lcolor(gs10)),
        xline(-.5 , lwidth(2.2) lcolor(gs10) )
        xsize(4) ysize(2)
        xtitle("") ytitle("Change in request for driving direction", size(small))
		graphregion(color(white))
        xlabel(-30(5)30, labsize(small) nogrid)
		ylabel(/*-60(20)40*/, labsize(small) nogrid) 	
        legend(off)
        graphregion(margin(r+5))
        title("`Title`T''", pos(11) size(4.5))
        name(`T', replace)
     ;
    # delimit cr
 	
 
* storing date FE from each estimation
 rename __hdfe2__ datefe`T'
 
}

*Specifying common coefficient label names for each event-time dummy coefficient across all estimations to be used in esttab command
forval i = 1(1)31 {
    local j=32-`i'
    local rename_opt `rename_opt' ds_ReOpen_`i' `j'daysprior ds_ReOpenMajor_`i' `j'daysprior ds_ReOpenPhase2_`i' `j'daysprior ds_FirstAnnounce_`i' `j'daysprior
    local coeflabels_opt `coeflabels_opt' `j'daysprior "`j' days prior to event"
}
forval p = 32/62 {
    local k=`p'-32
    local rename_opt `rename_opt' ds_ReOpen_`p' `k'afterevent ds_ReOpenMajor_`p' `k'afterevent ds_ReOpenPhase2_`p' `k'afterevent ds_FirstAnnounce_`p' `k'afterevent
    if `p' == 32 local coeflabels_opt `coeflabels_opt' `k'afterevent "Day of event"
    else if `p' == 33 local coeflabels_opt `coeflabels_opt' `k'afterevent "1 day after event"
    else local coeflabels_opt `coeflabels_opt' `k'afterevent "`k' days after event"
}

di "`rename_opt'"
di `" `coeflabels_opt' "'

* Creating ES coefficient estimates table corresponding to Fig 5
esttab cReOpen  /*cReOpenMajor cReOpenPhase2*/ cFirstAnnounce using "$output\Table2_panelII_applemobiviliy_drivingdirections.csv", ////
drop(31daysprior _cons ds_ReOpen_63 /*ds_ReOpenMajor_43 ds_ReOpenPhase2_43*/ ds_FirstAnnounce_63) b(a3) se(3)  nogaps  nolabel star(* 0.10 ** 0.05 *** 0.01) ///
label title("Apple Mobility changes following State re-openings") mtitles("Change in request for driving direction")  ///
rename(`rename_opt') coeflabels(`coeflabels_opt') stats(N base effectsize5 effectsize10 effectsize20 effectsize25, labels(`"Observations"' `"Baseline DV mean"' `"Effect size after 5 days"' `"Effect size after 10 days"' `"Effect size after 20 days"' `"Effect size after 25 days"')) replace 


esttab cReOpen  /*cReOpenMajor cReOpenPhase2*/ cFirstAnnounce using "$output\Table2_panelII_applemobiviliy_drivingdirections.tex", ////
drop(31daysprior _cons ds_ReOpen_63 /*ds_ReOpenMajor_43 ds_ReOpenPhase2_43*/ ds_FirstAnnounce_63) b(a3) se(3)  nogaps  nolabel star(* 0.10 ** 0.05 *** 0.01) ///
label title("Apple Mobility changes following State re-openings") mtitles("Change in request for driving direction")  ///
rename(`rename_opt') coeflabels(`coeflabels_opt') stats(N base effectsize5 effectsize10 effectsize20 effectsize25, labels(`"Observations"' `"Baseline DV mean"' `"Effect size after 5 days"' `"Effect size after 10 days"' `"Effect size after 20 days"' `"Effect size after 25 days"')) replace 
	
* Getting mean value of dep var as of April 15, 2020 i.e. provided at the bottom of Fig 5
summ driving_mobility if date==d(15apr2020)
	local mean : di %3.2f r(mean) 
	local stdev: di %3.2f r(sd)
	di `mean'
	di `stdev'

* Combining individual ES coef. plots into single panel to generate Fig 5a
# delimit ;
graph combine FirstAnnounce ReOpen /*ReOpenMajor ReOpenPhase2*/ , cols(2) xsize(6.5) ysize(3) iscale(.91) imargin(small)
    graphregion(color(white))
    name(limits1, replace)
	title("Effects of Re-openings on Change in Apple Mobility Requests for Driving Directions", size(small)) subtitle("(State Level Events)", size(vsmall))
    b1title("Days relative to event", size(small))
	note("Baseline dependent variable mean=`mean', std. dev.=`stdev'" "{it:Source: Apple Mobility} (09 April 2020 - 20 June 2020)", size(small))
;
# delimit cr
	graph export "$output\Reopenings_applemobiviliy_drivingdirections.png",  replace  width(4000)	
