********************************************************************************

clear all

* Root folder globals
global root		"G:\.shortcut-targets-by-id\1DeeHcG7EI1A4gdwrBHn0IJ6BFVfzediU\BPEA2020\Data\ReplicationPackage"

* Script folder globals
global scripts	"$root\scripts"
global output	"$root\results"
 
* Other required folders in case they are needed (Put here all other globals and comment them)
global data_file_path "$root\DataDevelopment"
global miscdir 		  "$data_file_path\miscdata"     			// misc. data 
global ready		  "$data_file_path\cleandata"	 
global rawdata		  "$data_file_path\rawdata"	 
********************************************************************************

*Open the state-day PlaceIQ DEX files (Mixing Index)
use "$ready\closures\state_placeIQ_DEX.dta", clear
drop if date>td(14apr2020)
order stfips state Statename date 

********************************************************************************
ssc install blindschemes, replace all
set scheme plotplain

*Make the Post Policy and Event Time variables.
foreach var in EmergDec SchoolClose StayAtHome FirstCase FirstDeath{
	*Post Policy Dummy
	gen Post`var'  = date >= Date`var' 
	
	*Event Time Running Variable
	gen days_since_`var' = date - Date`var'	
	
	*Bottom code event time at -21 for cases where true event time is <=21
	replace days_since_`var' = -31 if days_since_`var'<=-31
	
	*Top code event time at 21 for cases where true event time is >=21
	replace days_since_`var' = 31 if days_since_`var'>=31 & days_since_`var'~=.
	
	*Set never treated cases = -1
	replace days_since_`var' = -1 if days_since_`var'==.
	
	*Make event time dummies.
	quietly tab days_since_`var', gen(ds_`var'_)
}

********************************************************************************

*Fit the event study for emergency declarations.
reghdfe dex ds_EmergDec_1-ds_EmergDec_30 ds_EmergDec_32-ds_EmergDec_63, ///
absorb(state date, save) cluster(state) residuals

*Compute fitted values.
predict xbdEmergDec_true, xbd

*Remove event study effects to make a counterfactual.
gen xbdEmergDec_counter = xbdEmergDec_true
forvalues k = 32(1)63 {
	replace xbdEmergDec_counter = xbdEmergDec_true - _b[ds_EmergDec_`k'] * ds_EmergDec_`k'
}	                        

*store the fixed effects and residuals.
rename (_reghdfe_resid __hdfe1__ __hdfe2__)(resid_ed statefe_ed datefe_ed)

*Fit the event study for school closures.
*reghdfe wthometime ds_SchoolClose_1-ds_SchoolClose_20 ds_SchoolClose_22-ds_SchoolClose_43, ///
*absorb(state date, save) cluster(state) residuals


*Collapse to the cross-state national level.	
collapse (mean) dex xbdEmergDec_true xbdEmergDec_counter resid_ed statefe_ed datefe_ed (sum) PostEmergDec, by(date)
format date %td

********************************************************************************
*Compute the shares over time.

*Compute the mean for the week of Wednesday February 26 to Tuesday March 3.
su xbdEmergDec_true if inrange(date, td(26Feb2020), td(03Mar2020))
local Actual_pre = r(mean)

su xbdEmergDec_counter if inrange(date, td(26Feb2020), td(03Mar2020))
local CF_pre = r(mean)

*Compute the mean for the week of Wednesday April 8 to Tuesday April 14.
su xbdEmergDec_true if inrange(date, td(08Apr2020), td(14Apr2020))
local Actual_post = r(mean)

su xbdEmergDec_counter if inrange(date, td(08Apr2020), td(14Apr2020))
local CF_post = r(mean)

local Delta_actual = `Actual_post' - `Actual_pre'
local Delta_cf = `CF_post' - `CF_pre'

local secular_share = `Delta_cf' / `Delta_actual'
local policy_share = (`Delta_actual' - `Delta_cf') / `Delta_actual'
local p2Share = 1 - `secular_share'

di "Secular Share: " `secular_share'
di "Policy Share: " `policy_share'
di "P2 Policy Share: " `p2Share'
********************************************************************************
*Make the Counterfactual graph the results.	
*Add information about the averaging.
graph twoway ///
	(line xbdEmergDec_true date, lpattern(solid ) lcolor(vermillion)) ///
	(line xbdEmergDec_counter date, lpattern(shortdash)  lcolor(navy)) ///
	(scatteri  `Actual_pre' 21974.5, msymbol(square) mcolor(vermillion)) ///
	(scatteri `Actual_post' 22015.5, msymbol(square) mcolor(vermillion)) ///
	(scatteri  `CF_pre' 21974, msymbol(s) mcolor(navy)) ///
	(scatteri `CF_post' 22015, msymbol(s) mcolor(navy)), ///
	title(/*"Figure 1: Estimated Effects of Emergency Declarations on Mixing Index"*/ "National Trends", size(3.5)) ///
	ytitle("Mixing Index") ///
	legend(label(1 "Realized") label(2 "Counterfactual (No Policy)") order(1 2) pos(6) rows(1)) ///
	xlabel(21934(20)22019) ///
	xtitle("") xline(21971) xline(21977) xline(22013) xline(22019) 
	
	graph export "$output\Decomposition_closures_dex_figure.png", as(png) name("Graph") replace
	stop
*Inspect the Fixed Effects Patterns	
graph twoway ///
	(line xbdEmergDec_true date, lpattern(solid ) lcolor(navy)) ///
	(connected xbdEmergDec_counter datefe date, lpattern(solid ) lcolor(vermillion)), ///
	title("Average Date FE vs Average Counterfactuals") ///
	ytitle("Hours At Home") legend(off) ///
	xtitle("")	
	
