****************************************************************************************************************************************************************
clear all

* Root folder globals
global root		"G:\.shortcut-targets-by-id\1DeeHcG7EI1A4gdwrBHn0IJ6BFVfzediU\BPEA2020\Data\ReplicationPackage"

* Script folder globals
global scripts	"$root\scripts"
global output	"$root\results"
 
* Other required folders in case they are needed (Put here all other globals and comment them)
global data_file_path "$root\DataDevelopment"
global miscdir 		  "$data_file_path\miscdata"     			// misc. data 
global ready		  "$data_file_path\cleandata"	 
global rawdata		  "$data_file_path\rawdata"	 
********************************************************************************
*Open the state-day PlaceIQ LEX files 
use "$ready\closures\state_placeIQ_LEX.dta", clear
drop if date>td(14apr2020)

*Make a dummy variable for each policy variable. 
capture rename DateFirstCase DateFirstConfirmedCase
foreach var in EmergDec  SchoolClose StayAtHome  FirstConfirmedCase FirstDeath{
	gen Post`var'  = date >= Date`var' 
	label var Post`var' "Post x `var'" 
}

*Make titles to be used in ES graphs 
		local TitleEmergDec  "Emergency Declarations" 
		local TitleSchoolClose  "School Closure"
		local TitleStayAtHome  "Stay-at-Home"
		local TitleFirstConfirmedCase  "First Confirmed Case"	
		local TitleFirstDeath "First Death"

*Create event-time dummies
foreach var in FirstConfirmedCase EmergDec SchoolClose StayAtHome FirstDeath {
	gen days_since_`var' = date - Date`var'	
	egen maxdays_since_`var'=max(days_since_`var')
	gen max`var'=maxdays_since_`var'+32
	replace days_since_`var' = -31 if days_since_`var'<=-31
	replace days_since_`var' = 31 if days_since_`var'>=31 & days_since_`var'~=.
	replace days_since_`var' = -1 if days_since_`var'==.
	quietly tab days_since_`var', gen(ds_`var'_)
}	
gen timeG = -31+ _n in 1/100

gen ds_StayAtHome_59=0
gen ds_StayAtHome_60=0
gen ds_StayAtHome_61=0
gen ds_StayAtHome_62=0
gen ds_StayAtHome_63=0
gen ds_SchoolClose_62=0
gen ds_SchoolClose_63=0

*Fit the event study regressions
foreach T in FirstConfirmedCase EmergDec SchoolClose StayAtHome FirstDeath{
*Initiating variables to store coefficients and upper and lower 95% CI
    gen b_`T' = .
	gen upper_`T' = .
	gen lower_`T' = .
	
* Getting mean value of dep var as of March 1, 2020 i.e. provided at the bottom of Fig 5d
summ totOOS_movement if date==d(01mar2020)
	local mean : di %3.2f r(mean) 
	local stdev: di %3.2f r(sd)
	di `mean'
	di `stdev'

	reghdfe totOOS_movement ds_`T'_1-ds_`T'_30 ds_`T'_32-ds_`T'_58 ds_`T'_59 ds_`T'_60 ds_`T'_61 ds_`T'_62 ds_`T'_63, ///
		    absorb(state_d date, save) cluster(state_d)
	estadd scalar base=`mean'
	estadd scalar effectsize5=(_b[ds_`T'_37]/abs(`mean'))*100
	estadd scalar effectsize10=(_b[ds_`T'_42]/abs(`mean'))*100
	estadd scalar effectsize20=(_b[ds_`T'_52]/abs(`mean'))*100
	estadd scalar effectsize25=(_b[ds_`T'_57]/abs(`mean'))*100
	estadd scalar effectsize26=(_b[ds_`T'_58]/abs(`mean'))*100
	estimates store c`T'
	
	local row = 0

* Storing coefficients and upper and lower 95% CI
   forvalues t = 2(1)30 {
        local ++row
        qui replace b_`T' = _b[ds_`T'_`t'] in `row'
        qui replace upper_`T' = _b[ds_`T'_`t'] + 1.96*_se[ds_`T'_`t'] in `row'
        qui replace lower_`T' = _b[ds_`T'_`t']-  1.96*_se[ds_`T'_`t'] in `row'
    }
    local ++row
    qui replace b_`T'= 0 in `row'
    forvalues t = 32/62 {
        local ++row
        qui replace b_`T'  = _b[ds_`T'_`t'] in `row'
        qui replace upper_`T' = _b[ds_`T'_`t'] + 1.96*_se[ds_`T'_`t'] in `row'
        qui replace lower_`T' = _b[ds_`T'_`t'] - 1.96*_se[ds_`T'_`t'] in `row'
    }

* Plotting ES graph for individual policies/informational event
   # delimit ;
    twoway
        (rarea upper_`T' lower_`T' timeG if inrange(timeG, -30,30), color(gs12%35))
        (connected b_`T' timeG if inrange(timeG, -30,-2),
            mcolor(cranberry) lwidth(medium) lcolor(cranberry) msize(small))
		(connected b_`T' timeG if inrange(timeG, 0,30),
            mcolor(cranberry) lwidth(medium) lcolor(cranberry) msize(small))
        (function y = 0, range(-30 30) lcolor(gs10)),
        xline(-.5 , lwidth(2.2) lcolor(gs10) ) 
        xsize(4) ysize(2) scheme(s2gcolor)
        xtitle("") ytitle("Out-of-state movement", size(vsmall))
		graphregion(color(white))
        xlabel(-30(5)30, labsize(small))
		ylabel(-.2(.1).1, labsize(small) ) 	
        legend(off)
        graphregion(margin(r+5))
        title("`Title`T''", pos(11) size(3.5))
        name(`T', replace)
     ;
    # delimit cr
	
	
* storing date FE from each estimation
 rename __hdfe2__ datefe`T'
 
}

*Specifying common coefficient label names for each event-time dummy coefficient across all estimations to be used in esttab command
forval i = 1(1)31 {
    local j=32-`i'
    local rename_opt `rename_opt' ds_FirstConfirmedCase_`i' `j'daysprior ds_EmergDec_`i' ///
	`j'daysprior ds_SchoolClose_`i' `j'daysprior ds_StayAtHome_`i' `j'daysprior ds_FirstDeath_`i' `j'daysprior
    local coeflabels_opt `coeflabels_opt' `j'daysprior "`j' days prior to event"
}
forval p = 32/62 {
    local k=`p'-32
    local rename_opt `rename_opt' ds_FirstConfirmedCase_`p' `k'afterevent ds_EmergDec_`p' ///
	`k'afterevent ds_SchoolClose_`p' `k'afterevent ds_StayAtHome_`p' `k'afterevent ds_FirstDeath_`p' `k'afterevent
    if `p' == 32 local coeflabels_opt `coeflabels_opt' `k'afterevent "Day of event"
    else if `p' == 33 local coeflabels_opt `coeflabels_opt' `k'afterevent "1 day after event"
    else local coeflabels_opt `coeflabels_opt' `k'afterevent "`k' days after event"
}

di "`rename_opt'"
di `" `coeflabels_opt' "'

* Creating ES coefficient estimates table corresponding to Fig 5d
esttab cFirstConfirmedCase cEmergDec cSchoolClose  cStayAtHome cFirstDeath  using "$output/TableES_Fig5d_totOOSmove.csv", ///
	   drop(31daysprior _cons ds_FirstConfirmedCase_63 ds_EmergDec_63 ds_SchoolClose_63 ds_StayAtHome_63 ds_FirstDeath_63) ///
	   b(a3) se(3)  nogaps  nolabel star(* 0.10 ** 0.05 *** 0.01) ///
       label title("For Fig 5d: Leaving the State (in last 14 days), State Policy and Information Events") ///
	   mtitles("First Confirmed Case" "Emergency Declarations" "School Closure" "Stay-at-Home")  ///
		rename(`rename_opt') coeflabels(`coeflabels_opt') stats(N base effectsize5 effectsize10 effectsize20 effectsize25 effectsize26, ///
		labels(`"Observations"' `"Baseline DV mean"' `"Effect size after 5 days"' `"Effect size after 10 days"' `"Effect size after 20 days"' `"Effect size after 25 days"' `"Effect size after 26 days"')) replace
	
esttab cFirstConfirmedCase cEmergDec cSchoolClose  cStayAtHome cFirstDeath  using "$output/TableES_Fig5d_totOOSmove.tex", ///
	   drop(31daysprior _cons ds_FirstConfirmedCase_63 ds_EmergDec_63 ds_SchoolClose_63 ds_StayAtHome_63 ds_FirstDeath_63) ///
	   b(a3) se(3)  nogaps  nolabel star(* 0.10 ** 0.05 *** 0.01) ///
       label title("For Fig 5d: Leaving the State (in last 14 days), State Policy and Information Events") ///
	   mtitles("First Confirmed Case" "Emergency Declarations" "School Closure" "Stay-at-Home")  ///
		rename(`rename_opt') coeflabels(`coeflabels_opt') stats(N base effectsize5 effectsize10 effectsize20 effectsize25 effectsize26, ///
		labels(`"Observations"' `"Baseline DV mean"' `"Effect size after 5 days"' `"Effect size after 10 days"' `"Effect size after 20 days"' `"Effect size after 25 days"' `"Effect size after 26 days"')) replace

* Getting mean value of dep var as of March 1, 2020 i.e. provided at the bottom of Fig 5d
summ totOOS_movement if date==d(01mar2020)
	local mean : di %3.2f r(mean) 
	local stdev: di %3.2f r(sd)
	di `mean'
	di `stdev'

* Combining individual ES coef. plots into single panel to generate Fig 5d
# delimit ;
graph combine FirstConfirmedCase EmergDec SchoolClose StayAtHome FirstDeath, cols(2) xsize(6.5) ysize(8) iscale(.7) imargin(small)
    graphregion(color(white))
    name(limits1, replace)
	/*title("Effects of Mitigation Policies and Information Events" "on Out-of-State Movement", size(small)) */
	subtitle("(State Level Events)", size(vsmall))
    b1title("Days relative to event", size(small))
	note("Baseline dependent variable mean=`mean', std. dev.=`stdev'" "{it:Source: PlaceIQ Geolocation Data}", size(vsmall))
;
# delimit cr
	graph export "$output\Fig5d_totOOSmove.png",  replace  width(4000)	

