* This do file makes STATE-LEVEL PlaceIQ data Figure 3
* AUTHOR:SUMEDHA GUPTA
****************************************************************************************************************************************************************
clear all

* Root folder globals
global root		"G:\.shortcut-targets-by-id\1DeeHcG7EI1A4gdwrBHn0IJ6BFVfzediU\BPEA2020\Data\ReplicationPackage"

* Script folder globals
global scripts	"$root\scripts"
global output	"$root\results"
 
* Other required folders in case they are needed (Put here all other globals and comment them)
global data_file_path "$root\DataDevelopment"
global miscdir 		  "$data_file_path\miscdata"     			// misc. data 
global ready		  "$data_file_path\cleandata"	 
global rawdata		  "$data_file_path\rawdata"	 
********************************************************************************
use "$data_file_path\smokeplots\Fig3_MixingIndex_totOOSmove_totOOCmove_placeiq.dta", clear

foreach j in 2 3 4 5 6 7 9 10 11 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48  {
   local pre1 `pre1' line dex`j' date if dex`j'<400, c(L) lc(gs12) lw(thin)||
   local postSAH1 `postSAH1' line postSAHdex`j' date, c(L) lc(red*.5) lw(thin)||
   local postReOpen1 `postReOpen1' line postReOpendex`j' date, c(L) lc(green*.4) lw(thin)||
   local pre2 `pre2' line OOS`j' date, c(L) lc(gs12) lw(thin)||
   local postSAH2 `postSAH2' line postSAHOOS`j' date, c(L) lc(red*.5) lw(thin)||
   local postReOpen2 `postReOpen2' line postReOpenOOS`j' date, c(L) lc(green*.4) lw(thin)||
   local pre3 `pre3' line OOC`j' date, c(L) lc(gs12) lw(thin)||
   local postSAH3 `postSAH3' line postSAHOOC`j' date, c(L) lc(red*.5) lw(thin)||
   local postReOpen3 `postReOpen3' line postReOpenOOC`j' date, c(L) lc(green*.4) lw(thin)||
 }

# delimit ; 
twoway `pre1'
    || `postSAH1' 
	|| `postReOpen1'
    || line natdex date, lw(medium) lc(black)  
    ||, xsize(2.5) ysize(2)
        xtitle("") ytitle("Mixing Index", size(medium) color(black))
		yscale(titlegap(*12))
		graphregion(color(white))
        xlabel(21960(20)22080, labsize(small) nogrid)
		ylabel(/*-60(20)40*/, labsize(small) nogrid) 
        legend(off)
        graphregion(margin(r+5))
        note("{it:Source: PlaceIQ}                                        Y-axis is truncated at 400", size(medsmall)) 
		/*title("Mixing Index", pos(11) size(4.5) color(black))*/
        name(PIQ1, replace) 
     ;

	 # delimit cr
 	graph export "$plotdir\Fig4_PlaceIQ_1.png",  replace  width(10000)	

# delimit ; 
twoway `pre2'
    || `postSAH2' 
	|| `postReOpen2' 
    || line natOOS date, lw(medium) lc(black)  
    ||, xsize(2.5) ysize(2)
        xtitle("") ytitle("Total Out-of-State Movement", size(medium) color(black))
		yscale(titlegap(*12))
		graphregion(color(white))
        xlabel(21960(20)22080, labsize(small) nogrid)
		ylabel(/*-60(20)40*/, labsize(small) nogrid) 
        legend(off)
        graphregion(margin(r+5))
        note("{it:Source: PlaceIQ}", size(medsmall)) 
        name(PIQ2, replace) 
     ;

	 # delimit cr
 	graph export "$plotdir\Fig4_PlaceIQ_2.png",  replace  width(3000)	

	# delimit ; 
twoway `pre3'
    || `postSAH3' 
	|| `postReOpen3' 
    || line natOOC date, lw(medium) lc(black)  
    ||, xsize(2.5) ysize(2)
        xtitle("") ytitle("Total Out-of-County Movement", size(medium) color(black))
		yscale(titlegap(*12))
		graphregion(color(white))
        xlabel(21960(15)22080, labsize(small) nogrid)
		ylabel(/*-60(20)40*/, labsize(small) nogrid) 
        legend(off)
        graphregion(margin(r+5))
        note("{it:Source: PlaceIQ}", size(medsmall)) 
        name(PIQ3, replace) 
     ;

	 # delimit cr
 	graph export "$plotdir\Fig4_PlaceIQ_3.png",  replace  width(3000)	

