* This do file prepares Google Mobility Figure 3 
* AUTHOR:SUMEDHA GUPTA
****************************************************************************************************************************************************************

clear all

* Root folder globals
global root		"G:\.shortcut-targets-by-id\1DeeHcG7EI1A4gdwrBHn0IJ6BFVfzediU\BPEA2020\Data\ReplicationPackage"

* Script folder globals
global scripts	"$root\scripts"
global output	"$root\results"
 
* Other required folders in case they are needed (Put here all other globals and comment them)
global data_file_path "$root\DataDevelopment"
global miscdir 		  "$data_file_path\miscdata"     			// misc. data 
global ready		  "$data_file_path\cleandata"	 
global rawdata		  "$data_file_path\rawdata"	 
********************************************************************************

*Open the state-day Google Mobility data
use "$data_file_path\smokeplots\Fig3_RR_GP_TRANSIT_WORK_RES_googlemobility.dta", clear


foreach j in 2 3 4 5 6 7 9 10 11 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 {
   local pre1 `pre1' line RR`j' date, c(L) lc(gs12) lw(thin)||
   local postSAH1 `postSAH1' line postSAHRR`j' date, c(L) lc(red*.5) lw(thin)||
   local postReOpen1 `postReOpen1' line postReOpenRR`j' date, c(L) lc(green*.4) lw(thin)||
   local pre2 `pre2' line GP`j' date, c(L) lc(gs12) lw(thin)||
   local postSAH2 `postSAH2' line postSAHGP`j' date, c(L) lc(red*.5) lw(thin)||
   local postReOpen2 `postReOpen2' line postReOpenGP`j' date, c(L) lc(green*.4) lw(thin)||
   local pre3 `pre3' line PB`j' date, c(L) lc(gs12) lw(thin)||
   local postSAH3 `postSAH3' line postSAHPB`j' date, c(L) lc(red*.5) lw(thin)||
   local postReOpen3 `postReOpen3' line postReOpenPB`j' date, c(L) lc(green*.4) lw(thin)||
   local pre4 `pre4' line TRANSIT`j' date, c(L) lc(gs12) lw(thin)||
   local postSAH4 `postSAH4' line postSAHTRANSIT`j' date, c(L) lc(red*.5) lw(thin)||
   local postReOpen4 `postReOpen4' line postReOpenTRANSIT`j' date, c(L) lc(green*.4) lw(thin)||
   local pre5 `pre5' line WORK`j' date, c(L) lc(gs12) lw(thin)||
   local postSAH5 `postSAH5' line postSAHWORK`j' date, c(L) lc(red*.5) lw(thin)||
    local postReOpen5 `postReOpen5' line postReOpenWORK`j' date, c(L) lc(green*.4) lw(thin)||
   local pre6 `pre6' line RES`j' date, c(L) lc(gs12) lw(thin)||
   local postSAH6 `postSAH6' line postSAHRES`j' date, c(L) lc(red*.5) lw(thin)||
   local postReOpen6 `postReOpen6' line postReOpenRES`j' date, c(L) lc(green*.4) lw(thin)||
}

# delimit ; 
twoway `pre1' 
    || `postSAH1' 
	|| `postReOpen1' 
    || line natRR date, lw(medium) lc(black)  
    ||, xsize(2.5) ysize(2)
        xtitle("") ytitle("Mobility to Retail/Recreation", size(medium) color(black))
		yscale(titlegap(*12)) xsc(range(21960 22071))
		graphregion(color(white))
        xlabel(21960(20)22080, labsize(small) nogrid)
		ylabel(/*-60(20)40*/, labsize(small) nogrid) 	
        legend(off)
        graphregion(margin(r+5))
        note("{it:Source: Google Mobility}", size(medsmall)) 
        name(GM1, replace) 
     ;

	 # delimit cr
 	graph export "$plotdir\Fig4_GOOGLE_1.png",  replace  width(3000)	
	
	# delimit ; 
twoway `pre2' 
    || `postSAH2' 
	|| `postReOpen2' 
    || line natGP date, lw(medium) lc(black)  
    ||, xsize(2.5) ysize(2)
        xtitle("") ytitle("Mobility to Grocery/Pharmacy", size(medium) color(black))
		yscale(titlegap(*12))
		graphregion(color(white))
        xlabel(21960(20)22080, labsize(small) nogrid)
		ylabel(/*-60(20)40*/, labsize(small) nogrid) 	
        legend(off)
        graphregion(margin(r+5))
        note("{it:Source: Google Mobility}", size(medsmall)) 
        name(GM2, replace) 
     ;

	 # delimit cr
 	graph export "$plotdir\Fig4_GOOGLE_2.png",  replace  width(3000)	
	
	
		# delimit ; 
twoway `pre3' 
    || `postSAH3' 
	|| `postReOpen3' 
    || line natPB date, lw(medium) lc(black)  
    ||, xsize(2.5) ysize(2)
        xtitle("") ytitle("Mobility to Parks/Beaches", size(medium) color(black))
		yscale(titlegap(*12))
		graphregion(color(white))
        xlabel(21960(20)22080, labsize(small) nogrid)
		ylabel(/*-60(20)40*/, labsize(small) nogrid) 	
        legend(off)
        graphregion(margin(r+5))
        note("{it:Source: Google Mobility}", size(medsmall)) 
        name(GM3, replace) 
     ;

	 # delimit cr
 	graph export "$plotdir\Fig4_GOOGLE_3.png",  replace  width(3000)	

# delimit ; 
twoway `pre4' 
    || `postSAH4' 
	|| `postReOpen4' 
    || line natTRANSIT date, lw(medium) lc(black)  
    ||, xsize(2.5) ysize(2)
        xtitle("") ytitle("Mobility to Transit Stations", size(medium) color(black))
		yscale(titlegap(*12))
		graphregion(color(white))
        xlabel(21960(20)22080, labsize(small) nogrid)
		ylabel(/*-60(20)40*/, labsize(small) nogrid) 	
        legend(off)
        graphregion(margin(r+5))
        note("{it:Source: Google Mobility}", size(medsmall)) 
        name(GM4, replace) 
     ;

	 # delimit cr
 	graph export "$plotdir\Fig4_GOOGLE_4.png",  replace  width(3000)	

# delimit ; 
twoway `pre5' 
    || `postSAH5' 
	|| `postReOpen5' 
    || line natWORK date, lw(medium) lc(black)  
    ||, xsize(2.5) ysize(2)
        xtitle("") ytitle("Mobility to Workplace", size(medium) color(black))
		yscale(titlegap(*12))
		graphregion(color(white))
        xlabel(21960(20)22080, labsize(small) nogrid)
		ylabel(/*-60(20)40*/, labsize(small) nogrid) 	
        legend(off)
        graphregion(margin(r+5))
        note("{it:Source: Google Mobility}", size(medsmall)) 
		/*title("Work Related Mobility", pos(11) size(3.5) color(black))*/
        name(GM5, replace) 
     ;

	 # delimit cr
 	graph export "$plotdir\Fig4_GOOGLE_5.png",  replace  width(4000)	

	# delimit ; 
twoway `pre6' 
    || `postSAH6' 
	|| `postReOpen6' 
    || line natRES date, lw(medium) lc(black)  
    ||, xsize(2.5) ysize(2)
        xtitle("") ytitle("Stay in Residential Areas", size(medium) color(black))
		yscale(titlegap(*12))
		graphregion(color(white))
        xlabel(21960(20)22080, labsize(small) nogrid)
		ylabel(/*-60(20)40*/, labsize(small) nogrid) 	
        legend(off)
        graphregion(margin(r+5))
		note("{it:Source: Google Mobility}", size(medsmall)) 
        name(GM6, replace) 
     ;

	 # delimit cr
 	graph export "$plotdir\Fig4_GOOGLE_6.png",  replace  width(3000)	


