*********************************************************************************
****************************** MASTER FILE **************************************
*********************************************************************************
* INSTRUCTIONS:
*	- Install the Rsource package in stata, that allows to run R --> 	ssc install rsource, replace	
* 	- Change the boxuser global
*	- Locate your folder of R, and change the folder
*************************************
*************** INPUT ***************
*************************************
clear all

* Root folder globals
global root		"G:\.shortcut-targets-by-id\1DeeHcG7EI1A4gdwrBHn0IJ6BFVfzediU\BPEA2020\Data\ReplicationPackage"

* Script folder globals
global scripts	"$root\scripts"
global output	"$root\results"
 
* Other required folders in case they are needed (Put here all other globals and comment them)
global data_file_path "$root\DataDevelopment"
global miscdir 		  "$data_file_path\miscdata"     			// misc. data 
global ready		  "$data_file_path\cleandata"	 
global rawdata		  "$data_file_path\rawdata"	 

*******************************************
******** DATA ANALYSIS CODE FILES *********
*******************************************

*** Figures 1 and 2b
do "$scripts\analysis\Policy_timeline_Phase2_BPEA.do"

*** Figures 3
do "$scripts\Fig3\Fig3_AppleMobility.do"
do "$scripts\Fig3\Fig3_GoogleMob_reopening.do"
do "$scripts\Fig3\Fig3_PlaceIQ_reopening.do"
do "$scripts\Fig3\Fig3_SafeGraph_reopening.do"

*** Figure 4, Table 2 (CLOSURES: panel I - Mixing Index)
do "$scripts\analysis\closures\CreateFig5a.do" 

*** Table 2 (CLOSURES: Panel I - Median Hours at Home, Fraction Leaving Home, total out-of-state movement, total out-of-county movement)
do "$scripts\analysis\closures\CreateFig5b.do" 
do "$scripts\analysis\closures\CreateFig5c.do" 
do "$scripts\analysis\closures\CreateFig5d.do" 
do "$scripts\analysis\closures\CreateFig5e.do" 


*** Figure 5, Table 2 (CLOSURES: panel II - Mixing Index, total out-of-state movement, total out-of-county movement)
do "$scripts\analysis\reopenings\Fig5_PlaceIQ_reopening.do" 

*** Table 2 (CLOSURES: Panel II - RR, GP, TRANSIT, WORK, STAY IN RESIDENTIAL, WORK, )
do "$scripts\analysis\reopenings\Fig5_GoogleMob_reopening.do" 
do "$scripts\analysis\reopenings\Fig5_SafeGraph_reopening.do" 

*** Figure 6 and Table 3
do "$scripts\decompositions\policy_shares_SG.do" 


*** Figure 7
do "$scripts\decompositions\policy_shares_SG_reopenings.do"  /*Fig7a and Table 4, first panel*/
do "$scripts\decompositions\policy_shares_SG_reopenings_fract_leaving_home,do" /*Fig7b and Table 4, second panel*/

