function [target_dev] = ...
    target_deviations_K_share(A_zeta_E, labor_share_target, ...
    el_subs_target, R_target, tau_ell, tau_k, main_par, weight_labor, weight_R)
% computes deviation of the market equilibrium labor share given A and other
% params from labor_share_target


main_par.A = A_zeta_E(1);
main_par.zeta = A_zeta_E(2);
main_par.E = A_zeta_E(3);

params = setParams(main_par);

out = market_eq_p(tau_ell,tau_k, params);


target_dev = sqrt(sum((...
[weight_labor * (1- weight_R) * (labor_share_target - out.labor_share)./(labor_share_target);...
weight_labor * weight_R * (R_target - out.net_k_share)./(R_target);...
   (1 - weight_labor) * (el_subs_target - out.el_subs_rw)./(el_subs_target)]).^2));


end
