function [] = table2latex_t(T, options)


n_col = size(T,1);
n_row = size(T,2);

if isfield(options, 'pre_col_names')
    pre_col_names = options.pre_col_names;
else
    pre_col_names = [];
end

if isfield(options, 'notes')
    notes = options.notes;
else
    notes = [];
end

if isfield(options, 'col_relative')
    col_relative = options.col_relative;
    if length(col_relative) < n_col
        error('col_relative too short')
    end
else
    col_relative = [];
end


if isfield(options, 'dash_first')
    dash_first = options.dash_first;
    if length(dash_first) < n_row
        error('dash_first too short')
    end
else
    dash_first = zeros(1, n_row);
end


if isfield(options, 'var_relative')
    var_relative = options.var_relative;
    if length(var_relative) < n_row
        error('var_relative too short')
    end
else
    var_relative = [];
end

if isfield(options, 'var_percent')
    var_percent = options.var_percent;
    if length(var_percent) < n_row
        error('var_percent too short')
    end
else
    var_percent = [];
end

if isfield(options, 'col_spec_custom')
    col_spec_custom = options.col_spec_custom;
else
    col_spec_custom = [];
end

if isfield(options, 'filename')
    filename = options.filename;
else
    error('specify options.filename')
end

if isfield(options, 'FORMAT_DIGITS')
    FORMAT_DIGITS = options.FORMAT_DIGITS;
    if length(FORMAT_DIGITS) < n_row
        error('FORMAT_DIGITS too short')
    end
else
    FORMAT_DIGITS = ones(size(var_percent)) * 2;
end




if isfield(options, 'label_name')
    label_name = options.label_name;
else
    label_name = 'table:main results';
    warning('no label specified, default applied')
end


if isfield(options, 'tab_caption')
    tab_caption = options.tab_caption;
else
    tab_caption = '';
    warning('no caption specified')
end


if isfield(options, 'rownames') % columns of final transposed table
    rownames = options.rownames;
else
    rownames = T.Properties.RowNames;
    warning('no row name specified, using the one from T')
end


if isfield(options, 'varnames') % rows of final transposed table
    varnames = options.varnames;
else
    varnames = T.Properties.VariableNames;
    warning('no var name specified, using the one from T')
end



if isfield(options, 'resizelinewidth') % resize to text width
    resizelinewidth = options.resizelinewidth;
else
    resizelinewidth = true;
end


if isfield(options, 'post_col_names') % text to print below column names
    post_col_names = options.post_col_names;
else
    post_col_names = '';
end


if isfield(options, 'block_print') % text to print after N_block variable entries
    block_print = options.block_print;
else
    block_print = '';
end


if isfield(options, 'N_block') % N_block variable entries
    N_block = options.N_block;
else
    N_block = n_row;
end



 % Parameters: columns are now the rows

if isempty(col_spec_custom)
    col_spec = repmat('l', 1,n_col);
else   
    col_spec = repmat(col_spec_custom, 1,n_col);
end

col_names = strjoin(rownames, ' & ');
row_names = varnames;
if length(row_names)< n_row
    error('incorrect number of variable names specified')
end
if ~isempty(row_names)
    col_spec = ['l' col_spec]; 
    col_names = ['& ' col_names];
end

% Writing header
fileID = fopen(filename, 'w');

preamble = ['\\begin{table}[ht]\n'...
    '\\caption{\\label{' label_name '}' ...
    tab_caption '}'];


fprintf(fileID, [preamble '\n']);
if resizelinewidth
    fprintf(fileID, '\\resizebox{\\linewidth}{!}{\n');
end
fprintf(fileID, '\\begin{tabular}{%s}\n', col_spec);
if ~isempty(pre_col_names)
    fprintf(fileID, '%s \n', pre_col_names);
end
fprintf(fileID, '%s \\\\ \n', col_names);


if isempty(post_col_names)
    fprintf(fileID, '\\hline \n');
else
    fprintf(fileID, post_col_names);
end

% Writing the data


for row = 1:N_block
    temp{1,n_col} = [];
    digits_round = FORMAT_DIGITS(row);
    format_round = ['%.' num2str(FORMAT_DIGITS(row)) 'f'];
    val_temp = zeros(1, n_col);
    for col = 1:n_col
        value = T{col,row};
        if isstruct(value), error('Table must not contain structs.'); end
        while iscell(value), value = value{1,1}; end
        if isinf(value), value = '$\infty$'; end
         if col_relative(col) * var_relative(row) ~= 0
            value = (value/(val_temp(1, col_relative(col))) - 1) * 100;
            val_temp(1, col) = value;
            if value > 0 
                sign = '+';
            else
                sign = '';
            end
                temp{1,col} = ['$' sign num2str(round(value, digits_round), format_round)...
                    '\%$' ];
         else
            val_temp(1, col) = value;
            if var_percent(row) == 1
                temp{1,col} = ['$' num2str(round(value * 100, digits_round), format_round) '\%$'];
            else
                temp{1,col} = ['$' num2str(round(value, digits_round), format_round) '$'];
            end
        end
    end
    if var_relative(row) ~= 0
        temp{1,1} = '$.$';
    end
    if dash_first(row) == 1
        temp{1,1} = '$.$';
    end
    if ~isempty(row_names)
        temp = [row_names{row}, temp];
    end
    fprintf(fileID, '%s \\\\ \n', strjoin(temp, ' & '));
    clear temp;
end


fprintf(fileID, block_print);


for row = N_block + 1:n_row
    temp{1,n_col} = [];
    digits_round = FORMAT_DIGITS(row);
    format_round = ['%.' num2str(FORMAT_DIGITS(row)) 'f'];
    val_temp = zeros(1, n_col);
    for col = 1:n_col
        value = T{col,row};
        if isstruct(value), error('Table must not contain structs.'); end
        while iscell(value), value = value{1,1}; end
        if isinf(value), value = '$\infty$'; end
         if col_relative(col) * var_relative(row) ~= 0
            value = (value/(val_temp(1, col_relative(col))) - 1) * 100;
            val_temp(1, col) = value;
            if value > 0 
                sign = '+';
            else
                sign = '';
            end
                temp{1,col} = ['$' sign num2str(round(value, digits_round), format_round)...
                    '\%$' ];
         else
            val_temp(1, col) = value;
            if var_percent(row) == 1
                temp{1,col} = ['$' num2str(round(value * 100, digits_round), format_round) '\%$'];
            else
                temp{1,col} = ['$' num2str(round(value, digits_round), format_round) '$'];
            end
        end
    end
    if var_relative(row) ~= 0
        temp{1,1} = '$1$';
    end
    if dash_first(row) == 1
        temp{1,1} = '$.$';
    end
    if ~isempty(row_names)
        temp = [row_names{row}, temp];
    end
    fprintf(fileID, '%s \\\\ \n', strjoin(temp, ' & '));
    clear temp;
end


    
    % Closing the file
    fprintf(fileID, '\\bottomrule \n');
    fprintf(fileID, '\\end{tabular}');
    if resizelinewidth
        fprintf(fileID, '}\n');
    end
    fprintf(fileID, '\\end{table}');
    fclose(fileID);

end