function [out] = ...
    ramsey_theta_p(tau_ell,tau_k, params)
% Compute the welfare-maximizing theta if current taxes are taken as given

out.params = params;
index_guess = params.index_guess;
grid_ak = (params.A) ^ ((1 - params.lambda)/params.lambda) * ...
    params.grid_ak_ex_A;
grid_al = params.grid_al;
lambda = params.lambda;
B = params.B;
elast_ell = params.elast_ell;
D = params.D;
elast_k = params.elast_k;
varrho = params.varrho;
varrho_k = params.varrho_k;
grid_theta = params.grid_theta;
grid_phi_l = params.grid_phi_l;
grid_phi_k = params.grid_phi_k ;
guess_k = params.guess_k;
guess_l = params.guess_l;
delta = params.delta;
E = params.E;

%% Method 1: Iterate on task index


obj_theta = @(th_c) - welfare_eq(tau_ell,tau_k, varrho, th_c,...
    [guess_l guess_k]);
options.fsolve_opts =  optimset('Display','off');
%new_index = fmin_grid(obj_theta, theta_index, grid_theta,options);
theta_index = fmin_grid(obj_theta, index_guess, grid_theta,options);

[welfare, y, ell, k] = ...
    welfare_eq(tau_ell,tau_k, varrho, theta_index, [1 1]);

ak = grid_ak(theta_index);
al = grid_al(theta_index);

revenue = tau_ell * ell * al * (y / ell)^(1 / lambda) + ...
    tau_k * k * (ak * (y / k)^(1 / lambda) - delta);

labor_share = ell * al * (y / ell)^(1 / lambda) / y;

r_firms = ak * (y / k)^(1 / lambda);

w_firms = al * (y / ell)^(1 / lambda);
% 

% implicit_tax = 1 - (r_firms / w_firms) * ...
%      grid_phi_l(theta_index) / grid_phi_k(theta_index) * ...
%      (1 - params.varrho) * (1 - tau_ell) / (1 - tau_k);



% Function to compute welfare in equilibrium
    function [welfare, y, ell, k]  = ...
            welfare_eq(tau_ell,tau_k, varrho, theta_index, start)

    start_ell = start(1);
    
    start_k = start(2);
    
    options  =  optimset('Display','off');
    myfunction  =  @(x) ...
        factor_market_p(exp(x), tau_ell, tau_k, varrho, theta_index, params);
    x_sol  =  fsolve(myfunction, log([start_ell start_k]), options); 
    ell  =  exp(x_sol(1));
    k  =  exp(x_sol(2));
    y  =  output_raw_p(ell, k, theta_index, params);
    
    % Equilibrium consumption
    welfare  = ...
        y + (1 - delta) * k - ...
        (1  /  (1  +  elast_ell)) * B * ell^(1  +  elast_ell) - ...
        (1  /  (1  +  elast_k)) * E *  D * k^(1  +  elast_k) - k;

    end

    %% FUNCTION TO COMPUTE EXCESS DEMAND
    function excess_demands = ...
        factor_market_p(x,tau_ell,tau_k, varrho, theta_index, params)

    grid_akk = (params.A) ^ ((1 - params.lambda)/params.lambda) * ...
    params.grid_ak_ex_A;
    grid_all = params.grid_al;
    lambdaa = params.lambda;
    BB = params.B;
    elast_elll = params.elast_ell;
    DD = params.D;
    elast_kk = params.elast_k;
    deltaa = params.delta;
    
    elll = x(1);
    kk = x(2);
    akk = grid_akk(theta_index);
    all = grid_all(theta_index);
    yy = output_raw_p(elll, kk, theta_index, params);

    % Compute excess demands
    % - For labor
    excess_demands(1) = (1 - tau_ell) * (1 - varrho) * all * (yy/elll)^(1/lambdaa)...
        - BB * elll^(elast_elll);
    % - For Capital
    excess_demands(2) =  (1 - tau_k) * (1 - varrho_k) * (akk * (yy/kk)^(1/lambda) - delta) ...
        - DD * E * kk^(elast_kk);

    end


out.ell = ell;
out.k = k;
out.y = y;
out.theta_index = theta_index;
out.tau_k = tau_k;
out.tau_ell = tau_ell;
out.revenue = revenue;


out.labor_share = labor_share;
out.r = r_firms;
out.w = w_firms;


out.welfare = welfare;
out.implicit_tax= ...
    1 - (r_firms / w_firms) * ...
    params.grid_phi_l(theta_index) / params.grid_phi_k(theta_index);
out.theta = params.grid_theta(theta_index);
out.net_output = out.y - delta * out.k;
end