function [out] = ...
    ramsey_theta_K_comp(tau_ell,tau_k, params)
% Compute the welfare-maximizing theta if current taxes are taken as given

out.params = params;
index_guess = params.index_guess;
grid_ak = (params.A) ^ ((1 - params.lambda)/params.lambda) * ...
    params.grid_ak_ex_A;
grid_al = params.grid_al;
lambda = params.lambda;
B = params.B;
elast_ell = params.elast_ell;
D = params.D;
elast_k = params.elast_k;
varrho = params.varrho;
varrho_k = params.varrho_k;
grid_theta = params.grid_theta;
grid_phi_l = params.grid_phi_l;
grid_phi_k = params.grid_phi_k ;
guess_K = params.guess_K;
guess_l = params.guess_l;


alphaa = params.alpha;
delta = params.delta;
E = params.E;


%% Method 1: Iterate on task index


obj_theta = @(th_c) - welfare_eq(tau_ell,tau_k, varrho, th_c,...
    [guess_l guess_K]);
options.fsolve_opts =  optimset('Display','off');
%new_index = fmin_grid(obj_theta, theta_index, grid_theta,options);
theta_index = fmin_grid(obj_theta, index_guess, grid_theta,options);

[welfare, y, ell, K, k] = ...
    welfare_eq(tau_ell,tau_k, varrho, theta_index, [1 1]);

ak = grid_ak(theta_index);

r_firms = ak * (y/k)^(1/lambda);
w_firms = (y - r_firms * K) / ell;


% Optimal taxes
tau_ell = 1 - (B * ell^(elast_ell)) / ((1-varrho) * w_firms);
tau_k = 1 - (E * D * K^(elast_k)) / ((1-varrho_k) * (r_firms - delta));

revenue =  tau_ell * ell * w_firms + ...
    tau_k * K * r_firms ;

% Compute labor share, rental rate, wages
labor_share = ell * w_firms / y;

% implicit_tax = 1 - (r_firms / w_firms) * ...
%      grid_phi_l(theta_index) / grid_phi_k(theta_index) * ...
%      (1 - params.varrho) * (1 - tau_ell) / (1 - tau_k);



% Function to compute welfare in equilibrium
    function [welfare, y, ell, k, k_robots]  = ...
            welfare_eq(tau_ell,tau_k, varrho, theta_index, start)

    start_ell = start(1);
    
    start_k = start(2);
    
    options  =  optimset('Display','off');
    myfunction  =  @(x) ...
        factor_market_KC(exp(x), tau_ell, tau_k, varrho, theta_index, params);
    x_sol  =  fsolve(myfunction, log([start_ell start_k]), options); 
    
    ell  =  exp(x_sol(1));
    k  =  exp(x_sol(2));
    y  =  output_raw_K_comp(ell, k, theta_index, params);
    k_robots = allocate_K(ell, k, theta_index, params);
    
    % Equilibrium consumption
    
    welfare  = ...
        (y  - delta * k) - ...
        (1  /  (1  +  elast_ell)) * B * ell^(1  +  elast_ell) - ...
        (1  /  (1  +  elast_k)) * D * E * k^(1  +  elast_k);

    end

    %% FUNCTION TO COMPUTE EXCESS DEMAND
   function excess_demands = ...
        factor_market_KC(x,tau_ell,tau_k, varrho, theta_index, params)

    grid_akk = (params.A) ^ ((1 - params.lambda)/params.lambda) * ...
    params.grid_ak_ex_A;
    lambdaa = params.lambda;
    BB = params.B;
    elast_elll = params.elast_ell;
    DD = params.D;
    elast_kk = params.elast_k;
    
    elll = x(1);
    KK = x(2);
    akk = grid_akk(theta_index);
    yy = output_raw_K_comp(elll, KK, theta_index, params);
    kk = allocate_K(elll, KK, theta_index, params);
    
    capital_income = akk * (yy/kk)^(1/lambdaa) * KK;

    % Compute excess demands
    % - For labor
    excess_demands(1) = (1 - tau_ell) * (1 - varrho) * (yy - capital_income)...
        - BB * elll^(1 + elast_elll);
    % - For Capital
    excess_demands(2) = (1 - tau_k) * (1 - varrho_k) * (capital_income - delta * KK)...
        - DD * E * KK^(1 + elast_kk);

    end


out.K = K;
out.ell = ell;
out.k = allocate_K(ell, K, theta_index, params);
out.y = y;
out.theta_index = theta_index;
out.tau_k = tau_k;
out.tau_ell = tau_ell;
out.revenue = revenue;
% out.resids_mkt = factor_market_KC([ell K],tau_ell,tau_k, varrho, theta_index, params);

out.labor_share = labor_share;
out.r = r_firms;
out.w = w_firms;


out.welfare = welfare;
out.implicit_tax= ...
    1 - (r_firms / ( (w_firms/alphaa)^alphaa * (r_firms/(1 - alphaa))^(1 - alphaa) )) * ...
    params.grid_phi_l(theta_index) / params.grid_phi_k(theta_index);
out.theta = params.grid_theta(theta_index);
out.net_k_share =  (r_firms - delta ) * out.K / (out.y - delta * out.K) ;   
out.k_ratio = out.K/out.y; 
out.net_output = out.y - delta * out.K; 

end