function y=output_raw_p(ell,k,theta_index, params)
% Plots output as a function of theta for different aggregate quantities of
% labor and capital

grid_ak = (params.A) ^ ((1 - params.lambda)/params.lambda) * ...
    params.grid_ak_ex_A;
grid_al = params.grid_al;
lambda = params.lambda;

ak = grid_ak(theta_index);
al = grid_al(theta_index);

y= (ak * k^((lambda-1)/lambda) + ...
    al * ell^((lambda - 1)/ lambda)).^(lambda / (lambda - 1));

end