function [out] = ...
    market_eq_p(tau_ell,tau_k, params)
% Compute the market equilibrium
% Calls:
% - factor_market_p : nested below
% - output_raw_p : computing output for given theta


out.params = params;
out.tau_ell = tau_ell;
out.tau_k = tau_k;


%revenue w_f w_h r_f r_h

index_guess = params.index_guess;
indices = params.indices;
grid_ak = (params.A) ^ ((1 - params.lambda)/params.lambda) * ...
    params.grid_ak_ex_A;
grid_al = params.grid_al;
lambda = params.lambda;
B = params.B;
elast_ell = params.elast_ell;
D = params.D;
elast_k = params.elast_k;
varrho = params.varrho;
varrho_k = params.varrho_k;
maxIter = params.maxIter;
grid_theta = params.grid_theta;
delta = params.delta;
E = params.E;

%% Method 1: Iterate on task index
theta_index = index_guess;
start_ell = 1;
start_k = 1;
index_series = index_guess;
stop = 1;
iter = 0;

while iter < maxIter && stop > 0
    %Step 1: Solve system for given taxes and guess
    options = optimset('Display','off');
    myfunction = @(x)factor_market_p(exp(x), tau_ell, tau_k, varrho, theta_index, params);

    % solve for labor and capital market equilibrium, for given theta_index
    % guess
    x_sol = fsolve(myfunction,log([start_ell start_k]),options); 
    ell_sol = exp(x_sol(1));
    k_sol = exp(x_sol(2));

    %Step 2: Compute optimal theta_index (task partition) given k and ell:
    y_vector = output_raw_p(ell_sol, k_sol, indices, params); % compute all outputs varying theta
    [y, new_index] = max(y_vector); % ontain maximizing theta

    %Step 3 iterate
    iter = iter + 1;
    index_series = [index_series new_index];
    start_ell = ell_sol;
    start_k = k_sol;
    stop = abs(theta_index - new_index);
    theta_index = new_index;

end

if iter == maxIter
    warning('Maximum number of iterations reached, check index_series')
end

%Assign results
ell = ell_sol;
k = k_sol;

ak = grid_ak(theta_index);
al = grid_al(theta_index);

% Factor remunerations = marginal returns
r_firms = ak * (y/k)^(1/lambda);
% w_firms = al * (y/ell)^(1/lambda);
w_firms = (y - r_firms * k)/ell;

revenue = tau_ell * ell * w_firms + ...
    tau_k * k * (r_firms - delta);

labor_share = ell * w_firms / y;


    %% FUNCTION TO COMPUTE EXCESS DEMAND
    function excess_demands = ...
        factor_market_p(x,tau_ell,tau_k, varrho, theta_index, params)

    grid_akk = (params.A) ^ ((1 - params.lambda)/params.lambda) * ...
    params.grid_ak_ex_A;
    grid_all = params.grid_al;
    lambdaa = params.lambda;
    BB = params.B;
    elast_elll = params.elast_ell;
    DD = params.D;
    elast_kk = params.elast_k;
    deltaa = params.delta;
    
    elll = x(1);
    kk = x(2);
    akk = grid_akk(theta_index);
    all = grid_all(theta_index);
    yy = output_raw_p(elll, kk, theta_index, params);

    rr = akk * (yy/kk)^(1/lambda);
    % w_firms = al * (y/ell)^(1/lambda);
    ww = (yy - rr * kk)/elll;
    
    excess_demands(1) = (1 - tau_ell) * (1 - varrho) * ww...
    - BB * elll^(elast_elll);
    % - For Capital
    excess_demands(2) = (1 - tau_k) * (1 - varrho_k) * (rr - deltaa) ...
        - DD * E *  kk^(elast_kk);
    

    end


% Assign output
out.ell = ell;
out.k = k;
out.y = y;
out.theta_index = theta_index;
out.revenue = revenue;
out.labor_share = labor_share;
out.r = r_firms;
out.w = w_firms;
out.index_series = index_series;

out.MRTS_rw = compute_MRTS_rw(ell, k, theta_index, params);
out.MRTS_rw_prime = compute_MRTS_rw(ell, 1.01*k, theta_index, params);

out.el_subs_rw = - ...
    (( log(out.MRTS_rw_prime) - log(out.MRTS_rw) )/...
    log(1.01) ) ^ (-1);


out.theta = params.grid_theta(theta_index);
out.implicit_tax= ...
    1 - (r_firms / (w_firms )) * ...
    params.grid_phi_l(theta_index) / params.grid_phi_k(theta_index);

out.welfare = (out.y + (1- delta) * out.k) - ...
    params.B * (out.ell^ ( 1 + params.elast_ell)) / ( 1 + params.elast_ell) - ...
    params.D *( params.E * (out.k ^ ( 1 + params.elast_k)) / ( 1 + params.elast_k)) - out.k;
out.net_k_share = (r_firms - delta ) * out.k / (out.y - delta * out.k) ; 
out.k_ratio = out.k/out.y;
out.net_k_share_alt = ( 1 - labor_share - delta * out.k_ratio)/ (1 - delta * out.k_ratio);
out.net_output = out.y - delta * out.k;
% out.MRTS = compute_MRTS(ell, k, theta_index, params);
% out.MRTS_prime = compute_MRTS(ell, 1.01*k, theta_index, params);
% out.el_subs = - ...
%     (( log(out.MRTS_prime) - log(out.MRTS) )/...
%     log(1.01) ) ^ (-1);


   function [MRTS_rw] = compute_MRTS_rw(ell, k, theta_index, params)
    % computes MRTS in a neighborhood of given allocation
    % change in MRTS
    
    
    options.fsolve_opts =  optimset('Display','off');
    % solve for the optimal theta
    obj_theta = @(y) - output_raw_p(ell, k, y, params);
    theta_index_opt = fmin_grid(obj_theta, theta_index, grid_theta,options);

    r = grid_ak(theta_index_opt) * ...
        (output_raw_p(ell, k, theta_index_opt, params)/k) ^ (1/lambda)/...
        output_raw_p(ell, k, theta_index_opt, params);
    w = params.grid_al(theta_index_opt) * ...
        (output_raw_p(ell, k, theta_index_opt, params)/ell) ^ (1/lambda)/...
        output_raw_p(ell, k, theta_index_opt, params);
    
    MRTS_rw = r/w;
    
   end




% 
%%  COMPUTE MRTS with derivatives (numerical issues)
% 
%     function [MRTS] = compute_MRTS(ell, k, theta_index, params)
%     % computes MRTS in a neighborhood of given allocation
%     % change in MRTS
% 
%     % direct derivative of output in theta
%     f_prime_theta = (output_raw_p(ell, k, theta_index + 1, params) - ...
%         output_raw_p(ell, k, theta_index, params))/...
%         ( grid_theta(theta_index + 1) - grid_theta(theta_index) );
% 
%     % new_k = 1.01 * k;
%     % new_ell = 1.01 * ell;
% 
%     dk = 0.01 * k;
%     dell = 0.01 * ell;
%     options.fsolve_opts =  optimset('Display','off');
%     
%     % solve for the optimal theta once k changes by dk
%     obj_theta = @(y) - output_raw_p(ell, k + dk, y, params);
%     theta_index_dk = fmin_grid(obj_theta, index_guess, grid_theta,options);
% 
%     % solve for optimal theta when ell changes by dell
%     obj_theta = @(y) - output_raw_p(ell + dell, k, y, params);
%     theta_index_dell = fmin_grid(obj_theta, index_guess, grid_theta,options);
% 
%     theta_prime_k = (grid_theta(theta_index_dk) - grid_theta(theta_index)) / dk;
%     theta_prime_ell = ...
%         (grid_theta(theta_index_dell) - grid_theta(theta_index)) / dell;
% 
%     % direct term in chain rule for capital
%     f_prime_k = (output_raw_p(ell, k + dk, theta_index, params) - ...
%         output_raw_p(ell, k, theta_index, params)) / dk;
%     % direct term in chain rule for labor
%     f_prime_ell = (output_raw_p(ell + dell, k, theta_index, params) - ...
%         output_raw_p(ell, k, theta_index, params)) / dell;
% 
%     f_k = f_prime_k + theta_prime_k * f_prime_theta;
%     f_ell = f_prime_ell + theta_prime_ell * f_prime_theta;
%     
%     MRTS = f_k/f_ell;
%     
%     end
% 



end






