function [out_mkt] = makeTable_KSR(main_par, tableLabel, tableCaption, filename,...
    labor_share_target, el_subs_target, Kshare_target, weight_labor, weight_share)

A_zeta_guess = [main_par.A; ...
    main_par.zeta;...
    main_par.E];

% implement constraints for fzero so that argument can take values in R
fun = @(a) target_deviations_K_share(exp(a), labor_share_target,  el_subs_target, ...
    Kshare_target, main_par.tau_current_labor, main_par.tau_current_capital, main_par,...
    weight_labor, weight_share);

opts = optimset('Display', 'off');

%% SOLUTION PART
[A_zeta_sol, fval, exitflag] = fminsearch(fun, log(A_zeta_guess), opts);
% [A_zeta_sol, fval, exitflag] = fsolve(fun, log(A_zeta_guess), opts)
A_zeta_sol = exp(A_zeta_sol);

if exitflag ~= 1
    disp(['fmisearch failed with exitflag: ' num2str(exitflag)] )
    disp(['function value: ' num2str(fval)])
end

main_par.A = A_zeta_sol(1);
main_par.zeta = A_zeta_sol(2);
main_par.E = A_zeta_sol(3);

%% Step 1: Compute competitive equilibrium given a pair of taxes and a wegde
params = setParams(main_par);
out_mkt = market_eq_p(main_par.tau_current_labor,main_par.tau_current_capital, params);
g = out_mkt.revenue; % target government spending

%% Step 2: Compute solution to unconstrained Ramsey problem: no constraint on labor taxes
% Note: planner does not distort automation relative to market for given
% taxes

params.guess_k = out_mkt.k;
params.guess_l = out_mkt.ell;
params.index_guess = out_mkt.theta_index;

[out_planner] =  ramsey_unconstrained_p(g, params);
 
params.index_guess = out_planner.theta_index;

%% Step 3: Compute solution to constrained Ramsey problem

% params = setParams(A_sol);
[out_planner_con] = ramsey_constrained_p(main_par.tau_bar, g, params);

params.index_guess = out_planner_con.theta_index;

%% Step 4: PLANNER CANNOT CHANGE ANY TAX, just auto


params.guess_k = out_planner_con.k;
params.guess_l = out_planner_con.ell;
params.index_guess = out_planner_con.theta_index +10;
[out_ramsey_current_tax] = ...
    ramsey_theta_p(main_par.tau_current_labor,...
    main_par.tau_current_capital,params);

params.mu_fix = out_planner.mu;
%% Step 5: Compute optimal taxes with fixed capital tax

[out_planner_con_cap] = ...
    ramsey_constrained_capital_p(main_par.tau_current_capital, g, params);

%% CONSUMPTION-EQUIVALENT VARIATIONS
disp('Consumption-Equivalent Variations:')
disp(['Ramsey: ' num2str(computeWelfareCEq(out_planner, out_mkt))])
disp(['Theta only: ' num2str(computeWelfareCEq(out_ramsey_current_tax, out_mkt))])
disp(['Theta and tau_k only: ' num2str(computeWelfareCEq(out_planner_con, out_mkt))])

% Valuing Funds
out_planner.DwelfareCE = computeWelfareCEq(out_planner, out_mkt);
out_planner_con.DwelfareCE = computeWelfareCEq(out_planner_con, out_mkt);
out_ramsey_current_tax.DwelfareCE = computeWelfareCEq(out_ramsey_current_tax, out_mkt);
out_planner_con_cap.DwelfareCE = computeWelfareCEq(out_planner_con_cap, out_mkt);
out_mkt.DwelfareCE = 0;

% Reinstated/displaced workers
out_planner.dispL = 1 + computeDisplacedWorkers(out_planner, out_mkt);
out_planner_con.dispL = 1 +  computeDisplacedWorkers(out_planner_con, out_mkt);
out_ramsey_current_tax.dispL = 1 + computeDisplacedWorkers(out_ramsey_current_tax, out_mkt);
out_planner_con_cap.dispL = 1 + computeDisplacedWorkers(out_planner_con_cap, out_mkt);
out_mkt.dispL = 1;


disp('Displaced workers changes:')
disp(['Ramsey: ' num2str((out_planner.dispL - 1)*100)])


out_ramsey_current_tax.tau_ell = ...
    out_ramsey_current_tax.params.tau_current_labor;
out_ramsey_current_tax.tau_k =...
    out_ramsey_current_tax.params.tau_current_capital;
out_planner_con.tau_ell = out_planner_con.params.tau_bar;
out_planner_con_cap.tau_k = out_planner_con_cap.params.tau_current_capital;

%% TABLE

fields_of_interest = {...
    'tau_k'; ...
    'tau_ell'; ...
    'theta'; ...
    'implicit_tax'; ...
    'ell';  ...
    'labor_share'; ...
    'net_output';...
    'DwelfareCE';...
    'revenue'...
    };


all_fieldnames = unique(...
    [...
    fieldnames(out_mkt); ...
    fieldnames(out_planner); ...
    fieldnames(out_planner_con);  ...
    fieldnames(out_ramsey_current_tax); ...
    fieldnames(out_planner_con_cap)
    ]);


fields_to_remove = setdiff(all_fieldnames, fields_of_interest);

out_mkt_tab = out_mkt;
out_mkt_tab.mu = [];
out_planner_tab = out_planner;
out_planner_con_tab = out_planner_con;
out_ramsey_current_tax_tab = out_ramsey_current_tax;
out_planner_con_cap_tab = out_planner_con_cap;

for j = 1: length(fields_to_remove)
    if isfield(out_mkt_tab,  fields_to_remove{j})
        out_mkt_tab = rmfield(out_mkt_tab, fields_to_remove{j});
    end
    if isfield(out_planner_tab,  fields_to_remove{j})
        out_planner_tab = rmfield(out_planner_tab, fields_to_remove{j});
    end
    if isfield(out_planner_con_tab,  fields_to_remove{j})
        out_planner_con_tab = rmfield(out_planner_con_tab, fields_to_remove{j});
    end
    if isfield(out_ramsey_current_tax_tab,  fields_to_remove{j})
        out_ramsey_current_tax_tab = rmfield(out_ramsey_current_tax_tab, fields_to_remove{j});
    end
    if isfield(out_planner_con_cap_tab,  fields_to_remove{j})
        out_planner_con_cap_tab = rmfield(out_planner_con_cap_tab, fields_to_remove{j});
    end
end

out_mkt_tab = orderfields(out_mkt_tab, fields_of_interest);
out_planner_tab = orderfields(out_planner_tab, fields_of_interest);
out_planner_con_tab = orderfields(out_planner_con_tab, fields_of_interest);
out_ramsey_current_tax_tab = orderfields(out_ramsey_current_tax_tab, fields_of_interest);
out_planner_con_cap_tab = orderfields(out_planner_con_cap_tab, fields_of_interest);


if abs(out_mkt_tab.implicit_tax) < .005
    out_mkt_tab.implicit_tax = 0;
end

if abs(out_planner_tab.implicit_tax) < .005
    out_planner_tab.implicit_tax = 0;
end

if abs(out_planner_con_tab.implicit_tax) < .005
    out_planner_con_tab.implicit_tax = 0;
end


if abs(out_ramsey_current_tax_tab.implicit_tax) < .005
    out_ramsey_current_tax_tab.implicit_tax = 0;
end


if abs(out_planner_con_cap_tab.implicit_tax) < .005
    out_planner_con_cap_tab.implicit_tax = 0;
end


%round taxes for constraints
table_struc = [out_mkt_tab; ...
    out_planner_tab; ...
    out_ramsey_current_tax_tab; ...
    out_planner_con_tab; ...
    out_planner_con_cap_tab;];

T = struct2table(table_struc);
T.Properties.RowNames = {'Current System' , ...
    'Unconstrained Ramsey', ...
    'Constrained labor and capital taxes', ...
    'Constrained labor taxes', ...
    'Constrained capital taxes'};

%% TABLE OPTIONS
tab_name = 'ResultsTable.tex';
tab_options.N_block = 4;
tab_options.block_print = ['\\\\[-.2cm]\n'...
    '\\textsl{Aggregates:}\\\\ \n'];
tab_options.col_spec_custom = 'C{2.3cm}';
tab_options.label_name = tableLabel;
tab_options.tab_caption = tableCaption;
tab_options.resizelinewidth = true;
tab_options.post_col_names = ['&(1)&(2)&(3)&(4) & (5)\\\\ \\midrule \n' ...
'\\textsl{Tax system:} \\\\ \n'];

% variable in percentage change from another column (0 if no other)
tab_options.col_relative = [0 1 1 1 1];
tab_options.dash_first =   [0 0 0 0 1 0 1 1 1 ];
tab_options.var_relative = [0 0 0 0 1 0 1 0 1 ];
tab_options.var_percent =  [1 1 0 1 0 1 0 1 0 ]; 
tab_options.FORMAT_DIGITS = [2 2 3 2 2 2 2 2 2] ;

tab_options.varnames = {...
    '$\tau^k$';...
    '$\tau^\ell$'; ...
    '$\theta$'; ...
    '$\tau^A$'; ...
    'Employment';...
    'Labor Share'; ...
    'Net Output'; ...
    'C.E. welfare change'; ...
    'Revenue'; ...
    };

% rownames = T.Properties.RowNames;


tab_options.rownames = {'Current System';...
    'Ramsey Solution';...
    'Distorting $\theta$';...
    'Distorting $\theta$ and changing $\tau^k$'; ...
    'Distorting $\theta$ and changing $\tau^\ell$'};



tab_options.filename = filename;
table2latex_t(T, tab_options)
end