%% Step 0: Housekeeping %%
close all
clear
%clc
current_path = pwd;
save_path_tables = '/Tables/';
save_path_fig = '/Figures/';

%% Step 1: parametrization of basic parameters%%

main_par.N_tasks = 100000;
main_par.tau_current_labor = 0.255; % average labor tax
main_par.tau_current_capital = 0.1; % average capital wedge
main_par.tau_bar = main_par.tau_current_labor; %lower bound on labor taxation
main_par.varrho = .15;
main_par.delta = .055;

% SOLVER FOR A and zeta to match labor share and el. subs

%for alpha = .8
% A_zeta_E_guess = [  ... 
%   50.051167329573104;...
%    1.038168307220943;...
%    0.43275688798006];


A_zeta_E_guess = [  ... 
    21.067205490083349;...
   1.045335873656558;...
   0.160138751426902];

labor_share_target = .56;
k_ratio_target = 3.32;
K_share_target = .3;
el_subs_target = 1.35;
weight_labor = .85; % weigh deviation from labor and k share
weight_share = .3; % weigh deviation from k - share over total shares weight

fun = @(a) target_deviations_K_comp(exp(a), labor_share_target,  el_subs_target, ...
    K_share_target, main_par.tau_current_labor, main_par.tau_current_capital, main_par,...
    weight_labor, weight_share);


opts = optimset('Display', 'Iter');

params = setParams(main_par);
out = market_eq_K_comp(main_par.tau_current_labor, main_par.tau_current_capital, params);

% SOLUTION PART
[A_zeta_sol, fval, exitflag] = fminsearch(fun, log(A_zeta_E_guess), opts);
% [A_zeta_sol, fval, exitflag] = fsolve(fun, log(A_zeta_guess), opts)
A_zeta_sol = exp(A_zeta_sol)

if exitflag ~= 1
    disp('fmisearch failed')
end

main_par.A = A_zeta_sol(1);
main_par.zeta = A_zeta_sol(2);
main_par.E = A_zeta_sol(3);

params = setParams(main_par);

out = market_eq_K_comp(main_par.tau_current_labor, main_par.tau_current_capital, params)


disp('Baseline shares:')
disp(['Labor share: ' num2str(out.labor_share)])
disp(['Net capital share: ' num2str(out.net_k_share)])
disp(['Capital/output ratio: ' num2str(out.k_ratio)])
disp(['El. subs.: ' num2str(out.el_subs_rw)])


%% MAKE TABLE 1: Different solutions at current tax system


filename = [current_path save_path_tables 'Tab_ResultsTable_KComp.tex'];
out_mkt = makeTable_K_comp(main_par, 'table:main results', ...
    'Equilibrium under the current tax system and under other potential scenarios, complementary capital.', ...
    filename, labor_share_target, el_subs_target, K_share_target, weight_labor, weight_share);

