function [out_mkt_2010s] = mainTableReforms_KSR(main_par, tableLabel, tableCaption, filename, ...
    labor_share_target, el_subs_target, Kshare_target, weight_labor, weight_share)
%% Step 1: parametrization of basic parameters%%

tau_capital_2000 = .2;
tau_capital_2020 = .05;
% SOLVER FOR A and zeta to match labor share and el. subs

A_zeta_guess = [main_par.A; ...
    main_par.zeta;...
    main_par.E];

% implement constraints for fzero so that argument can take values in R
fun = @(a) target_deviations_K_share(exp(a), labor_share_target,  el_subs_target, ...
    Kshare_target, main_par.tau_current_labor, main_par.tau_current_capital, main_par,...
    weight_labor, weight_share);

opts = optimset('Display', 'off');

%% SOLUTION PART
[A_zeta_sol, fval, exitflag] = fminsearch(fun, log(A_zeta_guess), opts);
% [A_zeta_sol, fval, exitflag] = fsolve(fun, log(A_zeta_guess), opts)
A_zeta_sol = exp(A_zeta_sol);

if exitflag ~= 1
    disp(['fmisearch failed with exitflag: ' num2str(exitflag)] )
    disp(['function value: ' num2str(fval)])
end

main_par.A = A_zeta_sol(1);
main_par.zeta = A_zeta_sol(2);
main_par.E = A_zeta_sol(3);


%% Column 1: Compute competitive equilibrium in 2010s
params = setParams(main_par);
out_mkt_2010s = market_eq_p(main_par.tau_current_labor,...
    main_par.tau_current_capital, params);
g = out_mkt_2010s.revenue; % target government spending


%% Column 2: Go back to 2000 equilibrium
out_mkt_2000 = market_eq_p(main_par.tau_current_labor,...
   tau_capital_2000, params);
g_2000 = out_mkt_2000.revenue; % new target government spending


%% Column 3: TRUMP TAX REFORM

out_mkt_2020 = market_eq_p(main_par.tau_current_labor,...
   tau_capital_2020, params);


%% Column 4: compute revenue-neutral changing only tau^ell

params.start_ell = out_mkt_2000.ell;
params.start_k = out_mkt_2000.k;

[out_planner_2010s_tau_ell] = ...
    ramsey_constrained_nodistort_tau_ell(tau_capital_2000, g, params);


%% Column 5: compute revenue-neutral changing tau^k and theta 
% Subject to: tau^k + tau^A = tau_capital_2000
options = struct();
handleRevenue = @(tau_A) g - compute_rev_tauA(main_par.tau_current_labor,...
    tau_capital_2000, tau_A, params, options);

optsFzero = optimset('Display', 'iter');
tauA_sol = fzero(handleRevenue, [1e-6 tau_capital_2000 - 1e-6], optsFzero);
[out_planner_2010s_tau_k_10] =   market_eq_p_tauA(main_par.tau_current_labor, ...
    tau_capital_2000, tauA_sol, params, options);


%% Column 6: Ramsey solution for 2010s Revenue, obtain the value of public funds

params.guess_l = out_planner_2010s_tau_ell.ell;
params.guess_k = out_planner_2010s_tau_ell.k;

[out_planner_2010s] =  ramsey_unconstrained_p(g, params);
[out_planner_2000] =  ramsey_unconstrained_p(out_mkt_2000.revenue, params);
[out_planner_2020] =  ramsey_unconstrained_p(out_mkt_2020.revenue, params);


% Set the value of public funds to the value in the planner's solution
params.mu_fix = out_planner_2010s.mu;


 %% PREPARE TABLE
 
% compute consumption-equivalent change in welfare 
out_mkt_2010s.DwelfareCE = computeWelfareCEq(out_mkt_2010s, out_mkt_2000, params.mu_fix);
out_mkt_2020.DwelfareCE = computeWelfareCEq(out_mkt_2020, out_mkt_2000, params.mu_fix);
out_planner_2010s_tau_ell.DwelfareCE = computeWelfareCEq(out_planner_2010s_tau_ell, out_mkt_2000, params.mu_fix);
out_planner_2010s_tau_k_10.DwelfareCE = computeWelfareCEq(out_planner_2010s_tau_k_10, out_mkt_2000, params.mu_fix);
out_planner_2010s.DwelfareCE = computeWelfareCEq(out_planner_2010s, out_mkt_2000, params.mu_fix);
out_mkt_2000.DwelfareCE = computeWelfareCEq(out_mkt_2000, out_mkt_2000, params.mu_fix);


% Reinstated/displaced workers
out_mkt_2010s.dispL = 1 + computeDisplacedWorkers(out_mkt_2010s, out_mkt_2000);
out_mkt_2020.dispL = 1 +  computeDisplacedWorkers(out_mkt_2020, out_mkt_2000);
out_planner_2010s_tau_ell.dispL = 1 + computeDisplacedWorkers(out_planner_2010s_tau_ell, out_mkt_2000);
out_planner_2010s_tau_k_10.dispL = 1 + computeDisplacedWorkers(out_planner_2010s_tau_k_10, out_mkt_2000);
out_planner_2010s.dispL = 1 + computeDisplacedWorkers(out_planner_2010s, out_mkt_2000);
out_mkt_2000.dispL = 1 + computeDisplacedWorkers(out_mkt_2000, out_mkt_2000);



% compute the cost per job generate
US_emp = 160 * 10e6;
US_rev = 2.5 * 10e12;
delta_rev = (out_mkt_2010s.revenue/out_mkt_2000.revenue - 1) * US_rev;
out_mkt_2010s.costPerJob = 1/((out_mkt_2010s.ell/out_mkt_2000.ell - 1) * US_emp ...
    /(- delta_rev)) ;



delta_rev = (out_planner_2010s_tau_ell.revenue/out_mkt_2000.revenue - 1) * US_rev;
out_planner_2010s_tau_ell.costPerJob = 1/((out_planner_2010s_tau_ell.ell/out_mkt_2000.ell - 1) * US_emp ...
    /(- delta_rev)) ;

delta_rev = (out_planner_2010s.revenue/out_mkt_2000.revenue - 1) * US_rev;
out_planner_2010s.costPerJob = 1/((out_planner_2010s.ell/out_mkt_2000.ell - 1) * US_emp ...
    /(- delta_rev)) ;
out_mkt_2000.costPerJob = 0;
delta_rev = (out_planner_2010s_tau_k_10.revenue/out_mkt_2000.revenue - 1) * US_rev;
out_planner_2010s_tau_k_10.costPerJob = 1/((out_planner_2010s_tau_k_10.ell/out_mkt_2000.ell - 1) * US_emp ...
    /(- delta_rev)) ;
out_mkt_2000.costPerJob = 0;
% For 2020
delta_rev_2020 = (out_mkt_2020.revenue/out_mkt_2000.revenue - 1) * US_rev;
out_mkt_2020.costPerJob = 1/((out_mkt_2020.ell/out_mkt_2000.ell - 1) * US_emp ...
    /(- delta_rev_2020)) ;

 %% PRINT REFORM TABLE
 
 fields_of_interest = {...
    'tau_k'; ...
    'tau_ell'; ...
    'theta'; ...
    'implicit_tax'; ...
    'ell';  ...
    'k'; ...
    'labor_share'; ...
    'net_output';...
    'costPerJob';...
    'revenue'...
    };


all_fieldnames = unique(...
    [...
    fieldnames(out_mkt_2000); ...
    fieldnames(out_mkt_2010s); ...
    fieldnames(out_planner_2010s_tau_ell); ...
    fieldnames(out_planner_2010s_tau_k_10);...
    fieldnames(out_mkt_2020); ...
    fieldnames(out_planner_2010s)...
    ]);


fields_to_remove = setdiff(all_fieldnames, fields_of_interest);

out_mkt_2000_tab = out_mkt_2000;
out_mkt_2010s_tab = out_mkt_2010s;
out_planner_2010s_tau_ell_tab = out_planner_2010s_tau_ell;
out_planner_2010s_tau_k_10_tab = out_planner_2010s_tau_k_10;
out_mkt_2020_tab  = out_mkt_2020;
out_planner_2010s_tab = out_planner_2010s;
for j = 1: length(fields_to_remove)
    if isfield(out_mkt_2000_tab,  fields_to_remove{j})
        out_mkt_2000_tab = rmfield(out_mkt_2000_tab, fields_to_remove{j});
    end
    if isfield(out_mkt_2010s_tab,  fields_to_remove{j})
        out_mkt_2010s_tab = rmfield(out_mkt_2010s_tab, fields_to_remove{j});
    end
    if isfield(out_planner_2010s_tau_ell_tab,  fields_to_remove{j})
        out_planner_2010s_tau_ell_tab = rmfield(out_planner_2010s_tau_ell_tab, fields_to_remove{j});
    end
    if isfield(out_planner_2010s_tau_k_10_tab,  fields_to_remove{j})
        out_planner_2010s_tau_k_10_tab = rmfield(out_planner_2010s_tau_k_10_tab, fields_to_remove{j});
    end
    if isfield(out_mkt_2020_tab,  fields_to_remove{j})
        out_mkt_2020_tab = rmfield(out_mkt_2020_tab, fields_to_remove{j});
    end
    if isfield(out_planner_2010s_tab,  fields_to_remove{j})
        out_planner_2010s_tab = rmfield(out_planner_2010s_tab, fields_to_remove{j});
    end
end

out_mkt_2000_tab = orderfields(out_mkt_2000_tab, fields_of_interest);
out_mkt_2010s_tab = orderfields(out_mkt_2010s_tab, fields_of_interest);
out_planner_2010s_tau_ell_tab = orderfields(out_planner_2010s_tau_ell_tab, fields_of_interest);
out_planner_2010s_tau_k_10_tab = orderfields(out_planner_2010s_tau_k_10_tab, fields_of_interest);
out_mkt_2020_tab = orderfields(out_mkt_2020_tab, fields_of_interest);
out_planner_2010s_tab = orderfields(out_planner_2010s_tab, fields_of_interest);

if abs(out_mkt_2000_tab.implicit_tax) < .005
    out_mkt_2000_tab.implicit_tax = 0;
end

if abs(out_mkt_2010s_tab.implicit_tax) < .005
    out_mkt_2010s_tab.implicit_tax = 0;
end

if abs(out_planner_2010s_tau_ell_tab.implicit_tax) < .005
    out_planner_2010s_tau_ell_tab.implicit_tax = 0;
end

if abs(out_mkt_2020_tab.implicit_tax) < .005
    out_mkt_2020_tab.implicit_tax = 0;
end

if abs(out_mkt_2020_tab.implicit_tax) < .005
    out_mkt_2020_tab.implicit_tax = 0;
end


if abs(out_planner_2010s_tab.implicit_tax) < .005
    out_planner_2010s_tab.implicit_tax = 0;
end



if abs(out_mkt_2000_tab.costPerJob) < 1000
    out_mkt_2000_tab.costPerJob = 0;
end

if abs(out_mkt_2010s_tab.costPerJob) < 1000
    out_mkt_2010s_tab.costPerJob = 0;
end

if abs(out_planner_2010s_tau_ell_tab.costPerJob) < 1000
    out_planner_2010s_tau_ell_tab.costPerJob = 0;
end

if abs(out_mkt_2020_tab.costPerJob) < 1000
    out_mkt_2020_tab.costPerJob = 0;
end

if abs(out_mkt_2020_tab.costPerJob) < 1000
    out_mkt_2020_tab.costPerJob = 0;
end


if abs(out_planner_2010s_tab.costPerJob) <  100
    out_planner_2010s_tab.costPerJob = 0;
end





if abs(out_planner_2010s_tab.revenue - out_mkt_2010s_tab.revenue) < .005
    out_planner_2010s_tab.revenue = out_mkt_2010s_tab.revenue;
end

if abs(out_planner_2010s_tau_ell_tab.revenue - out_mkt_2010s_tab.revenue) < .005
    out_planner_2010s_tau_ell_tab.revenue = out_mkt_2010s_tab.revenue;
end

if abs(out_planner_2010s_tau_k_10_tab.revenue - out_mkt_2010s_tab.revenue) < .005
    out_planner_2010s_tau_k_10_tab.revenue = out_mkt_2010s_tab.revenue;
end

table_struc = [...
    out_mkt_2000_tab; ...
    out_mkt_2010s_tab; ...
    out_mkt_2020_tab; ...
    out_planner_2010s_tau_ell_tab; ...
    out_planner_2010s_tau_k_10_tab; ...
    out_planner_2010s_tab];

T = struct2table(table_struc);
T.Properties.RowNames = {'System 2010s' , ...
    'System 2000', ...
    'System 2020s',...
    'Reform labor tax', ...
    'Reform capital tax',...
    'Reform both'};

% tab_preamble = '\\documentclass[../sections/appendix.tex]{subfiles}';
tab_preamble ='';
tab_SIG_DIGITS =  2;
varnames = {...
    '$\tau^k$';...
    '$\tau^\ell$'; ...
    '$\theta$'; ...
    '$\tau^A$'; ...
    'Employment';...
    'Capital';...
    'Labor Share'; ...
    'Net Output'; ...
    'Cost/Revenue per job (\$)'
    'Revenue'; ...
    };

% rownames = T.Properties.RowNames;


rownames = {...
    ['System in 2000 with $\tau^k = ' num2str(tau_capital_2000*100) '\%$'];...
    ['System in 2010s with $\tau^k = ' num2str(main_par.tau_current_capital*100) '\%$'];...
    ['System in 2020 with reform to $\tau^k = ' num2str((tau_capital_2020*100)) '\%$']; ...
    ['Revenue-neutral labor tax reform with $\tau^k = ' num2str(tau_capital_2000*100) '\%$'];...
    'Revenue-neutral capital tax reform with automation taxation'; ...
    'Revenue-neutral capital and labor tax reform'};


%% TABLE OPTIONS
tab_options.N_block = 4;
tab_options.block_print = ['\\\\[-.2cm]\n'...
    '\\textsl{Aggregates:}\\\\ \n'];
tab_options.FORMAT_DIGITS = tab_SIG_DIGITS;
tab_options.col_spec_custom = 'C{2.3cm}';
tab_options.label_name = tableLabel;
tab_options.tab_caption = tableCaption;
tab_options.resizelinewidth = true;
tab_options.pre_col_names = ['\toprule ' ...
			'& &\multicolumn{2}{c}{Observed reforms} & \multicolumn{3}{c}{Alternative reforms} \\'...
            '\cmidrule(r){3-4} \cmidrule(r){5-7}'];
tab_options.post_col_names = ['&(1)&(2)&(3)&(4)&(5)&(6)\\\\ \\midrule \n' ...
'\\textsl{Tax system:} \\\\ \n'];

% variable in percentage change from another column (0 if no other)
tab_options.col_relative = [0 1 1 1 1 1];
tab_options.var_relative = [0 0 0 0 1 1 0 1 0 1];
tab_options.var_percent =  [1 1 0 1 0 0 1 0 0 0]; 
tab_options.dash_first =   [0 0 0 0 1 1 0 1 1 1]; 
tab_options.FORMAT_DIGITS = ones(size(tab_options.dash_first)) * 2;
tab_options.FORMAT_DIGITS(3) = 3;

tab_options.varnames = varnames;

% rownames = T.Properties.RowNames;


tab_options.rownames = rownames;


tab_options.filename = filename;
table2latex_t(T, tab_options)
 
end
