function [c_var] = computeWelfareCEq(newAllocation, oldAllocation,...
    value_funds)
% Computes the percent change in consumption starting from oldAllocation
% such that welfare increases to the level in newAllocation

% c_var solves: (1+c_var) * oldAllocation.output - nu(oldAllocation.ell)
% - phi(oldAllocation.k) = newAllocation.output - nu(newAllocation.ell)
% - phi(newAllocation.k)

% c_var = (...
%     newAllocation.welfare - oldAllocation.welfare)/...
%     oldAllocation.output;

if nargin <3
    value_funds_indicator = false;
else
    mu = value_funds;
    value_funds_indicator = true;
    
end

if ~value_funds_indicator
    c_var = (newAllocation.welfare - oldAllocation.welfare) ./...
        (oldAllocation.y + (oldAllocation.params.delta) * oldAllocation.k - ...
        oldAllocation.revenue) ;
else %use welfare with valuation of funds
    c_var = (newAllocation.welfare  - oldAllocation.welfare + ...
        mu * (newAllocation.revenue - oldAllocation.revenue) )./...
        (oldAllocation.y + (- oldAllocation.params.delta) * oldAllocation.k - ...
        oldAllocation.revenue) ;
end 

end