

#SETUP: LIBRARIES---------
# Required Packages: run install.packages('packageName') if not installed on machine.
library(readr)
library(dplyr)
#library(reshape2)
library(tibble)
library(data.table)
library(ggplot2)
library(zoo)
library(TTR)
library(ggpubr)
library(xtable)
library(scales)
library(forecast)

# SETUP: DIRECTORIES ##########
# Change this to run in another directory with same folder structure
baseDir = "/Users/andreamanera/Dropbox (MIT)/Research/Brookings20/replicationKit"

binDir = paste0(baseDir,"/R/bin")
# data sources
rawDir = paste0(baseDir,"/R/raw")
# source for Tax BEA data
taxDir = paste0(rawDir,"/TaxSeries") 
# out other
outDir = paste0(baseDir,"/R/out")
# out figures
figureDir = paste0(outDir,"/Figures")
# McDaniel dir: where dataset McDanielMine is
McDanielDir = paste0(baseDir,"/McDanielComp/out")
# Investment dir
invDir = paste0(rawDir,"/InvPrices") 
# Capital taxes dir
capTaxDir = paste0(taxDir,"/CapitalTaxes") 
# out data dir
dataDir = paste0(outDir,"/Data")

# SETUP : ggplot theme -------
mytheme<-theme_bw() + theme(plot.title = element_text(hjust = 0.5, 
                                         size=18),
               legend.position = "bottom", 
               legend.text = element_text(size=18),
               axis.text.x = element_text(size=18, angle = 0),
               axis.text.y = element_text(size=18),
               axis.title.x = element_text(size=18),
               axis.title.y = element_text(size=18), 
               legend.key = element_rect(size = 5),
               legend.key.size = unit(1.5, 'lines'))
