#SETUP-----------------------
# Run the setup lines in Master if running as stand-alone
# garbage collection
gc()
# remove all variables except those defining directory and graph theme
rm(list = setdiff(ls(), c(ls()[grep("Dir", ls())], "mytheme")))

baseDir = "/Users/andreamanera/Dropbox (MIT)/Research/Brookings20/replicationKit"

binDir = paste0(baseDir,"/R/bin")

source(paste0(binDir, "/setupLines.R"))

# PARAMETER: SHARE OF HEALTH AND PENSION BENEFITS VALUED BY WORKERS-------
shareInsValued = .65
shareInsTax = 1 - shareInsValued

#IMPORT AND MERGE DATASETS----------
tableGDP = setDT(read_csv(paste0(taxDir,"/Table_1_1_5_GDP.csv")))
tableGDI = setDT(read_csv(paste0(taxDir,"/Table_1_10_GDI.csv")))
tableVADD = setDT(read_csv(paste0(taxDir,"/Table_1_14_Value_Add.csv")))
tableGCURR = setDT(read_csv(paste0(taxDir,"/Table_3_1_Govt_Current_BEA.csv"))) 
tableFEDCURR = setDT(read_csv(paste0(taxDir,"/Table_3_2_FED_Current_BEA.csv"))) 
# Data on statutory social security rates on employees
tableSSRate = setDT(read_csv(paste0(taxDir,"/TPC_SS_rates.csv"))) 
tableSSRate = tableSSRate[, c("Year", "SS_TAX"), with = F]
colnames(tableSSRate) <- c("Year", "T_SS")
tableYears = setDT(data.frame(Year = seq(1980,2018,1)))
tableSSRate = tableSSRate[tableYears, on =.(Year = Year)]
tableSSRate[Year>2015, c("T_SS")] = tableSSRate[Year==2015, c("T_SS")]

# IRS data on income by type of corporation
tableIRS = setDT(read_csv(paste0(taxDir,"/IRS_IBD.csv"))) 
# Data on wages by legal form of organization
tableW_LFO = setDT(read_csv(paste0(taxDir,"/Table_1_13_LFO.csv"))) 
tableW = setDT(read_csv(paste0(taxDir,"/Table_6_2_BCD_compensation.csv"))) 
tableInsurance = setDT(read_csv(paste0(taxDir,"/Table_6_11_BCD_Insurance.csv"))) 
tableStocks = setDT(read_csv(paste0(invDir,"/Table_2_1_current_cost_stock.csv"))) 
tableIRSATR = setDT(read_csv(paste0(taxDir,"/IRS_ATR_86_17.csv"))) 
tableYears = setDT(data.frame(Year = seq(1980,2018,1)))
# Compensation of employees in corporations
tableWCORP = tableW_LFO[Line == 4, ]
tableWCORP$Item = "W_CORP"
tableIRS = tableIRS[Line == 12 | Line == 13 | Line ==19 | Line ==20, ]
tableIRS$Item = c("NI_D_CORP","NI_CORP", "NI_C_D_CORP", "NI_C_CORP")
tableW =  tableW[Line == 2, ]
tableW$Item = "W_DOMESTIC" # INCLUDES GOVERNMENT
tableInsurance =  tableInsurance[Line == 2, ]
tableInsurance$Item = "INS_DOMESTIC" # INCLUDES GOVERNMENT
# Select interesting variables and rename
tableGDP = tableGDP[Line == 1 | Line == 2 | Line == 8, ]
tableGDP$Item = c("GDP", "C", "I")
tableGDI = tableGDI[Line == 2 | Line == 10 | Line == 20 | Line == 22 | Line == 23 , ]
tableGDI$Item = c("W", "NOSPCU", "NOSGOV", "CFCPCU", "CFCGOV")
tableVADD = tableVADD[Line == 2 | Line == 8, ]
tableVADD$Item = c("CFCCORP", "NOSCORP")
tableGCURR = tableGCURR[(Line >= 3 & Line <= 5 )| Line == 8 | Line == 30 ,]
tableGCURR$Item = c("HHT", "TPI", "CT", "SS", "Sub")
tableFEDCURR = tableFEDCURR[ Line == 8,]
tableFEDCURR$Item = c("CT_FED")
tableStocks = tableStocks[Line == 1| Line == 67| Line == 76| Line == 78, ]
tableStocks$Item = c("PFA", "Res_Struc", "IPP", "Software")
tableBEA = rbind(tableGDP, tableGDI, tableVADD,
                 tableGCURR, tableWCORP, tableIRS, tableW, tableInsurance, tableStocks, tableFEDCURR,
                 fill=T)
tableBEA = tableBEA[,Line:= NULL]
tableBEA = tableBEA[,Type:= NULL]
# reshape to long
tableBEA = melt(tableBEA, 
                id.vars = c("Item"),
                measure.vars = colnames(tableBEA)[colnames(tableBEA) !="Item"],
                variable.name = "Year",
                value.name = "Value")
tableBEA$Value = as.numeric(tableBEA$Value)
tableBEA$Year = as.numeric(as.character(tableBEA$Year))
tableBEA = setDT(dcast(tableBEA, Year~ Item, value.var="Value"))
# Convert into $bn
tableBEA$NI_CORP = tableBEA$NI_CORP/1000000
tableBEA$NI_C_CORP = tableBEA$NI_C_CORP/1000000
tableBEA$W_DOMESTIC = tableBEA$W_DOMESTIC/1000
tableBEA$INS_DOMESTIC = tableBEA$INS_DOMESTIC/1000
#clean up
rm(tableGCURR, tableGDI, tableGDP, tableVADD, tableW_LFO, tableWCORP,
   tableW, tableInsurance)

# Import McDaniel series on old vintage of data
tableMcDaniel<- setDT(read_csv(paste0(McDanielDir,"/McDanielMine.csv")))
# Get Business Share of TPI
mu = tableMcDaniel[1,]$mean_mu
# Get Share of net TPI that fall on consumption only
lambda = tableMcDaniel[1,]$mean_lambda
rm(tableMcDaniel)

#COMPUTE AVERAGE TAXES ON HH INCOME USING MCDANIEL FORMULAS ON BEA DATA--------

tableBEA = tableBEA[, CONS_SHARE:= C/(C+I)]
tableBEA = tableBEA[, T_INC:=  HHT/(GDP - (TPI - Sub))]

# GET GROSS OPERATING SURPLUSES: Net + Consumption of fixed capital--------
tableBEA = tableBEA[, OSPCU:= NOSPCU + CFCPCU]
tableBEA = tableBEA[, OSCORP:= NOSCORP + CFCCORP]
tableBEA = tableBEA[, OSGOV:= NOSGOV + CFCGOV]

# OSPUE
tableBEA = tableBEA[, OSPUE:= OSPCU - OSCORP]

# GET AVERAGE LABOR TAX FROM IRS AND ETRAPOLATE MISSING DATES--------
tableIRSATR = tableIRSATR[tableYears, on =.(Year = Year)]
tableIRSATR[ Year < 1986 & is.na(T_avg), c("T_avg")] = unique(tableIRSATR[ Year == 1986, c("T_avg")])
tableIRSATR[ Year > 2017 & is.na(T_avg), c("T_avg")] = unique(tableIRSATR[ Year == 2017, c("T_avg")])
tableIRSATR[ Year < 1986 & is.na(T_95), c("T_95")] = unique(tableIRSATR[ Year == 1986, c("T_95")])
tableIRSATR[ Year > 2017 & is.na(T_95), c("T_95")] = unique(tableIRSATR[ Year == 2017, c("T_95")])
tableIRSATR[ Year < 1986 & is.na(T_99), c("T_99")] = unique(tableIRSATR[ Year == 1986, c("T_99")])
tableIRSATR[ Year > 2017 & is.na(T_99), c("T_99")] = unique(tableIRSATR[ Year == 2017, c("T_99")])



tableBEA = tableBEA[tableIRSATR, on =.(Year = Year)]



# GET IRS NET SURPLUSES--------------
# Now compute capital taxes on tax base, accounting for the fact that the basis is net of depreciation allowance

#Import and Merge allowances
tableAllow = setDT(
  merge(read_csv(paste0(taxDir,"/CCAll_Corp.csv")),
        read_csv(paste0(taxDir,"/CCAll_NonCorp.csv"))))

tableBEA = tableBEA[tableAllow, on=.(Year = DATE)]
tableBEA = tableBEA[tableSSRate, on=.(Year = Year)]
# Computations

tableBEA = tableBEA[, NOSPUE_IRS:= OSPUE - NonCorporateAllowance  ]
tableBEA = tableBEA[, NOSCORP_IRS:= OSCORP - CorporateAllowance  ]

# Average tax on wages
tableBEA = tableBEA[, T_H:= T_95]
# Average income tax (for proprietors)
tableBEA = tableBEA[, T_INC:= T_avg]
# Average tax on labor income (Conference Draft Method)
tableBEA = tableBEA[, T_H_BE:= ((T_H + T_SS) * (W_DOMESTIC - INS_DOMESTIC) +
                      (1 - shareInsValued) * INS_DOMESTIC) /W_DOMESTIC ]


# Average behavioral tax on labor income 
# compute the share of compensation that is employers' contribution to pension and health
tableBEA = tableBEA[, SHARE_W_INS:= INS_DOMESTIC/W_DOMESTIC]

#COMPUTE TAX-BASE TAX RATES following our method-----------

# Corporate tax, using the old method (incorrect as OSCORP contains)
tableBEA = tableBEA[, T_K_corp:= CT/OSCORP]
tableBEA = tableBEA[, T_K_corp_net:= CT/NOSCORP_IRS]
# Attribute oscorp to C corporation: same share as net income reported by IRS
# Step 1: create the share of income of S-corp, assume it is constant at 2013 value
tableBEA = tableBEA[, SHARE_INC_C_CORP:= NI_C_CORP/NI_CORP ]  
tableBEA[Year>2013, "SHARE_INC_C_CORP" ] = tableBEA[Year==2013, "SHARE_INC_C_CORP" ]
# interpolate missing 1990 value
tableBEA[Year==1990, "SHARE_INC_C_CORP" ] = (tableBEA[Year==1989, "SHARE_INC_C_CORP" ] +
tableBEA[Year==1991, "SHARE_INC_C_CORP" ])/2 
tableBEA = tableBEA[, T_K_corp_S_corp:= CT/NOSCORP_IRS + T_INC*(1 - SHARE_INC_C_CORP) ]

tableBEA = tableBEA[, SHARE_INC_C_D_CORP:= NI_C_D_CORP/NI_D_CORP ]
tableBEA[Year>2013, "SHARE_INC_C_D_CORP" ] = tableBEA[Year==2013, "SHARE_INC_C_D_CORP" ]
# interpolate missing 1990 value
tableBEA[Year==1990, "SHARE_INC_C_D_CORP" ] = (tableBEA[Year==1989, "SHARE_INC_C_D_CORP" ] +
                                               tableBEA[Year==1991, "SHARE_INC_C_D_CORP" ])/2 


# NEW MEASURES FOR CORPORATE TAXES ----------
tableBEA = tableBEA[, T_K_corp_net_C_corp:= CT/(SHARE_INC_C_CORP * NOSCORP_IRS)]
tableBEA = tableBEA[, T_K_corp_netFED_C_corp:= CT_FED/(SHARE_INC_C_CORP * NOSCORP_IRS)]
tableBEA = tableBEA[, T_K_corp_state_net:= (CT - CT_FED)/(NOSCORP_IRS)]
tableBEA = tableBEA[, T_K_corp_net_d_C_corp:= CT/(SHARE_INC_C_D_CORP * NOSCORP_IRS)]

tableBEA = tableBEA[, T_K_corp_FEDState_C_corp:= T_K_corp_netFED_C_corp + T_K_corp_state_net]
tableBEA = tableBEA[, T_K_corp_State_S_corp:= T_K_corp_state_net]



tableTaxes = tableBEA[, .SD, .SDcols = c("Year", grep("^T_", colnames(tableBEA), value = TRUE))]
tableTaxes = tableTaxes[, T_K := NULL]
tableTaxes = tableTaxes[, T_K_ALT := NULL]


save(tableTaxes, tableBEA, file = paste0(outDir,"/TaxSeries.RData"))


# EXPORT HOUSEHOLD TAXES ON LABOR----------------
tableLaborTaxes = tableBEA[, c("Year", "T_INC", "T_H", "T_H_BE"), with = F]

write.csv(tableLaborTaxes, file = paste0(dataDir, "/laborTaxes.csv"), row.names = F)
# GRAPHS CAPITAL TAX SERIES--------

# OTHER GRAPHS ----------------



ggplot(tableBEA)+
  geom_line(aes(x=Year,y=SHARE_INC_C_CORP,
                colour="Share C-corp"))+
  mytheme

  
  ggplot(tableBEA)+
    geom_line(aes(x=Year,y=T_K_corp_state_net,
                  colour="state tax rate"))+
  mytheme
  
  
  ggplot(tableBEA)+
    geom_line(aes(x=Year,y=T_K_corp_netFED_C_corp,
                  colour="FED tax rate on C-corps"))+
  mytheme

ggplot(tableBEA)+
  geom_line(aes(x=Year,y=T_K_corp_netFED_C_corp,
                colour="FED taxes"))+
  geom_line(aes(x=Year,y=T_K_corp_FEDState_C_corp,
                colour="FED and State taxes"))+
  geom_line(aes(x=Year,y=T_K_corp_net,
                colour="OLD"))+
  mytheme


ggplot(tableBEA)+
  geom_line(aes(x=Year,y=NI_C_CORP,
                colour="Share of C-corps"))+
  mytheme



ggplot(tableBEA)+
  geom_line(aes(x=Year,y=T_H,
                colour="Tax for 95%"))+
  geom_line(aes(x=Year,y=T_H_BE,
                colour="Total Labor tax"))+
  geom_line(aes(x=Year,y=T_INC,
                colour="Average Income proprietors"))+
  mytheme