
compute.avgWedges.capitalizeTax <- function(dataTable, SeriesTAU_H_C = "TAU_H_C", 
                              SeriesTAU_CH_S = "TAU_CH_S", SeriesT_c = "T_c",
                              SeriesT_NC = "T_INC", SeriesRatesToUse = "RatesToUse",
                              SeriesTAU_H_C_B = "TAU_H_C_B", SeriesTAU_CH_S_B = "TAU_CH_S_B",
                              SeriesRatesToUseB = "RatesToUse_B",
                              nopropTaxes = F, noInvTaxes = F, SeriesITCRate = "ITCRate"){
  
  if (noInvTaxes){
    indicatorT_X = 0
  }
  else{
    indicatorT_X = 1
  }
  if (nopropTaxes){
    indicatorT_PROP = 0
  }
  else{
    indicatorT_PROP = 1
  }
  
  
  # Compute C-Corp Taxes-----------
  
  
  dataTable[, RatesToUse_C := get(SeriesRatesToUse )]
  
  dataTable[, recWedge_C := (1 - get(SeriesTAU_H_C))^(-1) *( 
    (RatesToUse_C + delta_tilde)/RatesToUse_C * 
      ( 1  - PDV_DEPR * get(SeriesT_c) -
        ((1 - (PDV_DEPR == 1))) * get(SeriesITCRate) ) /
      (1 - get(SeriesT_c)) - delta_tilde/RatesToUse_C
  )   ]
  
  dataTable[, recWedge_C_NoB := (1 - get(SeriesTAU_H_C))^(-1) *( 
    (RatesToUse_C + delta_tilde)/RatesToUse_C *
      ( 1  - PDV_DEPR_No_Bonus *  get(SeriesT_c)  -
          get(SeriesITCRate)) / (1 -  get(SeriesT_c)) - delta_tilde/RatesToUse_C
  )   ]
  
  dataTable[, T_C_NET := 1 - 1/recWedge_C] 
  dataTable[, T_C_NET_NoB := 1 - 1/recWedge_C_NoB   ]
  
  
  # Compute S-Corp Taxes-----------
  
  dataTable[, recWedge_S :=
              ((get(SeriesRatesToUse) + delta_tilde)/get(SeriesRatesToUse)) * ( 
                1 - PDV_DEPR *  get(SeriesTAU_CH_S)  - 
                  (1 - (PDV_DEPR == 1)) * get(SeriesITCRate)) /
              (1 -  get(SeriesTAU_CH_S)) - delta_tilde/get(SeriesRatesToUse)   ]
  dataTable[, recWedge_S_noB := 
              ((get(SeriesRatesToUse) + delta_tilde)/get(SeriesRatesToUse))  * ( 
                1- PDV_DEPR_No_Bonus *  get(SeriesTAU_CH_S)  - 
                   get(SeriesITCRate) ) / (1 -  get(SeriesTAU_CH_S)) - delta_tilde/get(SeriesRatesToUse)   ] 
  
  
  dataTable[, T_S_NET := 1 - 1/recWedge_S  ]
  dataTable[, T_S_NET_NoB := 1 - 1/recWedge_S_noB  ]
  
  # Compute NON-Corp Taxes-----------
  
  dataTable[, recWedge_NC := 
              (get(SeriesRatesToUse) + delta_tilde)/get(SeriesRatesToUse) * ( 
                1- PDV_DEPR *  get(SeriesT_NC)  - 
                  ((1 - (PDV_DEPR == 1))) * get(SeriesITCRate) ) / (1 -  get(SeriesT_NC)) - delta_tilde/(get(SeriesRatesToUse) )
            ]
  dataTable[, recWedge_NC_noB := 
              (get(SeriesRatesToUse) + delta_tilde)/get(SeriesRatesToUse) *
              ( 1 - PDV_DEPR_No_Bonus *  get(SeriesT_NC) -
                  get(SeriesITCRate) ) / (1 -  get(SeriesT_NC)) - delta_tilde/(get(SeriesRatesToUse) )
            ]
 
  
  dataTable[, T_NC_NET := 1 - 1/recWedge_NC  ]
  dataTable[, T_NC_NET_NoB := 1 - 1/recWedge_NC_noB  ]
  
  
  # COMPUTE WEDGES FOR DEBT FINANCING-------------
  
  
  # NOTE : The ITC applies IFF there is no full expensing
  # Compute C-Corp Taxes-----------
  
  
  dataTable[, RatesToUse_C := get(SeriesRatesToUseB)]
  
  dataTable[, recWedge_C := (1 - get(SeriesTAU_H_C_B))^(-1) *( 
    (RatesToUse_C *(1 - get(SeriesT_c)) + delta_tilde)/RatesToUse_C * (
      1  - PDV_DEPR * get(SeriesT_c)  - 
        ((1 - (PDV_DEPR == 1))) *get(SeriesITCRate) ) /
      (1 - get(SeriesT_c)) - delta_tilde/RatesToUse_C
  )   ]
  
  dataTable[, recWedge_C_NoB := (1 - get(SeriesTAU_H_C_B))^(-1) *( 
    (RatesToUse_C *(1 - get(SeriesT_c))  + delta_tilde)/RatesToUse_C * 
      ( 1  - PDV_DEPR_No_Bonus *  get(SeriesT_c)  -
          get(SeriesITCRate)) / (1 -  get(SeriesT_c)) - delta_tilde/RatesToUse_C
  )   ]
  
  
  dataTable[, T_C_NET_BOND := 1 - 1/recWedge_C] 
  dataTable[, T_C_NET_NoB_BOND := 1 - 1/recWedge_C_NoB   ]
  
  # Compute S-Corp Taxes-----------
  
  dataTable[, recWedge_S := (1 - get(SeriesTAU_CH_S_B))^(-1) *
              (((get(SeriesRatesToUseB) *(1 - get(SeriesTAU_CH_S)) + delta_tilde)/get(SeriesRatesToUseB)) * 
                 ( 1 - PDV_DEPR *  get(SeriesTAU_CH_S)- 
                     ((1 - (PDV_DEPR == 1))) *  get(SeriesITCRate)) 
               / (1 -  get(SeriesTAU_CH_S)) - delta_tilde/get(SeriesRatesToUseB))   ]
  dataTable[, recWedge_S_noB := (1 - get(SeriesTAU_CH_S_B))^(-1) *
              (((get(SeriesRatesToUseB) *(1 - get(SeriesTAU_CH_S)) + delta_tilde)/get(SeriesRatesToUseB)) *
                 ( 1- PDV_DEPR_No_Bonus *  get(SeriesTAU_CH_S)  -
                     get(SeriesITCRate) ) / (1 -  get(SeriesTAU_CH_S)) - delta_tilde/get(SeriesRatesToUseB))   ] 
  
  dataTable[, T_S_NET_BOND := 1 - 1/recWedge_S  ]
  dataTable[, T_S_NET_NoB_BOND := 1 - 1/recWedge_S_noB  ]
  
  # Compute NON-Corp Taxes-----------
  
  dataTable[, recWedge_NC := (1 -  get(SeriesT_NC))^(-1) *
              ( (get(SeriesRatesToUseB) * (1 -  get(SeriesT_NC))+ delta_tilde)/get(SeriesRatesToUseB)  * (
                1- PDV_DEPR *  get(SeriesT_NC) -
                  ((1 - (PDV_DEPR == 1))) * get(SeriesITCRate) ) /
                  (1 -  get(SeriesT_NC)) - delta_tilde/(get(SeriesRatesToUseB) ))
            ]
  dataTable[, recWedge_NC_noB :=  (1 -  get(SeriesT_NC))^(-1) *
              ((get(SeriesRatesToUseB) * (1 -  get(SeriesT_NC)) + delta_tilde)/get(SeriesRatesToUseB) * 
                 ( 1 - PDV_DEPR_No_Bonus *  get(SeriesT_NC)  -
                     get(SeriesITCRate) ) / (1 -  get(SeriesT_NC)) - delta_tilde/(get(SeriesRatesToUseB) ))
            ]
  
  
  dataTable[, T_NC_NET_BOND := 1 - 1/recWedge_NC  ]
  dataTable[, T_NC_NET_NoB_BOND := 1 - 1/recWedge_NC_noB  ]
  

  # Summarize by type including categories-----------
  
  
  WedgeDataLoop = dataTable[ !is.na(DetCategory), ]
  
  # AGGREGATION BY DIFFERENT LEVELS -------------
  
  # Columns to drop (cleanup)
  
  colsAvg = setdiff(colnames(WedgeDataLoop), c("Year", "Category", "Subcategory", "DetCategory", "Type"))
  
  # Categories Classification
  catClasses = setDT(unique(WedgeDataLoop[!is.na(Subcategory), c("Category", "DetCategory", "Subcategory")]))
  catClasses = catClasses[!is.na(DetCategory),]
  
  
  # average by categories
  tableAvgCat = WedgeDataLoop[, lapply(.SD, weighted.mean, INV, na.rm = TRUE ) ,
                              .SDcols  = colsAvg,
                              by = c("Category", "Year")]
  tableAvgCat[, c("Type") := NULL]
  setnames(tableAvgCat, "Category", "Type")
  tableAvgCat = tableAvgCat[, Category := Type]
  
  tableDetCat = WedgeDataLoop[, lapply(.SD, weighted.mean, INV, na.rm = TRUE ) ,
                              .SDcols  = colsAvg,
                              by = c("DetCategory", "Year")]
  tableDetCat[, c("Type") := NULL]
  setnames(tableDetCat, "DetCategory", "Type")
  tableDetCat = tableDetCat[, DetCategory := Type]
  # Recover category and subcategory
  tableDetCat = tableDetCat[catClasses,  on=.(DetCategory = DetCategory)]
  
  tableSubCat = WedgeDataLoop[, lapply(.SD, weighted.mean, INV, na.rm = TRUE ) ,
                              .SDcols  = colsAvg,
                              by = c("Subcategory", "Year")]
  tableSubCat[, c("Type") := NULL]
  setnames(tableSubCat, "Subcategory", "Type")
  tableSubCat = tableSubCat[, Subcategory := Type]
  # Recover Categories
  tableSubCat = tableSubCat[unique(catClasses[, c("Category", "Subcategory")]),
                            on=.(Subcategory = Subcategory)]
  
  WedgeAvgs = rbind(WedgeDataLoop, tableAvgCat, tableDetCat, tableSubCat, fill = TRUE)
  
  
  # COMPUTE AVERAGES WITH DIFFERENT ASSUMPTIONS --------------------
  
  # AVERAGES ACCOUNTING FOR DEBT FINANCING
  WedgeAvgs = WedgeAvgs[ , T_C_NET_AVG:= (1 - Debt_fin_C_Corp) * T_C_NET + Debt_fin_C_Corp * T_C_NET_BOND]
  WedgeAvgs = WedgeAvgs[ , T_S_NET_AVG:= (1 - Debt_fin_S_Corp) * T_S_NET + Debt_fin_S_Corp * T_S_NET_BOND]
  WedgeAvgs = WedgeAvgs[ , T_NC_NET_AVG:= (1 - Debt_fin_Non_Corp) * T_NC_NET + Debt_fin_Non_Corp * T_NC_NET_BOND]
  
  # OVERALL AVERAGE WITH DEBT FINANCING
  WedgeAvgs = WedgeAvgs[, T_NET_AVG :=  T_C_NET_AVG * SHARE_NI_C + T_S_NET_AVG * SHARE_NI_S + T_NC_NET_AVG * SHARE_NI_NC]
  
  # OVERALL AVERAGE WITHOUT DEBT FINANCING
  WedgeAvgs = WedgeAvgs[, T_NET_AVG_NO_DEBT :=  T_C_NET * SHARE_NI_C + T_S_NET * SHARE_NI_S + T_NC_NET * SHARE_NI_NC]
  
  # WITHOUT BONUSES
  WedgeAvgs = WedgeAvgs[ , T_C_NET_AVG_NoB:= (1 - Debt_fin_C_Corp) * T_C_NET_NoB + Debt_fin_C_Corp * T_C_NET_NoB_BOND]
  WedgeAvgs = WedgeAvgs[ , T_S_NET_AVG_NoB:= (1 - Debt_fin_S_Corp) * T_S_NET_NoB + Debt_fin_S_Corp * T_S_NET_NoB_BOND]
  WedgeAvgs = WedgeAvgs[ , T_NC_NET_AVG_NoB:= (1 - Debt_fin_Non_Corp) * T_NC_NET_NoB + Debt_fin_Non_Corp * T_NC_NET_NoB_BOND]
  
  # OVERALL AVERAGE WITH DEBT FINANCING
  WedgeAvgs = WedgeAvgs[, T_NET_AVG_NoB :=  T_C_NET_AVG_NoB * SHARE_NI_C + T_S_NET_AVG_NoB * SHARE_NI_S + T_NC_NET_AVG_NoB * SHARE_NI_NC]
  
  # OVERALL AVERAGE WITHOUT DEBT FINANCING
  WedgeAvgs = WedgeAvgs[, T_NET_AVG_NO_DEBT_NoB :=  T_C_NET_NoB * SHARE_NI_C + T_S_NET_NoB * SHARE_NI_S + T_NC_NET_NoB * SHARE_NI_NC]
  
  
  return(WedgeAvgs)
  
  
}




compute.avgWedges.capitalizeTax.Bond <- function(dataTable, SeriesTAU_H_C = "TAU_H_C", 
                                            SeriesTAU_CH_S = "TAU_CH_S", SeriesTAU_CH_S_B = "TAU_CH_S_B",
                                            SeriesT_c = "T_c",
                                            SeriesT_NC = "T_INC", SeriesRatesToUse = "RatesToUse_B",
                                            nopropTaxes = F, noInvTaxes = F, SeriesITCRate = "ITCRate"){
  
  if (noInvTaxes){
    indicatorT_X = 0
  }
  else{
    indicatorT_X = 1
  }
  if (nopropTaxes){
    indicatorT_PROP = 0
  }
  else{
    indicatorT_PROP = 1
  }
  
  
  # NOTE : The ITC applies IFF there is no full expensing
  # Compute C-Corp Taxes-----------
  
  
  dataTable[, RatesToUse_C := get(SeriesRatesToUse)]
  
  dataTable[, recWedge_C := (1 - get(SeriesTAU_H_C))^(-1) *( 
    (RatesToUse_C *(1 - get(SeriesT_c)) + delta_tilde)/RatesToUse_C * (
        1  - PDV_DEPR * get(SeriesT_c)  - 
          ((1 - (PDV_DEPR == 1))) *get(SeriesITCRate) ) /
      (1 - get(SeriesT_c)) - delta_tilde/RatesToUse_C
  )   ]
  
  dataTable[, recWedge_C_NoB := (1 - get(SeriesTAU_H_C))^(-1) *( 
    (RatesToUse_C *(1 - get(SeriesT_c))  + delta_tilde)/RatesToUse_C * 
      ( 1  - PDV_DEPR_No_Bonus *  get(SeriesT_c)  -
          get(SeriesITCRate)) / (1 -  get(SeriesT_c)) - delta_tilde/RatesToUse_C
  )   ]
  
  
  dataTable[, T_C_NET_BOND := 1 - 1/recWedge_C] 
  dataTable[, T_C_NET_NoB_BOND := 1 - 1/recWedge_C_NoB   ]
  
  # Compute S-Corp Taxes-----------
  
  dataTable[, recWedge_S := (1 - get(SeriesTAU_CH_S_B))^(-1) *
              (((get(SeriesRatesToUse) *(1 - get(SeriesTAU_CH_S)) + delta_tilde)/get(SeriesRatesToUse)) * 
                 ( 1 - PDV_DEPR *  get(SeriesTAU_CH_S)- 
                     ((1 - (PDV_DEPR == 1))) *  get(SeriesITCRate)) 
              / (1 -  get(SeriesTAU_CH_S)) - delta_tilde/get(SeriesRatesToUse))   ]
  dataTable[, recWedge_S_noB := (1 - get(SeriesTAU_CH_S_B))^(-1) *
              (((get(SeriesRatesToUse) *(1 - get(SeriesTAU_CH_S)) + delta_tilde)/get(SeriesRatesToUse)) *
              ( 1- PDV_DEPR_No_Bonus *  get(SeriesTAU_CH_S)  -
                  get(SeriesITCRate) ) / (1 -  get(SeriesTAU_CH_S)) - delta_tilde/get(SeriesRatesToUse))   ] 
  
  dataTable[, T_S_NET_BOND := 1 - 1/recWedge_S  ]
  dataTable[, T_S_NET_NoB_BOND := 1 - 1/recWedge_S_noB  ]
  
  # Compute NON-Corp Taxes-----------
  
  dataTable[, recWedge_NC := (1 -  get(SeriesT_NC))^(-1) *
             ( (get(SeriesRatesToUse) * (1 -  get(SeriesT_NC))+ delta_tilde)/get(SeriesRatesToUse)  * (
                   1- PDV_DEPR *  get(SeriesT_NC) -
                     ((1 - (PDV_DEPR == 1))) * get(SeriesITCRate) ) /
                 (1 -  get(SeriesT_NC)) - delta_tilde/(get(SeriesRatesToUse) ))
            ]
  dataTable[, recWedge_NC_noB :=  (1 -  get(SeriesT_NC))^(-1) *
              ((get(SeriesRatesToUse) * (1 -  get(SeriesT_NC)) + delta_tilde)/get(SeriesRatesToUse) * 
                 ( 1 - PDV_DEPR_No_Bonus *  get(SeriesT_NC)  -
                     get(SeriesITCRate) ) / (1 -  get(SeriesT_NC)) - delta_tilde/(get(SeriesRatesToUse) ))
            ]
  
  
  dataTable[, T_NC_NET_BOND := 1 - 1/recWedge_NC  ]
  dataTable[, T_NC_NET_NoB_BOND := 1 - 1/recWedge_NC_noB  ]
  
  
  # Summarize by type including categories-----------
  
  
  WedgeDataLoop = dataTable[ !is.na(DetCategory), ]
  
  # AGGREGATION BY DIFFERENT LEVELS -------------
  
  # Columns to drop (cleanup)
  
  colsAvg = setdiff(colnames(WedgeDataLoop), c("Year", "Category", "Subcategory", "DetCategory", "Type"))
  
  # Categories Classification
  catClasses = setDT(unique(WedgeDataLoop[!is.na(Subcategory), c("Category", "DetCategory", "Subcategory")]))
  catClasses = catClasses[!is.na(DetCategory),]
  
  
  
  # average by categories
  tableAvgCat = WedgeDataLoop[, lapply(.SD, weighted.mean, INV, na.rm = TRUE ) ,
                              .SDcols  = colsAvg,
                              by = c("Category", "Year")]
  tableAvgCat[, c("Type") := NULL]
  setnames(tableAvgCat, "Category", "Type")
  tableAvgCat = tableAvgCat[, Category := Type]
  
  tableDetCat = WedgeDataLoop[, lapply(.SD, weighted.mean, INV, na.rm = TRUE ) ,
                              .SDcols  = colsAvg,
                              by = c("DetCategory", "Year")]
  tableDetCat[, c("Type") := NULL]
  setnames(tableDetCat, "DetCategory", "Type")
  tableDetCat = tableDetCat[, DetCategory := Type]
  # Recover category and subcategory
  tableDetCat = tableDetCat[catClasses,  on=.(DetCategory = DetCategory)]
  
  tableSubCat = WedgeDataLoop[, lapply(.SD, weighted.mean, INV, na.rm = TRUE ) ,
                              .SDcols  = colsAvg,
                              by = c("Subcategory", "Year")]
  tableSubCat[, c("Type") := NULL]
  setnames(tableSubCat, "Subcategory", "Type")
  tableSubCat = tableSubCat[, Subcategory := Type]
  # Recover Categories
  tableSubCat = tableSubCat[unique(catClasses[, c("Category", "Subcategory")]),
                            on=.(Subcategory = Subcategory)]
  
  WedgeAvgs = rbind(WedgeDataLoop, tableAvgCat, tableDetCat, tableSubCat, fill = TRUE)
  
  
  
  
  
  
  return(WedgeAvgs)
  
  
}




