function [out] = ...
    ramsey_constrained_p(tau_bar, g, params)

out.params = params;
out.g = g;
out.tau_ell = tau_bar;

index_guess = params.index_guess;
indices = params.indices;
grid_ak = (params.A) ^ ((1 - params.lambda)/params.lambda) * ...
    params.grid_ak_ex_A;
grid_al = params.grid_al;
lambda = params.lambda;
B = params.B;
elast_ell = params.elast_ell;
D = params.D;
elast_k = params.elast_k;
varrho = params.varrho;
varrho_k = params.varrho_k;
maxIter = params.maxIter;
delta = params.delta;
E = params.E;
%% Method 1: Iterate on task index : exploits monotonicity of output in theta
theta_index = index_guess;
start_ell = 0.1;
start_k = 0.1;
index_series = index_guess;
stop = 1;
iter = 0;

while iter < maxIter && stop > 0
    %Step 1: Solve system for given taxes and guess
    options = optimset('Display','off');
    obj = @(x)objective_planner_p(x, theta_index, params);
    ic = @(x)implementability_condition_and_tau_bar_p(x,...
        tau_bar, varrho, g, theta_index, params);
    [x_sol, ~, ~, ~, lambda_mult, ~, ~] = ...
        fmincon(obj, [start_ell start_k],[],[],[],[],[0 0], [], ic, options); 
    ell_sol = x_sol(1);
    k_sol = x_sol(2);

    %Step 2: Compute optimal task partition given k and ell. Use theory: effect
    %through constraint matters.

    %compute mu and gamma
    mu = lambda_mult.ineqnonlin(1);
    gamma = lambda_mult.ineqnonlin(2);

    y_vector = output_raw_p(ell_sol, k_sol, indices, params) + ...
        (gamma/(1 + mu)) * (1 - tau_bar) * (1 - varrho) * ...
        grid_al .* (output_raw_p(ell_sol, k_sol, indices, params) / ell_sol).^(1/lambda);
    [~, new_index] = max(y_vector);

    %Step 3 iterate
    iter = iter+1;
    index_series = [index_series new_index];
    start_ell = ell_sol;
    start_k = k_sol;
    stop = abs(theta_index - new_index);
    theta_index = new_index;
end

%Assign results
ell = ell_sol;
k = k_sol;

%Infer taxes and multipliers
ak = grid_ak(theta_index);
al = grid_al(theta_index);
y = output_raw_p(ell_sol, k_sol, theta_index, params);

tau_ell = 1 - ( B * ell^(elast_ell) ) /...
    ((1 - varrho) * al * (y/ell)^(1/lambda) );
tau_k = 1 - (E * D * k^(elast_k)) / ((1-varrho_k) * (ak * (y/k)^(1/lambda) - delta));

revenue =  tau_ell * ell * al * (y/ell)^(1/lambda) + ...
    tau_k * k * (ak * (y/k)^(1/lambda) - delta);


mu = lambda_mult.ineqnonlin(1);
gamma = lambda_mult.ineqnonlin(2);

labor_share = ell * al * (y/ell)^(1/lambda)/y;

r_firms = ak * (y/k)^(1/lambda);

w_firms = al * (y/ell)^(1/lambda);


%% PLANNER'S OBJECTIVE
    function objective = objective_planner_p(x, theta_index, params)
    % the planner chooses (k, ell, theta)

    ell = x(1);
    k = x(2);
    y = output_raw_p(ell, k, theta_index, params);

    %Computes minus utility
    objective = B * ell^(1 + elast_ell)/( 1 + elast_ell) + ...
        E * D * ( k^(1+elast_k) / (1+elast_k)) - y + delta * k;

    end

%% IMPLEMENTABILITY CONDITION WITH CONSTRAINT ON LABOR TAX 
    function [c,ceq] = ...
            implementability_condition_and_tau_bar_p(x, tau_bar, varrho,...
            g, theta_index, params)

    ell = x(1);
    k = x(2);
    y = output_raw_p(ell, k, theta_index, params);
    al = grid_al(theta_index);

    %Computes IC
    c=[-y + B * ell^(1 + elast_ell) / (1 - varrho) + E * D * k^(1 + elast_k)/ (1 - varrho_k) + delta * k + g,...
        B * ell^(elast_ell) - (1 - tau_bar) * (1 - varrho) * al * (y/ell)^(1/lambda) ];
    ceq=[];
    end


out.ell = ell;
out.k = k;
out.y = y;
out.theta_index = theta_index;
out.tau_k = tau_k;
out.tau_ell = tau_ell;
out.revenue = revenue;

out.labor_share = labor_share;
out.r = r_firms;
out.w = w_firms;
out.index_series = index_series;

out.mu = mu;
out.gamma = gamma;

out.theta = params.grid_theta(theta_index);
out.implicit_tax= ...
    1 - (r_firms / w_firms) * ...
    params.grid_phi_l(theta_index) / params.grid_phi_k(theta_index);

out.welfare = (out.y + (1 - delta) * out.k) - ...
    params.B * (out.ell^ ( 1 + params.elast_ell)) / ( 1 + params.elast_ell) - ...
    params.D * ( E * (out.k ^ ( 1 + params.elast_k)) / ( 1 + params.elast_k) + out.k);
    
out.net_output = out.y - delta * out.k;

end