function [out] = ...
    ramsey_constrained_nodistort_tau_ell(tau_bar_k, g, params)

out.params = params;
out.g = g;

indices = params.indices;
grid_ak = (params.A) ^ ((1 - params.lambda)/params.lambda) * ...
    params.grid_ak_ex_A;
grid_al = params.grid_al;
lambda = params.lambda;
B = params.B;
elast_ell = params.elast_ell;
D = params.D;
elast_k = params.elast_k;
varrho = params.varrho;
delta = params.delta;
E = params.E;


%Step 1: Solve system for given taxes and guess
start_ell = params.start_ell;
start_k = params.start_k;
options = optimset('Display','off');
obj = @(x)objective_planner_market_nodistort_p(x, params);
ic = @(x)...
    implementability_condition_and_tau_bar_nodistort_p(x, tau_bar_k, g, params);

[x_sol, ~, exitflag] = ...
    fmincon(obj,[start_ell start_k],[],[],[],[],[0 0], [], ic,options); 
ell_sol=x_sol(1);
k_sol=x_sol(2);

if exitflag~=1
    warning('No Solution found')
end
%Assign results
ell = ell_sol;
k = k_sol;
y_vector = output_raw_p(ell_sol,k_sol,indices, params);
[y, theta_index] = max(y_vector);

%Infer taxes and multipliers
ak = grid_ak(theta_index);
al = grid_al(theta_index);

tau_ell = 1 - ( B*ell^(elast_ell) ) /...
    ((1 - varrho) * al * (y/ell)^(1/lambda) );
tau_k = 1 - (D* E * k^(elast_k)) / (ak * (y/k)^(1/lambda) - delta);

revenue = tau_ell * ell * al * (y/ell)^(1/lambda) + ...
    tau_k * k * (ak * (y/k)^(1/lambda) - delta);
% 
% mu = lambda_mult.ineqnonlin(1);
% gamma = lambda_mult.ineqnonlin(2);

labor_share = ell * al * (y/ell)^(1/lambda)/y;

r_firms = ak * (y/k)^(1/lambda);

w_firms = al * (y/ell)^(1/lambda);


out.ell = ell;
out.k = k;
out.y = y;
out.theta_index = theta_index;
out.tau_k = tau_k;
out.tau_ell = tau_ell;
out.revenue = revenue;

out.labor_share = labor_share;
out.r = r_firms;
out.w = w_firms;
% 
% out.mu = mu;
% out.gamma = gamma;

out.theta = params.grid_theta(theta_index);
out.implicit_tax= ...
    1 - (r_firms / w_firms) * ...
    params.grid_phi_l(theta_index) / params.grid_phi_k(theta_index);

out.welfare = (out.y + (1 - delta) * out.k) - ...
    params.B * (out.ell^ ( 1 + params.elast_ell)) / ( 1 + params.elast_ell) - ...
    params.D * (E * (out.k ^ ( 1 + params.elast_k)) / ( 1 + params.elast_k) + out.k);

out.net_output = out.y - delta * out.k;
%% PLANNER'S OBJECTIVE
    function objective = objective_planner_market_nodistort_p(x, params)
        % Inputs are ell and k, the market maximizes over theta

        elll = x(1);
        kk = x(2);
        y_vectorr = output_raw_p(elll, kk, indices, params);
        % maximization of output wrt to theta: The market chooses
        yy = max(y_vectorr);

        %Computes minus utility
        objective = B * elll^(1 + elast_ell) / (1 + elast_ell) + ...
            D * E * kk^(1 + elast_k)/(1 + elast_k) - (yy  - delta * kk);

    end

%% IMPLEMENTABILITY CONDITION WITH CONSTRAINT ON LABOR TAX 
    function [c,ceq] = ...
            implementability_condition_and_tau_bar_nodistort_p(x, tau_bar_k, g, params)
        % Planner chooses ell and k, leaves theta to the market
        elll = x(1);
        kk = x(2);
        y_vectorr = output_raw_p(elll, kk, indices, params);
        % market choice of theta to maximize output
        [yy, theta_indexx] = max(y_vectorr);
        % corresponding labor productivity term
        akk = grid_ak(theta_indexx);
        tau_kk = 1 - (D * E * kk^(elast_k)) / (akk * (yy/kk)^(1/lambda) - delta);

        %Computes IC + No-labor-reform constraint
        c =  - (yy - delta * kk) + B * elll^(1 + elast_ell) / (1 - varrho) + D *( E * kk^(1 + elast_k)) + g ;
        ceq = - tau_bar_k + tau_kk;        % keep same overall capital tax and make same revenue

        % For some reason the following, although equivalent at solution.
        %         ceq = ... 
%         [-tau_bar_k + tau_kk, ...
%             -yy + B * elll^(1 + elast_ell) / (1 - varrho) + ...
%             D * kk^(1 + elast_k) + g];
    


    end



end