function y = output_raw_K_comp(ell, K, theta_index, params)
% Plots output as a function of theta for different aggregate quantities of
% labor and capital

grid_ak = (params.A) ^ ((1 - params.lambda)/params.lambda) * ...
    params.grid_ak_ex_A;
grid_al = params.grid_al;
lambda = params.lambda;
alphaa = params.alpha;
scale = 1;
k_guess = K/2;
fsolve_opts = optimset('Display','off');

ak = grid_ak(theta_index);
al = grid_al(theta_index);


obj = @(k) ( ...
    ak .* k.^((lambda-1)/lambda) + ...
    al * ( (K - k).^(1 - alphaa) .*  ell.^ alphaa ).^((lambda - 1)/ lambda)...
    ).^(lambda / (lambda - 1));

% sigmoid in 0, K
transform = @(x) (K)./(1 + scale * exp( - x));
inverse_transform = @ (y) - log((K/y - 1)/scale);

k_0_fsolve = inverse_transform(k_guess);
obj_fsolve = @(x) - obj(transform(x)); % incorporate transformation into function

[~, fval, exitflag] = fminsearch(obj_fsolve,...
    k_0_fsolve, fsolve_opts);

if exitflag ~=1
    warning('No solution for capital allocation found')
end

y= - fval;

end