function [out] = ...
    market_eq_p_tauA(tau_ell,tau_k_target, tau_A, params, options)
% Compute the market equilibrium
% Calls:
% - factor_market_p : nested below
% - output_raw_p : computing output for given theta

tau_k = tau_k_target - tau_A;
out.params = params;
out.tau_ell = tau_ell;
out.tau_k = tau_k;
%revenue w_f w_h r_f r_h

index_guess = params.index_guess;
indices = params.indices;
grid_ak = (params.A) ^ ((1 - params.lambda)/params.lambda) * ...
    params.grid_ak_ex_A;
grid_al = params.grid_al;
lambda = params.lambda;
B = params.B;
elast_ell = params.elast_ell;
D = params.D;
elast_k = params.elast_k;
varrho = params.varrho;
maxIter = params.maxIter;
grid_theta = params.grid_theta;
delta = params.delta;
E = params.E;



% SET UP TRANSFORMATION FOR THETA GRID
N_points = length(params.grid_theta);


if isfield(options,'scaling') 
    % scaling for the sigmoid, use a large number, otherwise solver gets
    % stuck if initial guess is too close to ends of interval
    % set less high if grid is reasonably fine and solution far from ends
    scaling = options.scaling;
else
    scaling = 1e1;
end

scale = N_points * scaling;

if isfield(options,'fsolve_opts') 
    % optimoptions
    fsolve_opts = options.fsolve_opts;
else
    fsolve_opts = optimset('Display','iter');
end

% CRUCIAL TRANSFORMATION: CONTINUOUS VARIABLE TO GRID FOR THETA
transform = @(x)  round(1 +  (N_points - 1)./(1 + scale * exp( - x)));

% "INVERSE" TRANSFORMATION TO FEED THE GUESS TO FSOLVE
inverse_transform = @ (y) - log(( 1/((y - 1)/(N_points - 1)) - 1)/scale);


%% Method 1: Iterate on task index
theta_index = index_guess;
start_ell = 1;
start_k = 1;
index_series = index_guess;
stop = 1;
iter = 0;

while iter < maxIter && stop > 0
    %Step 1: Solve system for given taxes and guess
    optionsSolve = optimset('Display','off');
    myfunction = @(x)factor_market_p(exp(x), tau_ell, tau_k, tau_A, varrho,...
       theta_index, params);

    % solve for labor and capital market equilibrium, for given theta_index
    % guess
    x_sol = fsolve(myfunction,log([start_ell start_k]),optionsSolve); 
    ell_sol = exp(x_sol(1));
    k_sol = exp(x_sol(2));
   
    funSolveTheta = @(theta_guess) ...
        solve_for_theta(theta_guess, ell_sol, k_sol, tau_A, params);
    
    optionsSolve = optimset('Display','off');
    theta_sol = fzero(funSolveTheta, [inverse_transform(2) inverse_transform(N_points - 2)], optionsSolve);
    
    
    new_index = transform(theta_sol);
    
    y = output_raw_p(ell_sol, k_sol, new_index, params);
    
    %Step 3 iterate
    iter = iter + 1;
    index_series = [index_series new_index];
    start_ell = ell_sol;
    start_k = k_sol;
    stop = abs(theta_index - new_index);
    theta_index = new_index;

end

if iter == maxIter
    warning('Maximum number of iterations reached, check index_series')
end

%Assign results
ell = ell_sol;
k = k_sol;

ak = grid_ak(theta_index);
al = grid_al(theta_index);

% Factor remunerations = marginal returns
r_firms = ak * (y/k)^(1/lambda);
w_firms = al * (y/ell)^(1/lambda);

revenue = tau_ell * ell * w_firms + ...
    tau_k * k * (r_firms - delta);

labor_share = ell * w_firms / y;


    %% FUNCTION TO COMPUTE EXCESS DEMAND
    function excess_demands = ...
        factor_market_p(x,tau_ell,tau_k, tau_A, varrho, theta_guess, params)

    grid_akk = (params.A) ^ ((1 - params.lambda)/params.lambda) * ...
    params.grid_ak_ex_A;
    grid_all = params.grid_al;
    lambdaa = params.lambda;
    BB = params.B;
    elast_elll = params.elast_ell;
    DD = params.D;
    elast_kk = params.elast_k;
    
    elll = x(1);
    kk = x(2);
    
   
    funSolveTheta = @(theta_guess) ...
        solve_for_theta(theta_guess, elll, kk, tau_A, params);
    
    optionsSolve = optimset('Display','off');
    theta_sol = fzero(funSolveTheta, [inverse_transform(2) inverse_transform(N_points - 2)], optionsSolve);
    
    theta_index = transform(theta_sol);
    
    akk = grid_akk(theta_index);
    all = grid_all(theta_index);
    yy = output_raw_p(elll, kk, theta_index, params);
    

    % Compute excess demands
    % - For labor
    excess_demands(1) = (1 - tau_ell) * (1 - varrho) * all * (yy/elll)^(1/lambdaa)...
        - BB * elll^(elast_elll);
    % - For Capital
    excess_demands(2) = (1 - tau_k)  * (akk * (yy/kk)^(1/lambdaa) - delta) - DD * E * kk^(elast_kk);

    end


% Assign output
out.ell = ell;
out.k = k;
out.y = y;
out.theta_index = theta_index;
out.revenue = revenue;
out.labor_share = labor_share;
out.r = r_firms;
out.w = w_firms;
out.index_series = index_series;

out.MRTS_rw = compute_MRTS_rw(ell, k, theta_index, params);
out.MRTS_rw_prime = compute_MRTS_rw(ell, 1.01*k, theta_index, params);

out.el_subs_rw = - ...
    (( log(out.MRTS_rw_prime) - log(out.MRTS_rw) )/...
    log(1.01) ) ^ (-1);


out.theta = params.grid_theta(theta_index);
out.implicit_tax= ...
    1 - (r_firms / (w_firms )) * ...
    params.grid_phi_l(theta_index) / params.grid_phi_k(theta_index);

out.welfare = (out.y + (1 - delta) * out.k) - ...
    params.B * (out.ell^ ( 1 + params.elast_ell)) / ( 1 + params.elast_ell) - ...
    params.D *( params.E * (out.k ^ ( 1 + params.elast_k)) / ( 1 + params.elast_k)) - out.k;

out.net_output = out.y - delta * out.k;
   function [MRTS_rw] = compute_MRTS_rw(ell, k, theta_index, params)
    % computes MRTS in a neighborhood of given allocation
    % change in MRTS
    
    
    options.fsolve_opts =  optimset('Display','off');
    % solve for the optimal theta
    obj_theta = @(y) - output_raw_p(ell, k, y, params);
    theta_index_opt = fmin_grid(obj_theta, theta_index, grid_theta,options);

    r = grid_ak(theta_index_opt) * ...
        (output_raw_p(ell, k, theta_index_opt, params)/k) ^ (1/lambda)/...
        output_raw_p(ell, k, theta_index_opt, params);
    w = params.grid_al(theta_index_opt) * ...
        (output_raw_p(ell, k, theta_index_opt, params)/ell) ^ (1/lambda)/...
        output_raw_p(ell, k, theta_index_opt, params);
    
    MRTS_rw = r/w;
    
   end

    %compute deviation from target tau_A as function of theta and given ell
    %and k
    function resid_theta = solve_for_theta(theta_guess, elll, kk, tau_A, params)
    
    grid_akk = (params.A) ^ ((1 - params.lambda)/params.lambda) * ...
    params.grid_ak_ex_A;
    grid_all = params.grid_al;
    lambdaa = params.lambda;
    BB = params.B;
    elast_elll = params.elast_ell;
    DD = params.D;
    elast_kk = params.elast_k;
        
        
    thetaa = transform(theta_guess);

    akk = grid_akk(thetaa);
    all = grid_all(thetaa);
    yy = output_raw_p(elll, kk, thetaa, params);
    r_firms = akk * (yy/kk)^(1/lambdaa);
    w_firms = all * (yy/elll)^(1/lambdaa);
    
    resid_theta = 1 - (r_firms / (w_firms )) * ...
        params.grid_phi_l(thetaa) / params.grid_phi_k(thetaa) - tau_A;

   
    end


end






