%% Step 0: Housekeeping %%
close all
clear
clc
current_path = pwd;
save_path_tables = '/Tables/';
save_path_fig = '/Figures/';
save_fig = [current_path save_path_fig];

source_data_path = ['/Users/andreamanera/Dropbox (MIT)/Research/'...
    'Brookings20/replicationKit/R/out/Data/'];


%% FIGURES SPECIFICATIONS
fontSize = 24;
fontSizeAx = 32;
% define a grid for theta around the market equilibrium
fig_width = 1600;               % Window Horizontal Size
fig_heigth = 900;               % Window Vertical Size
fig_posx = 100;                 % Window position (Lower left corner)
fig_posy = 100;                 % Window position (Lower left corner)


linewidth = 4;
thinWidth = 2.5;



%% FIGURE 1
TSo = readtable([source_data_path 'SoftWedges.csv']);
TEq = readtable([source_data_path 'EquipWedges.csv']);
TSt = readtable([source_data_path 'StructWedges.csv']);
TLabor = readtable([source_data_path 'laborTaxes.csv']);


years_to_label = [2018 2020 2020 2020];
rates_to_label = [ TLabor.T_H_BE(end) * 100, ...
    TEq.T_NET_AVG(end) * 100, ...
    TSt.T_NET_AVG(end) * 100, ...
    TSo.T_NET_AVG(end) * 100 + 1.8];
labels = {'Labor, $\tau^\ell$',... 
    'Equipment', ...
    'Structures', ...
    'Software'};


fig_name = 'Figure1_tax_rates_all';
h = figure('Position', [fig_posx fig_posy fig_width fig_heigth]);
set(gca,'TickLabelInterpreter', 'latex');
colors_graph = get(gca, 'ColorOrder');
hold on
plot(TLabor.Year,TLabor.T_H_BE * 100,  ...
    'linewidth', linewidth, 'color', colors_graph(1,:));
plot(TEq.Year,TEq.T_NET_AVG_NoB * 100,  ...
    'linewidth', thinWidth, ...
    'LineStyle', '-.','color', colors_graph(2,:));
plot(TSt.Year,TSt.T_NET_AVG_NoB * 100,  ...
    'linewidth', thinWidth, ...
     'LineStyle', '-.','color', colors_graph(3,:));
plot(TSo.Year,TSo.T_NET_AVG_NoB * 100,  ...
    'linewidth', thinWidth, ...
     'LineStyle', '-.','color', colors_graph(4,:));
plot(TEq.Year,TEq.T_NET_AVG * 100,  ...
    'linewidth', linewidth, 'color', colors_graph(2,:));
plot(TSt.Year,TSt.T_NET_AVG * 100,  ...
    'linewidth', linewidth, 'color', colors_graph(3,:));
plot(TSo.Year,TSo.T_NET_AVG * 100,  ...
    'linewidth', linewidth, 'color', colors_graph(4,:));
labelpoints(years_to_label, rates_to_label, labels, ...
'interpreter','latex', 'fontsize', fontSizeAx, 'position', 'S', ...
'color', colors_graph([1:4],:))
a = get(gca,'XTickLabel');
set(gca,'XTickLabel',a,'fontsize',fontSizeAx)
yticks(0:5:45) 
yticklabels(strcat('$', strsplit(num2str(0:5:45)), '\%$'))
ylabel('Average tax rate', ...
    'interpreter','latex', 'fontsize', fontSizeAx)
xlabel('Year',...
    'interpreter','latex', 'fontsize', fontSizeAx)

% SAVE FIGURE
saveas(h, [current_path save_path_fig fig_name '.png'])
saveas(h, [save_fig fig_name '.png'])


%% Figure A.1

TSo = readtable([source_data_path 'SoftDepr.csv']);
TEq = readtable([source_data_path 'EquipDepr.csv']);
TSt = readtable([source_data_path 'StructDepr.csv']);


years_to_label = [2018 2018];
rates_to_label = [ TSo.PDV_DEPR(end) * 100, ...
     TSo.PDV_ECON(end) * 100];
labels = {'IRS Depreciation',... 
    'Economic Depreciation'};
ticks = floor(min(TSo.PDV_ECON) * 100):1:ceil(max(TSo.PDV_DEPR) * 100);

fig_name = 'FigureA1_Soft';
h = figure('Position', [fig_posx fig_posy fig_width fig_heigth]);
set(gca,'TickLabelInterpreter', 'latex');
hold on
plot(TSo.Year, TSo.PDV_DEPR * 100,  ...
    'linewidth', linewidth, 'color', colors_graph(1,:),...
    'LineStyle', '-');
plot(TSo.Year, TSo.PDV_ECON * 100,  ...
    'linewidth', linewidth, 'color', colors_graph(2,:), ...
    'LineStyle', '-');
labelpoints(years_to_label, rates_to_label, labels, ...
'interpreter','latex', 'fontsize', fontSizeAx, 'position', 'N', ...
'color', colors_graph([1:2],:))
a = get(gca,'XTickLabel');
set(gca,'XTickLabel',a,'fontsize',fontSizeAx)
yticks(ticks) 
yticklabels(strcat('$', strsplit(num2str(ticks)), '\%$'))
ylabel('PDV of Average Software Depreciation', ...
    'interpreter','latex', 'fontsize', fontSizeAx)
xlabel('Year',...
    'interpreter','latex', 'fontsize', fontSizeAx)

% SAVE FIGURE2
saveas(h, [current_path save_path_fig fig_name '.png'])
saveas(h, [save_fig fig_name '.png'])

years_to_label = [2018 2018];
rates_to_label = [ TSt.PDV_DEPR(end) * 100, ...
     TSt.PDV_ECON(end) * 100];
labels = {'IRS Depreciation',... 
    'Economic Depreciation'};
ticks = floor(min(TSt.PDV_ECON) * 100):5:ceil(max(TSt.PDV_DEPR +1) * 100);

fig_name = 'FigureA1_Struct';
h = figure('Position', [fig_posx fig_posy fig_width fig_heigth]);
set(gca,'TickLabelInterpreter', 'latex');
hold on
plot(TSt.Year, TSt.PDV_DEPR * 100,  ...
    'linewidth', linewidth, 'color', colors_graph(1,:),...
    'LineStyle', '-');
plot(TSt.Year, TSt.PDV_ECON * 100,  ...
    'linewidth', linewidth, 'color', colors_graph(2,:), ...
    'LineStyle', '-');
labelpoints(years_to_label, rates_to_label, labels, ...
'interpreter','latex', 'fontsize', fontSizeAx, 'position', 'N', ...
'color', colors_graph([1:2],:))
a = get(gca,'XTickLabel');
set(gca,'XTickLabel',a,'fontsize',fontSizeAx)
yticks(ticks) 
yticklabels(strcat('$', strsplit(num2str(ticks)), '\%$'))
ylabel('PDV of Average Structure Depreciation', ...
    'interpreter','latex', 'fontsize', fontSizeAx)
xlabel('Year',...
    'interpreter','latex', 'fontsize', fontSizeAx)
% SAVE FIGURE A1
saveas(h, [current_path save_path_fig fig_name '.png'])
saveas(h, [save_fig fig_name '.png'])

years_to_label = [2018 2018];
rates_to_label = [ TEq.PDV_DEPR(end) * 100, ...
     TEq.PDV_ECON(end) * 100];
labels = {'IRS Depreciation',... 
    'Economic Depreciation'};
ticks = floor(min(TEq.PDV_ECON) * 100):2:ceil(max(TEq.PDV_DEPR) * 100);

fig_name = 'FigureA1_Equip';
h = figure('Position', [fig_posx fig_posy fig_width fig_heigth]);
set(gca,'TickLabelInterpreter', 'latex');
hold on
plot(TEq.Year, TEq.PDV_DEPR * 100,  ...
    'linewidth', linewidth, 'color', colors_graph(1,:),...
    'LineStyle', '-');
plot(TEq.Year, TEq.PDV_ECON * 100,  ...
    'linewidth', linewidth, 'color', colors_graph(2,:), ...
    'LineStyle', '-');
labelpoints(years_to_label, rates_to_label, labels, ...
'interpreter','latex', 'fontsize', fontSizeAx, 'position', 'N', ...
'color', colors_graph([1:2],:))
a = get(gca,'XTickLabel');
set(gca,'XTickLabel',a,'fontsize',fontSizeAx)
yticks(ticks) 
yticklabels(strcat('$', strsplit(num2str(ticks)), '\%$'))
ylabel('PDV of Average Equipment Depreciation', ...
    'interpreter','latex', 'fontsize', fontSizeAx)
xlabel('Year',...
    'interpreter','latex', 'fontsize', fontSizeAx)

% SAVE FIGURE
saveas(h, [current_path save_path_fig fig_name '.png'])
saveas(h, [save_fig fig_name '.png'])


%% FIGURE A.2
TFig1 = readtable([source_data_path 'CapitalIncomeTaxes.csv']);

years_to_label = [2016 2016 2016];
rates_to_label = [ TFig1.TAU_CH_C_baseline(7) * 100 - 2 ...
    TFig1.TAU_CH_S(end) * 100 - 5.5,...
    TFig1.T_INC(end) * 100 + 2];
labels = {'C-corp. equity income tax, $\tau^c + \tau^{h,c}$',...
    'S-corp. proprietors income tax, $\tau^{h,s}$', ...
    'Personal income tax, $\tau^{h}$'};


fig_name = 'FigureA2_tax_rates_capital';
h = figure('Position', [fig_posx fig_posy fig_width fig_heigth]);
set(gca,'TickLabelInterpreter', 'latex');
colors_graph = get(gca, 'ColorOrder');
hold on
plot(TFig1.Year, TFig1.TAU_CH_C_baseline * 100,  ...
    'linewidth', linewidth, 'color', colors_graph(1,:));
plot(TFig1.Year,TFig1.TAU_CH_S * 100,  ...
    'linewidth', linewidth, 'color', colors_graph(2,:));
plot(TFig1.Year,TFig1.T_INC * 100, ...
    'linewidth', linewidth, 'color', colors_graph(4,:));
labelpoints(years_to_label, rates_to_label, labels, ...
'interpreter','latex', 'fontsize', fontSizeAx, 'position', 'S', ...
'color', colors_graph([1:2 4],:))
a = get(gca,'XTickLabel');
set(gca,'XTickLabel',a,'fontsize',fontSizeAx)
yticks(0:5:60) 
yticklabels(strcat('$', strsplit(num2str(0:5:60)), '\%$'))
ylabel('Average tax rate', ...
    'interpreter','latex', 'fontsize', fontSizeAx)
xlabel('Year',...
    'interpreter','latex', 'fontsize', fontSizeAx)


% SAVE FIGURE
saveas(h, [current_path save_path_fig fig_name '.png'])
saveas(h, [save_fig fig_name '.png'])
cd([current_path save_path_fig])
fname = strcat(fig_name);
set(gcf,'PaperPositionMode','auto');
hgsave(fname);
print('-depsc',fname,'-painters');
cd(current_path)

%% FIGURE A.3 : NO DEBT
TSo = readtable([source_data_path 'SoftWedges.csv']);
TEq = readtable([source_data_path 'EquipWedges.csv']);
TSt = readtable([source_data_path 'StructWedges.csv']);
TLabor = readtable([source_data_path 'laborTaxes.csv']);


years_to_label = [2018 2020 2020 2020];
rates_to_label = [ TLabor.T_H_BE(end) * 100, ...
    TEq.T_NET_AVG_NO_DEBT(end) * 100, ...
    TSt.T_NET_AVG_NO_DEBT(end) * 100, ...
    TSo.T_NET_AVG_NO_DEBT(end) * 100 + 1.8];
labels = {'Labor, $\tau^\ell$',... 
    'Equipment', ...
    'Structures', ...
    'Software'};

fig_name = 'FigureA3_tax_rates_all_no_debt';
h = figure('Position', [fig_posx fig_posy fig_width fig_heigth]);
set(gca,'TickLabelInterpreter', 'latex');
hold on
plot(TLabor.Year,TLabor.T_H_BE * 100,  ...
    'linewidth', linewidth, 'color', colors_graph(1,:),...
    'LineStyle', ':');
plot(TEq.Year,TEq.T_NET_AVG_NO_DEBT_NoB * 100,  ...
    'linewidth', thinWidth, ...
    'LineStyle', '-.','color', colors_graph(2,:));
plot(TSt.Year,TSt.T_NET_AVG_NO_DEBT_NoB * 100,  ...
    'linewidth', thinWidth, ...
     'LineStyle', '-.','color', colors_graph(3,:));
plot(TSo.Year,TSo.T_NET_AVG_NO_DEBT_NoB * 100,  ...
    'linewidth', thinWidth, ...
     'LineStyle', '-.','color', colors_graph(4,:));
plot(TEq.Year,TEq.T_NET_AVG_NO_DEBT * 100,  ...
    'linewidth', linewidth, 'color', colors_graph(2,:));
plot(TSt.Year,TSt.T_NET_AVG_NO_DEBT * 100,  ...
    'linewidth', linewidth, 'color', colors_graph(3,:));
plot(TSo.Year,TSo.T_NET_AVG_NO_DEBT * 100,  ...
    'linewidth', linewidth, 'color', colors_graph(4,:));
labelpoints(years_to_label, rates_to_label, labels, ...
'interpreter','latex', 'fontsize', fontSizeAx, 'position', 'S', ...
'color', colors_graph([1:4],:))
a = get(gca,'XTickLabel');
set(gca,'XTickLabel',a,'fontsize',fontSizeAx)
yticks(0:5:45) 
yticklabels(strcat('$', strsplit(num2str(0:5:45)), '\%$'))
ylabel('Average tax rate', ...
    'interpreter','latex', 'fontsize', fontSizeAx)
xlabel('Year',...
    'interpreter','latex', 'fontsize', fontSizeAx)

% SAVE FIGURE
saveas(h, [current_path save_path_fig fig_name '.png'])
saveas(h, [save_fig fig_name '.png'])

