%% Step 0: Housekeeping %%
close all
clear
%clc
current_path = pwd;
save_path_tables = '/Tables/';
save_path_fig = '/Figures/';

%% Step 1: parametrization of basic parameters%%

main_par.N_tasks = 100000;
main_par.tau_current_labor = 0.255; % average labor tax
main_par.tau_current_capital = 0.1; % average capital wedge
main_par.tau_bar = main_par.tau_current_labor; %lower bound on labor taxation
main_par.varrho = .15;
main_par.delta = .055;

% SOLVER FOR A and zeta to match labor share and el. subs

A_zeta_E_guess = [   20.976617907612962; ...
   2.034427788124405; ...
   0.377961836037824];

labor_share_target = .56;
k_ratio_target = 3.32;
K_share_target = .3;
el_subs_target = 1.35;
weight_labor = .66; % weigh deviation from labor and k share
weight_share = .5; % weigh deviation from k - share over total shares weight

fun = @(a) target_deviations_K_share(exp(a), labor_share_target,  el_subs_target, ...
    K_share_target, main_par.tau_current_labor, main_par.tau_current_capital, main_par,...
    weight_labor, weight_share);


opts = optimset('Display', 'off');

% SOLUTION PART
[A_zeta_E_sol, fval, exitflag] = fminsearch(fun, log(A_zeta_E_guess), opts);
% [A_zeta_sol, fval, exitflag] = fsolve(fun, log(A_zeta_guess), opts)
A_zeta_E_sol = exp(A_zeta_E_sol);

if exitflag ~= 1
    disp('fmisearch failed')
end

main_par.A = A_zeta_E_sol(1);
main_par.zeta = A_zeta_E_sol(2);
main_par.E = A_zeta_E_sol(3);

params = setParams(main_par);
out_benchmark = market_eq_p(main_par.tau_current_labor,main_par.tau_current_capital, params);

disp('Baseline shares:')
disp(['Labor share: ' num2str(out_benchmark.labor_share)])
disp(['Net capital share: ' num2str(out_benchmark.net_k_share)])
disp(['Capital/output ratio: ' num2str(out_benchmark.k_ratio)])
disp(['El. subs.: ' num2str(out_benchmark.el_subs_rw)])

%% Store baseline for other calibrations
main_par_K_wedge = main_par;
main_par_K_wedge.varrho_k = .15;


main_parHC = main_par;
elasticityHC = 0.092;
elasticityLS_HC = 1./params.elast_ell * (1 + elasticityHC) + elasticityHC;
main_parHC.elast_ell = 1/elasticityLS_HC;

%% MAKE TABLE 1: Different solutions at current tax system


filename = [current_path save_path_tables 'Tab1_ResultsTable.tex'];
out_mkt = makeTable_KSR(main_par, 'table:main results', ...
    'Equilibrium under the current tax system and under other potential scenarios.', ...
    filename, labor_share_target, el_subs_target, K_share_target, weight_labor, weight_share);


% For the following tables, take market labor share and net capital share
% as benchmark, ignore el. subs
weight_labor_robustness = 1;
weight_share_robustness = .5;
labor_share_target_robustness = out_mkt.labor_share;
el_subs_target_robustness = out_mkt.el_subs_rw;
K_share_target_robustness = out_mkt.net_k_share;

%% MAKE TABLE 2: Reforms
filename = [current_path save_path_tables 'Tab2_ReformsTable.tex'];
out_mkt_Ref = mainTableReforms_KSR(main_par, 'table:reforms', ...
     'Comparison of observed tax reforms and reforms costing the same revenue.', ...
    filename, labor_share_target_robustness, el_subs_target_robustness, ...
    K_share_target_robustness, weight_labor_robustness, weight_share_robustness);

%% MAKE TABLE A.1: Distortions are present only at the extensive labor-supply margin (half rho)

main_par.tau_current_capital = .1; 
main_par.tau_current_labor = .255; 
main_par.tau_bar = main_par.tau_current_labor; %lower bound on labor taxation
main_par.varrho = .15/2;
filename = [current_path save_path_tables 'TabA4_ResultsTableExtElast.tex'];
out_mkt_lowelast = makeTable_KSR(main_par, 'apptable:extensive', ...
    'Robustness: with only extensive-margin distortions.', ...
    filename, labor_share_target_robustness, el_subs_target_robustness, ...
    K_share_target_robustness, weight_labor_robustness, weight_share_robustness);

%% MAKE TABLE A.2: Different solutions at current system,  labor with phase outs
main_par.varrho = .15;
main_par.tau_current_capital = .1; 
main_par.tau_current_labor = .335; 
main_par.tau_bar = main_par.tau_current_labor; %lower bound on labor taxation
filename = [current_path save_path_tables 'TabA1_ResultsTableHigherLaborTax.tex'];
out_mkt_highL = makeTable_KSR(main_par, 'apptable:displacement', ...
    'Robustness: including the implicit tax on labor from means-tested and disability programs.', ...
    filename, labor_share_target_robustness, el_subs_target_robustness, ...
    K_share_target_robustness, weight_labor_robustness, weight_share_robustness);

%% MAKE TABLE A.3: Different solutions at current system, no debt financing
% Run code mainTable_K_comp using different routines

%% MAKE TABLE A.4: Different solutions at current system, no debt financing
main_par.varrho = .15;
main_par.tau_current_labor = .255;
main_par.tau_bar = main_par.tau_current_labor;
main_par.tau_current_capital = .12; 
filename = [current_path save_path_tables 'TabA2_ResultsTableNoDebt.tex'];
out_mkt_noD = makeTable_KSR(main_par, 'apptable:nodebt', ...
    'Robustness: effective tax on capital for equity financing only.', ...
    filename, labor_share_target_robustness, el_subs_target_robustness, ...
    K_share_target_robustness, weight_labor_robustness, weight_share_robustness);


%% MAKE TABLE A.5: Capital wedge at 15%
filename = [current_path save_path_tables 'TabA3_ResultsTableCapWedge.tex'];
out_mkt_K_wedge = makeTable_KSR(main_par_K_wedge, 'apptable:capital wedge', ...
    'Robustness: capital wedge of 15\\%%.',...
    filename, labor_share_target_robustness, el_subs_target_robustness, ...
    K_share_target_robustness, weight_labor_robustness, weight_share_robustness);

%% MAKE TABLE A.6: nu=0
main_par.N_tasks = 100000;
main_par.tau_current_labor = 0.255; % average labor tax
main_par.tau_current_capital = 0.1; % average capital wedge
main_par.tau_bar = main_par.tau_current_labor; %lower bound on labor taxation
main_par.varrho = .15;
main_par.nu = 0;

filename = [current_path save_path_tables 'TabA5_ResultsNu0.tex'];
out_mkt_nu_0 = makeTable_KSR(main_par, 'apptable:comparative advantage', ...
    'Robustness: assuming labor has an absolute disadvantage at higher-indexed tasks.', ...
    filename, labor_share_target_robustness, el_subs_target_robustness, ...
    K_share_target_robustness, weight_labor_robustness, 0);

%% MAKE TABLE A.7: Human Capital
filename = [current_path save_path_tables 'TabA6_ResultsTableHC.tex'];
out_mkt_HC = makeTable_KSR(main_parHC, 'apptable:human capital', ...
    'Robustness: accounting for human capital responses.', ...
    filename, labor_share_target_robustness, el_subs_target_robustness, ...
    K_share_target_robustness, weight_labor_robustness, weight_share_robustness);

%% MAKE TABLE A.8: el k.=1
main_par.N_tasks = 100000;
main_par.tau_current_labor = 0.255; % average labor tax
main_par.tau_current_capital = 0.1; % average capital wedge
main_par.tau_bar = main_par.tau_current_labor; %lower bound on labor taxation
main_par.varrho = .15;
main_par.elast_ell = 1/.7;
main_par.elast_k = 1;
main_par.nu = 1;

filename = [current_path save_path_tables 'TabA7_ElK1.tex'];
out_mkt_el_k_1 = makeTable_KSR(main_par, 'apptable:capital elasticity', ...
    'Robustness: setting $\\protect\\epsilon^k=1$. ', ...
    filename, labor_share_target_robustness, el_subs_target_robustness, ...
    K_share_target_robustness, weight_labor_robustness, weight_share_robustness);


