function [sol_index, optional_out] = fmin_grid(fun, x_0, grid, options)
% Solve with fsolve on a discrete grid


% first transform the imput from the real line to the interval we want it
% to: use a sigmoid 
N_points = length(grid);

if isfield(options,'scaling') 
    % scaling for the sigmoid, use a large number, otherwise solver gets
    % stuck if initial guess is too close to ends of interval
    % set less high if grid is reasonably fine and solution far from ends
    scaling = options.scaling;
else
    scaling = 1e1;
end

if isfield(options,'fsolve_opts') 
    % optimoptions
    fsolve_opts = options.fsolve_opts;
else
    fsolve_opts = optimset('Display','off');
end

if isfield(options,'plot_solutions') 
    % scaling for the sigmoid, use a large number, otherwise solver gets
    % stuck if initial guess is too close to the ends of the grid
    plot_solutions = options.plot_solutions;
else
    plot_solutions = false;
end


if isfield(options,'solve_all_R') 
    % scaling for the sigmoid, use a large number, otherwise solver gets
    % stuck if initial guess is too close to the ends of the grid
    solve_all_R = options.solve_all_R;
else
    solve_all_R = false;
end


scale = N_points * scaling;

% DOMAIN TRANSFORMATION FOR F-SOLVE
%transform a real number into an index on our range: sigmoid function from
%1 to N_points
transform = @(x)  round(1 +  (N_points - 1)./(1 + scale * exp( - x)));

% INVERSE TRANSFORMATION TO FEED THE GUESS TO FSOLVE
inverse_transform = @ (y) - log(( 1/((y - 1)/(N_points - 1)) - 1)/scale);

x_0_fsolve = inverse_transform(x_0);

% Define the objective incorporating the transformation
obj_fsolve = @(x) fun(transform(x));



[sol_fmin, fval, exitflag] = fminsearch(obj_fsolve,...
    x_0_fsolve, fsolve_opts);
sol_index = transform(sol_fmin);
sol = grid(sol_index);

optional_out.exitflag = exitflag;
optional_out.sol = sol;
optional_out.fval = fval;

% if solve_all_R % also solve the function on full domain: Still not developed
%     [sol_all_R, fval_R] = fminsearch(fun, 0);
%     optional_out.sol_all_R = sol_all_R;
%     optional_out.fval_R = fval_R;
% 
%     if plot_solutions %produce a figure with the solution of the grid versus on all r
%         figure()
%         hold on
%         plot(grid((transform(sol_index) - 3):(transform(sol_index) + 3)),...
%             fun((transform(sol_index) - 3):(transform(sol_index) + 3)));
%         fplot(fun, [grid(transform(sol_index) - 1) ...
%             grid(transform(sol_index) + 1)]);
%         plot(sol_all_R,fun(sol_all_R), 'ob')
%         plot(sol,fval, 'ob')
%         hold off
%     end
% end
% 

end
